/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.energyPricesCollectors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class DataCollectorEnergyPricesCs
extends DataCollectorAbstractService {
    private final RestTemplate restTemplate;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final EventEntryManagerService eventEntryManagerService;

    @Autowired
    public DataCollectorEnergyPricesCs(InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService, RestTemplateBuilder restTemplateBuilder, EventEntryManagerService eventEntryManagerService) {
        super(infoDataManagerService);
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.restTemplate = restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(15L)).setReadTimeout(Duration.ofSeconds(15L)).build();
        this.eventEntryManagerService = eventEntryManagerService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HashMap<String, Map.Entry<String, String>> collectData() {
        try {
            ObjectMapper objectMapper;
            long currentTimeSeconds;
            String spotPricesCollector = this.sunnyConfigurationService.getSetting("spot_prices_collector");
            if (spotPricesCollector == null || !spotPricesCollector.equals("cz_ote")) {
                return new HashMap<String, Map.Entry<String, String>>();
            }
            String localCurrency = this.sunnyConfigurationService.getSetting("energy_currency");
            if (localCurrency == null) {
                localCurrency = "K\u010d";
            }
            InfoData todayData = super.getInfoDataManagerService().findByDataKey("energy_spot_price_today_1_hour");
            InfoData tomorrowData = super.getInfoDataManagerService().findByDataKey("energy_spot_price_tomorrow_1_hour");
            boolean todayDataFresh = false;
            boolean tomorrowDataFresh = false;
            if (todayData != null && todayData.isValid() && todayData.getDataFreshness() != null) {
                currentTimeSeconds = System.currentTimeMillis() / 1000L;
                long todayDataAgeSeconds = currentTimeSeconds - todayData.getDataFreshness().getTime() / 1000L;
                boolean bl = todayDataFresh = todayDataAgeSeconds < 7200L;
            }
            if (tomorrowData != null && !tomorrowData.getDataValue().equals("-") && tomorrowData.getDataFreshness() != null) {
                currentTimeSeconds = System.currentTimeMillis() / 1000L;
                long tomorrowDataAgeSeconds = currentTimeSeconds - tomorrowData.getDataFreshness().getTime() / 1000L;
                boolean bl = tomorrowDataFresh = tomorrowDataAgeSeconds < 7200L;
            }
            if (todayDataFresh && tomorrowDataFresh) {
                NicePrinter.nicePrint((String)"OTE Prices: Using cached data for both today and tomorrow, only updating current price", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                this.saveCurrentPriceAdHoc();
                return new HashMap<String, Map.Entry<String, String>>();
            }
            LocalDate today = LocalDate.now();
            LocalDate tomorrow = LocalDate.now().plusDays(1L);
            DateTimeFormatter formatter_today = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String formattedDateToday = today.format(formatter_today);
            String formattedDateTomorrow = tomorrow.format(formatter_today);
            float euroToCzk = 0.0f;
            InfoData infoData = super.getInfoDataManagerService().findByDataKey("euro_to_czk");
            if (infoData != null) {
                euroToCzk = Float.parseFloat(infoData.getDataValue());
            }
            String jsonDataToday = null;
            String jsonDataTomorrow = null;
            if (!todayDataFresh) {
                String oteUrlToday = "https://www.ote-cr.cz/cs/kratkodobe-trhy/elektrina/denni-trh/@@chart-data?date=" + formattedDateToday;
                try {
                    jsonDataToday = (String)this.restTemplate.getForObject(oteUrlToday, String.class, new Object[0]);
                    NicePrinter.nicePrint((String)"OTE Prices: Fetched today's data from OTE", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                }
                catch (RestClientException e) {
                    this.eventEntryManagerService.raiseEvent("OTE Prices: OTE portal did not respond for today's data, will try again soon...", EventEntry.EventType.ERROR, 60);
                    NicePrinter.nicePrint((String)"OTE Prices: OTE portal did not respond for today's data, will try again soon...", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                }
            } else {
                NicePrinter.nicePrint((String)"OTE Prices: Using cached data for today", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            }
            if (!tomorrowDataFresh) {
                String oteUrlTomorrow = "https://www.ote-cr.cz/cs/kratkodobe-trhy/elektrina/denni-trh/@@chart-data?date=" + formattedDateTomorrow;
                try {
                    jsonDataTomorrow = (String)this.restTemplate.getForObject(oteUrlTomorrow, String.class, new Object[0]);
                    NicePrinter.nicePrint((String)"OTE Prices: Fetched tomorrow's data from OTE", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                }
                catch (RestClientException e) {
                    this.eventEntryManagerService.raiseEvent("OTE Prices: OTE portal did not respond for tomorrow's data, will try again soon...", EventEntry.EventType.ERROR, 60);
                    NicePrinter.nicePrint((String)"OTE Prices: OTE portal did not respond for tomorrow's data, will try again soon...", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                }
            } else {
                NicePrinter.nicePrint((String)"OTE Prices: Using cached data for tomorrow", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            }
            if (!todayDataFresh && jsonDataToday != null) {
                objectMapper = new ObjectMapper();
                JsonNode rootNodeToday = objectMapper.readTree(jsonDataToday);
                JsonNode dataLineNodeToday = null;
                JsonNode hourlyDataLineNodeToday = null;
                if (rootNodeToday.get("data") != null && rootNodeToday.get("data").get("dataLine") != null && rootNodeToday.get("data").get("dataLine").get(1) != null) {
                    dataLineNodeToday = rootNodeToday.get("data").get("dataLine").get(1).get("point");
                    if (rootNodeToday.get("data").get("dataLine").get(2) != null) {
                        hourlyDataLineNodeToday = rootNodeToday.get("data").get("dataLine").get(2).get("point");
                    }
                }
                if (dataLineNodeToday == null) {
                    this.eventEntryManagerService.raiseEvent("OTE Prices: no data for today yet, will try again soon...", EventEntry.EventType.ERROR, 60);
                    return new HashMap<String, Map.Entry<String, String>>();
                }
                LocalDateTime currentTime = LocalDateTime.now();
                DateTimeFormatter formatter_hour = DateTimeFormatter.ofPattern("H");
                DateTimeFormatter formatter_minute = DateTimeFormatter.ofPattern("m");
                String currentHour = currentTime.format(formatter_hour);
                String currentMinute = currentTime.format(formatter_minute);
                int currHourInt = Integer.parseInt(currentHour);
                int currMinuteInt = Integer.parseInt(currentMinute);
                this.processDayPrices(dataLineNodeToday, hourlyDataLineNodeToday, "today", currHourInt, currMinuteInt, euroToCzk, localCurrency);
            } else if (todayDataFresh) {
                this.saveCurrentPriceAdHoc();
            }
            if (!tomorrowDataFresh && jsonDataTomorrow != null) {
                objectMapper = new ObjectMapper();
                JsonNode rootNodeTomorrow = objectMapper.readTree(jsonDataTomorrow);
                JsonNode dataNodeTomorrow = rootNodeTomorrow.get("data").get("dataLine");
                JsonNode dataLineNodeTomorrow = null;
                JsonNode hourlyDataLineNodeTomorrow = null;
                if (dataNodeTomorrow.get(1) != null) {
                    dataLineNodeTomorrow = dataNodeTomorrow.get(1).get("point");
                    if (dataNodeTomorrow.get(2) != null) {
                        hourlyDataLineNodeTomorrow = dataNodeTomorrow.get(2).get("point");
                    }
                } else {
                    NicePrinter.nicePrint((String)"OTE Prices: no data for tomorrow yet, will try again soon...", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                    for (int i = 0; i <= 23; ++i) {
                        this.saveinfodata(new InfoData("energy_spot_price_tomorrow_" + (i + 1) + "_hour", "-", "EUR/MWh", 5400));
                        if (!(euroToCzk > 0.0f)) continue;
                        this.saveinfodata(new InfoData("energy_spot_price_tomorrow_local_" + (i + 1) + "_hour", "-", localCurrency + "/kWh", 36000));
                    }
                    return new HashMap<String, Map.Entry<String, String>>();
                }
                this.processDayPrices(dataLineNodeTomorrow, hourlyDataLineNodeTomorrow, "tomorrow", -1, -1, euroToCzk, localCurrency);
                return new HashMap<String, Map.Entry<String, String>>();
            }
            if (!tomorrowDataFresh) return new HashMap<String, Map.Entry<String, String>>();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.eventEntryManagerService.raiseEvent("OTE Prices: some issue with processing spot prices - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            NicePrinter.nicePrint((String)("OTE Prices: some issue with processing spot prices and earnings - " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            this.saveCurrentPriceAdHoc();
        }
        return new HashMap<String, Map.Entry<String, String>>();
    }

    /*
     * WARNING - void declaration
     */
    private void processDayPrices(JsonNode dataLineNode, JsonNode hourlyDataLineNode, String dayLabel, int currentHourIndex, int currentMinuteIndex, float euroToCzk, String localCurrency) {
        if (!dataLineNode.isArray()) {
            this.eventEntryManagerService.raiseEvent("OTE Prices: some issue parsing prices from OTE website. Incompatible data format.", EventEntry.EventType.ERROR, 60);
            NicePrinter.nicePrint((String)"OTE Prices: some issue parsing prices from OTE website. Incompatible data format.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return;
        }
        int arraySize = dataLineNode.size();
        if (arraySize != 96) {
            this.eventEntryManagerService.raiseEvent("OTE Prices: unexpected array size " + arraySize + " for " + dayLabel + ", expected 96", EventEntry.EventType.ERROR, 60);
            NicePrinter.nicePrint((String)("OTE Prices: unexpected array size " + arraySize + " for " + dayLabel + ", expected 96"), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return;
        }
        HashMap<Integer, Float> hourlyPricesEur = new HashMap<Integer, Float>();
        HashMap<Integer, Float> hourlyPricesLocal = new HashMap<Integer, Float>();
        HashMap<Integer, Float> interval15MinPricesLocal = new HashMap<Integer, Float>();
        float sumDayPriceEur = 0.0f;
        for (int i = 0; i < arraySize; ++i) {
            String priceStr = dataLineNode.get(i).get("y").asText();
            float priceEur = Float.parseFloat(priceStr);
            this.saveinfodata(new InfoData("energy_spot_price_" + dayLabel + "_15min_" + (i + 1), priceStr, "EUR/MWh", 36000));
            if (!(euroToCzk > 0.0f)) continue;
            float priceLocal = euroToCzk * priceEur / 1000.0f;
            interval15MinPricesLocal.put(i, Float.valueOf(priceLocal));
            this.saveinfodata(new InfoData("energy_spot_price_" + dayLabel + "_15min_local_" + (i + 1), String.valueOf(priceLocal), localCurrency + "/kWh", 36000));
        }
        for (int hour = 0; hour < 24; ++hour) {
            float hourAvgEur;
            if (hourlyDataLineNode != null && hourlyDataLineNode.isArray() && hourlyDataLineNode.size() == 96) {
                int hourlyIndex = hour * 4;
                String hourlyPriceStr = hourlyDataLineNode.get(hourlyIndex).get("y").asText();
                hourAvgEur = Float.parseFloat(hourlyPriceStr);
            } else {
                float hourSumEur = 0.0f;
                int startIdx = hour * 4;
                for (int i = 0; i < 4; ++i) {
                    String priceStr = dataLineNode.get(startIdx + i).get("y").asText();
                    hourSumEur += Float.parseFloat(priceStr);
                }
                hourAvgEur = hourSumEur / 4.0f;
            }
            hourlyPricesEur.put(hour, Float.valueOf(hourAvgEur));
            sumDayPriceEur += hourAvgEur;
            this.saveinfodata(new InfoData("energy_spot_price_" + dayLabel + "_" + (hour + 1) + "_hour", String.valueOf(hourAvgEur), "EUR/MWh", 36000));
            if (!(euroToCzk > 0.0f)) continue;
            float hourAvgLocal = euroToCzk * hourAvgEur / 1000.0f;
            hourlyPricesLocal.put(hour, Float.valueOf(hourAvgLocal));
            this.saveinfodata(new InfoData("energy_spot_price_" + dayLabel + "_local_" + (hour + 1) + "_hour", String.valueOf(hourAvgLocal), localCurrency + "/kWh", 36000));
        }
        if (dayLabel.equals("today") && currentHourIndex >= 0 && currentHourIndex < 24 && currentMinuteIndex >= 0 && currentMinuteIndex < 60) {
            float currentPriceEur;
            String currentPriceStr;
            int current15MinuteIndex = currentHourIndex * 4 + currentMinuteIndex / 15;
            if (current15MinuteIndex < arraySize) {
                currentPriceStr = dataLineNode.get(current15MinuteIndex).get("y").asText();
                currentPriceEur = Float.parseFloat(currentPriceStr);
            } else {
                currentPriceEur = ((Float)hourlyPricesEur.get(currentHourIndex)).floatValue();
                currentPriceStr = String.valueOf(currentPriceEur);
            }
            this.saveinfodata(new InfoData("ote_price_current_hour", currentPriceStr, "EUR/MWh", 5400));
            this.saveinfodata(new InfoData("electricity_price_current_hour", currentPriceStr, "EUR/MWh", 5400));
            if (euroToCzk > 0.0f) {
                float currentPriceLocal = euroToCzk * currentPriceEur / 1000.0f;
                this.saveinfodata(new InfoData("ote_price_current_hour_czk_kwh", String.valueOf(currentPriceLocal), "K\u010d/kWh", 5400));
                this.saveinfodata(new InfoData("ote_price_current_hour_local_currency_kwh", String.valueOf(currentPriceLocal), localCurrency + "/kWh", 5400));
                this.eventEntryManagerService.raiseEvent("OTE Prices: current 15-minute price is " + currentPriceEur + " EUR/MWh; " + euroToCzk * currentPriceEur / 1000.0f + " CZK/kWh; Current hour: " + (currentHourIndex + 1) + "; Current time: " + LocalDateTime.now(), EventEntry.EventType.INFO, 60);
            }
        }
        float dayAvgEur = sumDayPriceEur / 24.0f;
        this.saveinfodata(new InfoData("energy_spot_price_" + dayLabel + "_avg", String.valueOf(dayAvgEur), "EUR/MWh", 36000));
        if (euroToCzk > 0.0f) {
            float dayAvgLocal = dayAvgEur * euroToCzk / 1000.0f;
            this.saveinfodata(new InfoData("energy_spot_price_" + dayLabel + "_avg_local_currency_kwh", String.valueOf(dayAvgLocal), localCurrency + "/kWh", 36000));
            this.saveinfodata(new InfoData("energy_spot_price_" + dayLabel + "_avg_czk_kwh", String.valueOf(dayAvgLocal), "CZK/kWh", 36000));
        }
        if (dayLabel.equals("today") && euroToCzk > 0.0f) {
            ArrayList sortedEntries = new ArrayList(hourlyPricesLocal.entrySet());
            sortedEntries.sort(Map.Entry.comparingByValue());
            int lowestPriceIndex = 0;
            for (Map.Entry entry : sortedEntries) {
                this.saveinfodata(new InfoData("energy_spot_price_local_from_lowest_" + lowestPriceIndex + "_hour", String.valueOf((Integer)entry.getKey() + 1), "hour", 36000));
                this.saveinfodata(new InfoData("energy_spot_price_local_from_lowest_" + lowestPriceIndex, String.valueOf(entry.getValue()), "CZK/kWh", 36000));
                ++lowestPriceIndex;
            }
            ArrayList sorted15MinEntries = new ArrayList(interval15MinPricesLocal.entrySet());
            sorted15MinEntries.sort(Map.Entry.comparingByValue());
            boolean bl = false;
            for (Map.Entry entry : sorted15MinEntries) {
                void var17_36;
                this.saveinfodata(new InfoData("energy_spot_price_local_from_lowest_15min_" + (int)var17_36 + "_interval", String.valueOf((Integer)entry.getKey() + 1), "interval", 36000));
                this.saveinfodata(new InfoData("energy_spot_price_local_from_lowest_15min_" + (int)var17_36, String.valueOf(entry.getValue()), "CZK/kWh", 36000));
                ++var17_36;
            }
        }
    }

    public void saveCurrentPriceAdHoc() {
        try {
            InfoData priceToUse;
            LocalDateTime currentTime = LocalDateTime.now();
            DateTimeFormatter formatter_hour = DateTimeFormatter.ofPattern("H");
            DateTimeFormatter formatter_minute = DateTimeFormatter.ofPattern("m");
            String currentHour = currentTime.format(formatter_hour);
            String currentMinute = currentTime.format(formatter_minute);
            int currHourInt = Integer.parseInt(currentHour);
            int currMinuteInt = Integer.parseInt(currentMinute);
            int current15MinuteIndex = currHourInt * 4 + currMinuteInt / 15;
            InfoData infoData15MinPrice = super.getInfoDataManagerService().findByDataKey("energy_spot_price_today_15min_" + (current15MinuteIndex + 1));
            InfoData infoDataHourPrice = super.getInfoDataManagerService().findByDataKey("energy_spot_price_today_" + (currHourInt + 1) + "_hour");
            InfoData infoData = priceToUse = infoData15MinPrice != null && infoData15MinPrice.isValid() ? infoData15MinPrice : infoDataHourPrice;
            if (priceToUse != null && priceToUse.isValid()) {
                this.saveinfodata(new InfoData("ote_price_current_hour", priceToUse.getDataValue(), "EUR/MWh", 5400));
                this.saveinfodata(new InfoData("electricity_price_current_hour", priceToUse.getDataValue(), "EUR/MWh", 5400));
                InfoData infoData2 = super.getInfoDataManagerService().findByDataKey("euro_to_czk");
                float euroToCzk = 0.0f;
                if (infoData2 != null) {
                    euroToCzk = Float.parseFloat(infoData2.getDataValue());
                }
                if (euroToCzk > 0.0f) {
                    float currentPriceLocal = euroToCzk * Float.parseFloat(priceToUse.getDataValue()) / 1000.0f;
                    this.saveinfodata(new InfoData("ote_price_current_hour_czk_kwh", String.valueOf(currentPriceLocal), "K\u010d/kWh", 5400));
                    this.saveinfodata(new InfoData("ote_price_current_hour_local_currency_kwh", String.valueOf(currentPriceLocal), "CZK/kWh", 5400));
                    NicePrinter.nicePrint((String)("Adhoc energy prices collection finished, current 15-minute price is: " + currentPriceLocal + " CZK/kWh"), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.eventEntryManagerService.raiseEvent("OTE Prices: some issue with saving current hour price adhoc - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            NicePrinter.nicePrint((String)("OTE Prices: some issue with saving current hour price adhoc - " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
    }
}

