/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.click.ClickAPIService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CommunitySharingCollector
extends DataCollectorAbstractService {
    private final SunnyConfigurationService sunnyConfigurationService;
    private final EventEntryManagerService eventEntryManagerService;
    private final ClickAPIService clickAPIService;

    @Autowired
    public CommunitySharingCollector(InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService, EventEntryManagerService eventEntryManagerService, ClickAPIService clickAPIService) {
        super(infoDataManagerService);
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.eventEntryManagerService = eventEntryManagerService;
        this.clickAPIService = clickAPIService;
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        try {
            String collectUsers = this.sunnyConfigurationService.getSetting("sunnyhome_click_collect_users");
            if (collectUsers == null || collectUsers.isEmpty()) {
                return null;
            }
            String[] users = collectUsers.split(",");
            HashMap<String, Map.Entry<String, String>> dataMap = new HashMap<String, Map.Entry<String, String>>();
            for (String user : users) {
                String userData = this.getDataForUser(user = user.trim());
                if (userData != null) {
                    JsonArray jsonData = JsonParser.parseString((String)userData).getAsJsonArray();
                    for (JsonElement element : jsonData) {
                        JsonObject obj = element.getAsJsonObject();
                        String dataKey = obj.get("dataKey").getAsString();
                        String dataValue = obj.get("dataValue").getAsString();
                        String units = obj.get("units").getAsString();
                        String combinedKey = user + "_" + dataKey;
                        dataMap.put(combinedKey, new AbstractMap.SimpleEntry<String, String>(dataValue, units));
                    }
                }
                Thread.sleep(1000L);
            }
            this.saveinfodata(dataMap);
            return dataMap;
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("COMMUNITY SHARING COLLECTOR: Error while collecting data from users: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            return null;
        }
    }

    public String getDataForUser(String collectUser) {
        String sunnyHomeOnlineUrl;
        String json;
        String token;
        String user = this.sunnyConfigurationService.getSetting("sunnyhome_click_user");
        ResponseEntity response = this.clickAPIService.callClickAPI(user, token = this.sunnyConfigurationService.getSetting("sunnyhome_click_token"), json = "", sunnyHomeOnlineUrl = "/data/" + user + "/get_all_data/" + collectUser, HttpMethod.GET);
        if (response != null && response.getStatusCode().is2xxSuccessful()) {
            return (String)response.getBody();
        }
        this.eventEntryManagerService.raiseEvent("COMMUNITY SHARING COLLECTOR: Error while collecting data from user " + collectUser, EventEntry.EventType.ERROR, 60);
        return null;
    }
}

