/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.automation;

import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.automation.InverterCloudController;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import cz.snyll.sunny.services.collectors.energyPricesCollectors.DataCollectorEnergyPricesCs;
import cz.snyll.sunny.services.modbus.ModbusServiceFactory;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class LimitExportWhenSpotPriceLow
extends DataCollectorAbstractService {
    private final EventEntryManagerService eventEntryManagerService;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final ModbusServiceFactory modbusServiceFactory;
    private final DataCollectorEnergyPricesCs dataCollectorEnergyPricesCs;
    private final InverterCloudController inverterCloudController;

    @Autowired
    public LimitExportWhenSpotPriceLow(DataCollectorEnergyPricesCs dataCollectorEnergyPricesCs, SunnyConfigurationService sunnyConfigurationService, ModbusServiceFactory modbusServiceFactory, InfoDataManagerService infoDataManagerService, EventEntryManagerService eventEntryManagerService, InverterCloudController inverterCloudController) {
        super(infoDataManagerService);
        this.modbusServiceFactory = modbusServiceFactory;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.dataCollectorEnergyPricesCs = dataCollectorEnergyPricesCs;
        this.inverterCloudController = inverterCloudController;
        this.eventEntryManagerService = eventEntryManagerService;
    }

    @Scheduled(cron="15 0 * * * *")
    public void limitExportWhenSpotPriceLow() {
    }

    private static int getExportLimitDiv10(int exportLimitInt) {
        return exportLimitInt / 10;
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        return new HashMap<String, Map.Entry<String, String>>();
    }

    public static boolean isTimeBetween(LocalTime timeToCheck, LocalTime startTime, LocalTime endTime) {
        if (startTime.isBefore(endTime)) {
            return !timeToCheck.isBefore(startTime) && !timeToCheck.isAfter(endTime);
        }
        return !timeToCheck.isBefore(startTime) || !timeToCheck.isAfter(endTime);
    }
}

