/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.inverter.ConnectionDetails;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.domain.inverter.LocalAPIDetails;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InverterManagerService;
import cz.snyll.sunny.services.LanScannerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.inverterCollectors.DataCollectorInverterSolaxApi;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class LanScannerService {
    private static final Logger log = LoggerFactory.getLogger(LanScannerService.class);
    private static final Logger logger = LoggerFactory.getLogger(LanScannerService.class);
    private final DataCollectorInverterSolaxApi dataCollectorInverter;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final AtomicBoolean correctIpFound = new AtomicBoolean(false);
    private String finalIP;
    private final DataCollectorInverterSolaxApi dataCollectorInverterSolaxApi;
    private final EventEntryManagerService eventEntryManagerService;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final InverterManagerService inverterManagerService;

    @Autowired
    public LanScannerService(SunnyConfigurationService sunnyConfigurationService, DataCollectorInverterSolaxApi dataCollectorInverter, EventEntryManagerService eventEntryManagerService, DataCollectorInverterSolaxApi dataCollectorInverterSolaxApi, @Qualifier(value="lanScanExecutor") ThreadPoolTaskExecutor taskExecutor, InverterManagerService inverterManagerService) {
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.dataCollectorInverter = dataCollectorInverter;
        this.eventEntryManagerService = eventEntryManagerService;
        this.dataCollectorInverterSolaxApi = dataCollectorInverterSolaxApi;
        this.taskExecutor = taskExecutor;
        this.inverterManagerService = inverterManagerService;
    }

    @Async
    public void initialScan() {
        if (!this.inverterManagerService.loadAll().isEmpty()) {
            return;
        }
        logger.info("LAN SCANNER: No inverter found. Doing initial scan of the local network. This might take few minutes.");
        CompletableFuture inverter_ip_future = this.scanLocalNetwork();
        String inverter_ip = "";
        try {
            inverter_ip = (String)inverter_ip_future.get();
        }
        catch (ExecutionException e) {
            logger.info("LAN SCANNER: Initial scan of the local network failed: {}", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            logger.info("LAN SCANNER: Initial scan of the local network interrupted.");
        }
        logger.info("LAN SCANNER: IP address found: {}", (Object)inverter_ip);
        logger.info("LAN SCANNER: Trying to identify solax dongle SN from Wi-Fi networks.");
        String local_password = "";
        try {
            boolean connectionWorking = false;
            String response = "";
            ArrayList networks = (ArrayList)this.scanNetworks();
            if (networks != null && !networks.isEmpty()) {
                for (String network : networks) {
                    String networkName;
                    logger.info("LAN SCANNER: Trying network: {}", (Object)network);
                    if (!network.startsWith("Wifi_") || network.startsWith("Wifi_SC") || !(networkName = network.substring(5)).matches("[A-Z0-9]+") || networkName.length() <= 5 || !(response = this.dataCollectorInverterSolaxApi.callSolaxInverter(this.sunnyConfigurationService.getSetting("solax_local_ip_address"), networkName, "ReadRealTimeData")).contains("\"Data\":[")) continue;
                    float systemSize = this.extractSystemSize(response);
                    this.sunnyConfigurationService.saveSetting("total_panel_power_installed", String.valueOf(systemSize));
                    local_password = networkName;
                    this.eventEntryManagerService.raiseEvent("LAN SCANNER: Initial scan of the local network done. Found Solax inverter version 3 dongle SN: " + networkName + " - connection working.", EventEntry.EventType.INFO, 60);
                    logger.info("LAN SCANNER: Wi-Fi dongle seems to be version 3, found working password and saving to database.");
                    connectionWorking = true;
                }
            }
            if (!connectionWorking && (response = this.dataCollectorInverterSolaxApi.callSolaxInverter(inverter_ip, "admin", "ReadRealTimeData")).contains("\"Data\":[")) {
                float systemSize = this.extractSystemSize(response);
                this.sunnyConfigurationService.saveSetting("total_panel_power_installed", String.valueOf(systemSize));
                local_password = "admin";
                this.eventEntryManagerService.raiseEvent("LAN SCANNER: Initial scan of the local network done. Found Solax inverter with version 2 dongle - connection working.", EventEntry.EventType.INFO, 60);
                logger.info("LAN SCANNER: Wi-Fi dongle seems to be version 2, found working password and saving to database.");
                connectionWorking = true;
            }
            if (!connectionWorking) {
                this.eventEntryManagerService.raiseEvent("LAN SCANNER: Initial scan of the local network done. No working connection found. You have to set the local dongle password manually.", EventEntry.EventType.WARNING, 60);
                logger.info("LAN SCANNER: No working connection found.");
            } else {
                String inverter_sn = this.extractSerialNumber(response);
                Inverter inverter = new Inverter();
                inverter.setInverterName("Solax Inverter");
                inverter.setActive(Boolean.valueOf(true));
                inverter.setInverterManufacturer(Inverter.Manufacturer.Solax);
                inverter.setInverterSerialNumber(inverter_sn);
                LocalAPIDetails apiDetails = new LocalAPIDetails();
                apiDetails.setCommunicationType(Inverter.CommunicationType.LocalAPI);
                apiDetails.setIp(String.valueOf(inverter_ip));
                apiDetails.setLocalPassword(local_password);
                if (inverter.getConnectionDetails() == null) {
                    inverter.setConnectionDetails((ConnectionDetails)apiDetails);
                }
                this.inverterManagerService.saveInverter(inverter);
            }
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("LAN SCANNER: Error while trying to get all Wi-Fi networks: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
        }
    }

    @Async
    public CompletableFuture<String> scanLocalNetwork() {
        Object firstTwoNumbers = "192.168.";
        String thirdNumber = "0";
        String localIpAddress = this.getLocalIpAddress();
        if (localIpAddress == null || localIpAddress.isEmpty() || localIpAddress.startsWith("172.1")) {
            logger.info("LAN SCANNER: No local IP address found. Trying range 192.168.0.1 - 255");
            localIpAddress = "192.168.0.1";
        }
        int port = 80;
        int timeout = 300;
        String[] octets = localIpAddress.split("\\.");
        if (octets.length > 2) {
            firstTwoNumbers = octets[0] + "." + octets[1];
            thirdNumber = octets[2];
        } else {
            logger.info("LAN SCANNER: Invalid IP address format");
        }
        logger.info("Local IP Range: {}.{}.0-255", firstTwoNumbers, (Object)thirdNumber);
        boolean reset = false;
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (int j = -1; j <= 255 && !this.correctIpFound.get(); ++j) {
            int iprange = j;
            if (j == 255 && reset) break;
            if (!reset) {
                iprange = Integer.parseInt(thirdNumber);
            }
            logger.info("LAN SCANNER: Scanning range: {}.{}.0-255", firstTwoNumbers, (Object)iprange);
            for (int i = 0; i <= 255 && !this.correctIpFound.get(); ++i) {
                String ip = (String)firstTwoNumbers + "." + iprange + "." + i;
                try {
                    CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                        String result;
                        if (!this.correctIpFound.get() && this.isPortOpen(ip, 80, 300) && (result = this.dataCollectorInverter.callSolaxInverter(ip, "test", "ReadRealTimeData")) != null && result.contains("message:\"failed\"")) {
                            this.finalIP = ip;
                            this.sunnyConfigurationService.saveSetting("solax_local_ip_address", ip);
                            this.eventEntryManagerService.raiseEvent("Found Solax inverter at IP: " + this.finalIP, EventEntry.EventType.INFO, 60);
                            this.correctIpFound.set(true);
                        }
                    }, (Executor)this.taskExecutor);
                    futures.add(future);
                }
                catch (TaskRejectedException e2) {
                    logger.info("LAN SCANNER: Task rejected, probably too many tasks running.");
                }
                try {
                    Thread.sleep(5L);
                    continue;
                }
                catch (InterruptedException e3) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.correctIpFound.get()) break;
            reset = true;
            if (this.taskExecutor == null) continue;
            int queueSize = this.taskExecutor.getQueueSize();
            while (queueSize > 20) {
                try {
                    logger.info("LAN SCANNER: Number of tasks waiting in the queue: " + queueSize);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e4) {
                    Thread.currentThread().interrupt();
                }
                queueSize = this.taskExecutor.getQueueSize();
            }
        }
        return ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> {
            if (this.correctIpFound.get()) {
                return this.finalIP;
            }
            return null;
        })).exceptionally(e -> null);
    }

    private boolean isPortOpen(String ip, int port, int timeout) {
        boolean bl;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(ip, port), timeout);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || !address.getHostAddress().contains(".")) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<String> scanNetworks() throws Exception {
        ArrayList<String> networks = new ArrayList<String>();
        if (this.isLinux()) {
            logger.info("LAN SCANNER: Scanning Wi-Fi networks on Linux");
            String[] command = new String[]{"/bin/bash", "-c", "iwlist wlan0 scan | awk '/Quality/ {q=$2} /ESSID/ {print q \" \" $1}' | sort -nr | cut -d\" \" -f2-"};
            Process process = Runtime.getRuntime().exec(command);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    logger.info("LAN SCANNER: Found Wi-Fi network: {}", (Object)line);
                    Pattern pattern = Pattern.compile("ESSID:\"([^\"]+)\"");
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.find()) continue;
                    networks.add(matcher.group(1));
                    logger.info("LAN SCANNER: Found network: {}", (Object)matcher.group(1));
                }
            }
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String errorLine;
                while ((errorLine = errorReader.readLine()) != null) {
                    logger.info("LAN SCANNER: Error: {}", (Object)errorLine);
                }
            }
        }
        if (this.isWindows()) {
            logger.info("LAN SCANNER: Scanning Wi-Fi networks on Windows");
            ArrayList<Network> tempNetworks = new ArrayList<Network>();
            String command = "netsh wlan show networks mode=Bssid";
            Process process = Runtime.getRuntime().exec(command);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                String currentSSID = null;
                while ((line = reader.readLine()) != null) {
                    logger.info("LAN SCANNER: WiFi Processing line: {}", (Object)line);
                    if (line.trim().startsWith("SSID")) {
                        String splitLine = line.trim().split(":")[1];
                        if (splitLine == null) continue;
                        currentSSID = splitLine.trim().replace("\"", "");
                        continue;
                    }
                    if (!line.contains("Signal")) continue;
                    String strengthStr = line.trim().split(":")[1].trim().replace("%", "");
                    int currentStrength = Integer.parseInt(strengthStr);
                    tempNetworks.add(new Network(currentSSID, currentStrength));
                    logger.info("LAN SCANNER: Found network: {}", (Object)currentSSID);
                }
            }
            catch (IOException e) {
                logger.info("LAN SCANNER: Error while scanning Wi-Fi networks: {}", (Object)e.getMessage());
            }
            tempNetworks.sort(Comparator.comparingInt(Network::getSignalStrength).reversed());
            for (Network network : tempNetworks) {
                networks.add(network.getSSID());
            }
            for (String ssid : networks) {
                logger.info(ssid);
            }
        }
        return networks;
    }

    public boolean isLinux() {
        String OS = System.getProperty("os.name").toLowerCase();
        logger.info("LAN SCANNER: OS: {}", (Object)OS);
        return OS.contains("linux");
    }

    public boolean isWindows() {
        String OS = System.getProperty("os.name").toLowerCase();
        logger.info("LAN SCANNER: OS: {}", (Object)OS);
        return OS.contains("win");
    }

    public float extractSystemSize(String input) {
        Pattern pattern = Pattern.compile("\"Information\":\\[(\\d+\\.\\d+),");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return Float.parseFloat(matcher.group(1));
        }
        return 10.0f;
    }

    public String extractSerialNumber(String input) {
        ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
        try {
            JsonNode jsonResponseWhole = mapper.readTree(input);
            JsonNode informationNode = jsonResponseWhole.get("Information");
            String inverterSN = "";
            if (informationNode.isArray()) {
                inverterSN = jsonResponseWhole.get("type").isTextual() ? informationNode.get(3).textValue() : informationNode.get(2).textValue();
                return inverterSN;
            }
        }
        catch (IOException e) {
            logger.error("LAN SCANNER: Error while parsing JSON response: {}", (Object)e.getMessage());
        }
        return "";
    }
}

