/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services;

import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.repositories.InverterRepository;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InverterCollectorAbstractService
extends DataCollectorAbstractService {
    private final InverterRepository inverterRepository;
    protected Inverter inverter;

    @Autowired
    public InverterCollectorAbstractService(InfoDataManagerService infoDataManagerService, InverterRepository inverterRepository) {
        super(infoDataManagerService);
        this.inverterRepository = inverterRepository;
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        return null;
    }

    protected HashMap<String, Map.Entry<String, String>> prependInverterId(HashMap<String, Map.Entry<String, String>> data) {
        if (this.inverterRepository.count() == 1L) {
            return data;
        }
        HashMap<String, Map.Entry<String, String>> result = new HashMap<String, Map.Entry<String, String>>();
        for (Map.Entry<String, Map.Entry<String, String>> entry : data.entrySet()) {
            result.put("inverter_" + this.inverter.getId() + "_" + entry.getKey(), entry.getValue());
        }
        LocalDateTime now = LocalDateTime.now();
        this.inverter.setLastDataCollection(now);
        this.inverterRepository.save((Object)this.inverter);
        return result;
    }

    public void setInverter(Inverter inverter) {
        this.inverter = inverter;
    }
}

