/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.DeviceSetting;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.domain.Trigger;
import cz.snyll.sunny.repositories.DeviceSettingRepository;
import cz.snyll.sunny.services.DeviceSettingManager;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import java.time.LocalTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeviceSettingManagerService
implements DeviceSettingManager {
    private static final Logger log = LoggerFactory.getLogger(DeviceSettingManagerService.class);
    private final EventEntryManagerService eventEntryManagerService;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final InfoDataManagerService infoDataManagerService;
    private final DeviceSettingRepository deviceSettingRepository;

    @Autowired
    public DeviceSettingManagerService(DeviceSettingRepository deviceSettingRepository, EventEntryManagerService eventEntryManagerService, SunnyConfigurationService sunnyConfigurationService, InfoDataManagerService infoDataManagerService) {
        this.deviceSettingRepository = deviceSettingRepository;
        this.eventEntryManagerService = eventEntryManagerService;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.infoDataManagerService = infoDataManagerService;
    }

    @Transactional
    protected void detachTriggers(DeviceSetting deviceSetting) {
        deviceSetting.getTriggers().clear();
        this.deviceSettingRepository.save((Object)deviceSetting);
    }

    @Transactional
    public void saveDeviceSetting(DeviceSetting deviceSetting) {
        if (deviceSetting.getId() == null) {
            this.eventEntryManagerService.raiseEvent("AUTOMATION CONDITION: Adding new Automation Condition with name: " + deviceSetting.getDeviceSettingName(), EventEntry.EventType.SUCCESS);
        }
        this.deviceSettingRepository.save((Object)deviceSetting);
    }

    @Transactional
    public void deleteDeviceSetting(DeviceSetting deviceSetting) {
        this.detachTriggers(deviceSetting);
        NicePrinter.nicePrint((String)("Automation Condition: Deleting Automation Condition with name: " + deviceSetting.getDeviceSettingName()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        this.deviceSettingRepository.delete((Object)deviceSetting);
        this.eventEntryManagerService.raiseEvent("Automation Condition: Automation Condition deleted. Name: " + deviceSetting.getDeviceSettingName(), EventEntry.EventType.WARNING);
    }

    public ArrayList<DeviceSetting> loadAll() {
        return (ArrayList)this.deviceSettingRepository.findAll();
    }

    public boolean evaluateDeviceSetting(DeviceSetting deviceSetting) {
        try {
            NicePrinter.nicePrint((String)("AUTOMATION: Evaluating Automation Condition " + deviceSetting.getDeviceSettingName()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            LocalTime currentTime = LocalTime.now();
            if (!deviceSetting.isActive()) {
                return false;
            }
            if (Boolean.parseBoolean(this.sunnyConfigurationService.getSetting("away_mode")) && !deviceSetting.activeInAwayMode) {
                NicePrinter.nicePrint((String)"AUTOMATION: Automation Condition evaluated to false because of away mode.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                return false;
            }
            InfoData infoDataDawn = this.infoDataManagerService.findByDataKey("today_dawn_time");
            InfoData infoDataDusk = this.infoDataManagerService.findByDataKey("today_dusk_time");
            LocalTime startingTime = deviceSetting.getTimeWindowFrom();
            LocalTime endingTime = deviceSetting.getTimeWindowTo();
            if (infoDataDawn != null) {
                LocalTime dawnTime = LocalTime.parse(infoDataDawn.getDataValue());
                if (deviceSetting.getTimeSunrise() != 0) {
                    startingTime = dawnTime.plusMinutes(deviceSetting.getTimeSunrise());
                }
            }
            if (infoDataDusk != null) {
                LocalTime duskTime = LocalTime.parse(infoDataDusk.getDataValue());
                if (deviceSetting.getTimeSundown() != 0) {
                    endingTime = duskTime.plusMinutes(deviceSetting.getTimeSundown());
                }
            }
            if (log.isDebugEnabled() && Boolean.parseBoolean(this.sunnyConfigurationService.getSetting("debug_mode"))) {
                log.debug("Starting Time: {} Ending Time: {} Current Time: {} Dawn Time: {} Dusk Time: {}", new Object[]{startingTime, endingTime, currentTime, infoDataDawn != null ? infoDataDawn.getDataValue() : "n/a", infoDataDusk != null ? infoDataDusk.getDataValue() : "n/a"});
            }
            if (currentTime.isBefore(startingTime) || currentTime.isAfter(endingTime.plusSeconds(59L))) {
                NicePrinter.nicePrint((String)("AUTOMATION: Automation Condition " + deviceSetting.getDeviceSettingName() + " evaluated to false because of time conditions."), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                return false;
            }
            for (Trigger trigger : deviceSetting.getTriggers()) {
                log.info("Evaluating trigger: {} with id {} and key {} and value {} and operation {} and state {} and compare key {}", new Object[]{trigger.getTriggerName(), trigger.getId(), trigger.getInfoDataKey(), Float.valueOf(trigger.getInfoDataValue()), trigger.getTriggerOperation(), trigger.isTriggerState(), trigger.getInfoDataKeyCompare()});
                if (!trigger.shouldBeOn(System.currentTimeMillis())) {
                    log.info("Trigger {} with id {} is off. Not turning on the device.", (Object)trigger.getTriggerName(), (Object)trigger.getId());
                    return false;
                }
                log.info("Trigger {} with id {} is on.", (Object)trigger.getTriggerName(), (Object)trigger.getId());
            }
            log.info("Automation Condition: {} evaluated to true.", (Object)deviceSetting.getDeviceSettingName());
            NicePrinter.nicePrint((String)("Automation Condition: " + deviceSetting.getDeviceSettingName() + " evaluated to true."), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return true;
        }
        catch (Exception e) {
            log.error("ERROR: Evaluation of Automation Condition {} has failed with message: {}", (Object)deviceSetting.getDeviceSettingName(), (Object)e.getMessage());
            this.eventEntryManagerService.raiseEvent("Evaluation of Automation Condition " + deviceSetting.getDeviceSettingName() + " has failed with message: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            return false;
        }
    }

    @Transactional
    public void deleteDeviceSettingById(long id) throws DataIntegrityViolationException {
        DeviceSetting deviceSetting = this.deviceSettingRepository.findById((Object)id).orElse(null);
        if (deviceSetting == null) {
            this.eventEntryManagerService.raiseEvent("Automation Condition: Automation Condition with ID: " + id + " not found. Could not delete.", EventEntry.EventType.ERROR);
            log.error("Automation Condition with ID: {} not found. Could not delete.", (Object)id);
            return;
        }
        try {
            this.detachTriggers(deviceSetting);
            this.deviceSettingRepository.deleteById(id);
            String successMessage = "Automation Condition deleted. ID: " + id;
            this.eventEntryManagerService.raiseEvent(successMessage, EventEntry.EventType.WARNING);
            log.warn(successMessage);
        }
        catch (DataIntegrityViolationException e) {
            String failMessage = "Failed to delete Automation Condition. ID: " + id + ". Error: " + e.getMessage();
            this.eventEntryManagerService.raiseEvent(failMessage, EventEntry.EventType.ERROR);
            log.error(failMessage, (Throwable)e);
            throw e;
        }
    }
}

