/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.DeviceControllers;

import com.fasterxml.jackson.databind.JsonNode;
import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.DeviceControllers.DeviceController;
import cz.snyll.sunny.services.DeviceControllers.ShellyController;
import cz.snyll.sunny.services.DeviceControllers.ShellyRestService;
import cz.snyll.sunny.services.EventEntryManagerService;

public class ShellyPro3EMController
extends ShellyController
implements DeviceController {
    private JsonNode statusJSON;

    private String relayMeterNumberToLetter(int relayMeterNumber) {
        return switch (relayMeterNumber) {
            case 0 -> "a";
            case 1 -> "b";
            case 2 -> "c";
            default -> "total";
        };
    }

    public ShellyPro3EMController(Device device, EventEntryManagerService eventEntryManagerService, ShellyRestService shellyRestService) {
        super(device, eventEntryManagerService, ShellyController.ShellyGen.gen2, shellyRestService);
        super.setTurnOnUrl("/");
        super.setTurnOffUrl("/");
        super.setStatusUrl("/rpc/EM.GetStatus?id=0");
    }

    public float getCurrentConsumption() {
        try {
            return Float.parseFloat(this.statusJSON.get(this.relayMeterNumberToLetter(this.getDevice().getRelayMeterNumber()) + "_act_power").toString());
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " -Could not parse consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public float getTotalConsumption() {
        return 0.0f;
    }

    public float getTodayConsumption() {
        return 0.0f;
    }

    public boolean getActualStatus() {
        return true;
    }

    public float getTemperature() {
        return 0.0f;
    }

    public void refreshData() {
        this.statusJSON = this.getCurrentData();
    }
}

