/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.DeviceControllers;

import com.fasterxml.jackson.databind.JsonNode;
import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.DeviceControllers.DeviceController;
import cz.snyll.sunny.services.DeviceControllers.DimmerController;
import cz.snyll.sunny.services.DeviceControllers.ShellyController;
import cz.snyll.sunny.services.DeviceControllers.ShellyRestService;
import cz.snyll.sunny.services.EventEntryManagerService;

public class ShellyDimmerGen3Controller
extends ShellyController
implements DeviceController,
DimmerController {
    private String setBrightnessUrl = "/rpc/Light.Set?id=0&on=true&brightness=";
    private JsonNode statusJSON;

    public ShellyDimmerGen3Controller(Device device, EventEntryManagerService eventEntryManagerService, ShellyRestService shellyRestService) {
        super(device, eventEntryManagerService, ShellyController.ShellyGen.gen3, shellyRestService);
        String turnOnUrl = "/rpc/Light.Set?id=0&on=true&brightness=100";
        super.setTurnOnUrl(turnOnUrl);
        String turnOffUrl = "rpc/Light.Set?id=0&on=fa&brightness=0";
        super.setTurnOffUrl(turnOffUrl);
        String statusUrl = "/rpc/Light.GetStatus?id=0";
        super.setStatusUrl(statusUrl);
    }

    public float getCurrentConsumption() {
        try {
            return Float.parseFloat(this.statusJSON.get("apower").toString());
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " -Could not parse consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public float getTotalConsumption() {
        try {
            return Float.parseFloat(this.statusJSON.get("aenergy").get("total").toString()) / 1000.0f;
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse total consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public float getTodayConsumption() {
        try {
            float consumption = Float.parseFloat(this.statusJSON.get("aenergy").get("total").toString()) / 1000.0f;
            if (consumption <= this.getDevice().getDeviceStatus().getLastDayTotalConsumption()) {
                return 0.0f;
            }
            if ((consumption -= this.getDevice().getDeviceStatus().getLastDayTotalConsumption()) < 0.0f) {
                return 0.0f;
            }
            return consumption;
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse total consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public boolean getActualStatus() {
        try {
            return this.statusJSON.get("output").asBoolean();
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse actual status.", EventEntry.EventType.WARNING, 60);
            return false;
        }
    }

    public float getTemperature() {
        try {
            return Float.parseFloat(this.statusJSON.get("temperature").get("tC").toString());
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse temperature.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public void refreshData() {
        this.statusJSON = this.getCurrentData();
    }

    public boolean setLevel(float level) {
        try {
            String url = "http://" + super.getDevice().getDeviceIP() + this.setBrightnessUrl + (int)level;
            super.getRestTemplate().getForObject(url, String.class, new Object[0]);
            return true;
        }
        catch (Exception e) {
            super.getEventEntryManagerService().raiseEvent("Device: " + super.getDevice().getDeviceName() + ": Error when turning OFF - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            return false;
        }
    }

    public float getLevel() {
        try {
            this.refreshData();
            return Float.parseFloat(this.statusJSON.get("brightness").toString());
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse brightness.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }
}

