/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.DeviceControllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.DeviceControllers.DeviceController;
import cz.snyll.sunny.services.DeviceControllers.ShellyController;
import cz.snyll.sunny.services.DeviceControllers.ShellyRestService;
import cz.snyll.sunny.services.EventEntryManagerService;
import java.util.Objects;

public class Shelly1PMController
extends ShellyController
implements DeviceController {
    private JsonNode statusJSON;
    private final Device device;
    private final String turnOnUrl = "/relay/0/?turn=on";
    private final String turnOffUrl = "/relay/0/?turn=off";
    private final String statusUrl = "/status";
    private final EventEntryManagerService eventEntryManagerService;

    public Shelly1PMController(Device device, EventEntryManagerService eventEntryManagerService, ShellyRestService shellyRestService) {
        super(device, eventEntryManagerService, ShellyController.ShellyGen.gen1, shellyRestService);
        Objects.requireNonNull(this);
        super.setTurnOnUrl("/relay/0/?turn=on");
        Objects.requireNonNull(this);
        super.setTurnOffUrl("/relay/0/?turn=off");
        Objects.requireNonNull(this);
        super.setStatusUrl("/status");
        this.device = device;
        this.eventEntryManagerService = eventEntryManagerService;
    }

    public float getCurrentConsumption() {
        try {
            float consumption = Float.parseFloat(this.statusJSON.get("meters").get(0).get("power").toString());
            return consumption;
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("DEVICE INFO: " + this.device.getDeviceName() + " -Could not parse consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public float getTotalConsumption() {
        try {
            float consumption = Float.parseFloat(this.statusJSON.get("meters").get(0).get("total").toString()) * 1.7E-5f;
            return consumption;
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("DEVICE INFO: " + this.device.getDeviceName() + " - Could not parse total consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public float getTodayConsumption() {
        try {
            float consumption = Float.parseFloat(this.statusJSON.get("meters").get(0).get("total").toString()) * 1.7E-5f;
            if (consumption <= this.getDevice().getDeviceStatus().getLastDayTotalConsumption()) {
                return 0.0f;
            }
            if ((consumption -= this.device.getDeviceStatus().getLastDayTotalConsumption()) < 0.0f) {
                return 0.0f;
            }
            return consumption;
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("DEVICE INFO: " + this.device.getDeviceName() + " - Could not parse total consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public boolean getActualStatus() {
        try {
            return this.statusJSON.get("relays").get(0).get("ison").asBoolean();
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("DEVICE INFO: " + this.device.getDeviceName() + " - Could not parse actual status.", EventEntry.EventType.WARNING, 60);
            return false;
        }
    }

    public float getTemperature() {
        try {
            return Float.parseFloat(this.statusJSON.get("temperature").toString());
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("Device: " + this.device.getDeviceName() + ": Could not parse temperature - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            return 0.0f;
        }
    }

    public void refreshData() {
        this.statusJSON = this.getCurrentData();
    }

    public boolean ProcessResponse(String response, boolean expectedResponse) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonResponse = mapper.readTree(response);
            if (jsonResponse.get("ison").toString().equals("false") && !expectedResponse) {
                return true;
            }
            return jsonResponse.get("ison").toString().equals("true") && expectedResponse;
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("API Error: there was exception thrown during API command: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            return false;
        }
    }
}

