/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.DeviceControllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.pi4j.Pi4J;
import com.pi4j.context.Context;
import com.pi4j.io.gpio.digital.DigitalOutput;
import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.services.DeviceControllers.DeviceController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpiGPIOController
implements DeviceController {
    private static final Logger log = LoggerFactory.getLogger(RpiGPIOController.class);
    private final Device device;

    public RpiGPIOController(Device device) {
        this.device = device;
    }

    public JsonNode getCurrentData() {
        return null;
    }

    public float getCurrentConsumption() {
        return 0.0f;
    }

    public float getTotalConsumption() {
        return 0.0f;
    }

    public float getTodayConsumption() {
        return 0.0f;
    }

    public boolean getActualStatus() {
        Context pi4j = Pi4J.newAutoContext();
        DigitalOutput output = pi4j.dout().create(Integer.valueOf(this.device.getRelayMeterNumber()));
        boolean isOn = output.isOn();
        pi4j.shutdown();
        return isOn;
    }

    public float getTemperature() {
        return 0.0f;
    }

    public boolean turnOnDevice() {
        Context pi4j = Pi4J.newAutoContext();
        DigitalOutput output = pi4j.dout().create(Integer.valueOf(this.device.getRelayMeterNumber()));
        output.on();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting after turning on the device: {}", (Object)e.getMessage(), (Object)e);
        }
        pi4j.shutdown();
        return true;
    }

    public boolean turnOffDevice() {
        Context pi4j = Pi4J.newAutoContext();
        DigitalOutput output = pi4j.dout().create(Integer.valueOf(this.device.getRelayMeterNumber()));
        output.off();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting after turning off the device: {}", (Object)e.getMessage(), (Object)e);
        }
        pi4j.shutdown();
        return true;
    }

    public void refreshData() {
    }

    public Device getControlledDevice() {
        return this.device;
    }
}

