/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.DeviceControllers;

import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.services.DeviceControllers.DeviceController;
import cz.snyll.sunny.services.DeviceControllers.Shelly1Controller;
import cz.snyll.sunny.services.DeviceControllers.Shelly1PMController;
import cz.snyll.sunny.services.DeviceControllers.Shelly1PMPlusController;
import cz.snyll.sunny.services.DeviceControllers.Shelly3EMController;
import cz.snyll.sunny.services.DeviceControllers.ShellyAddonDS18B20Controller;
import cz.snyll.sunny.services.DeviceControllers.ShellyDimmerGen3Controller;
import cz.snyll.sunny.services.DeviceControllers.ShellyPMMini;
import cz.snyll.sunny.services.DeviceControllers.ShellyPlugSController;
import cz.snyll.sunny.services.DeviceControllers.ShellyPlusPlugSController;
import cz.snyll.sunny.services.DeviceControllers.ShellyPro3Controller;
import cz.snyll.sunny.services.DeviceControllers.ShellyPro3EMController;
import cz.snyll.sunny.services.DeviceControllers.ShellyPro4PMController;
import cz.snyll.sunny.services.DeviceControllers.ShellyRestService;
import cz.snyll.sunny.services.EventEntryManagerService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class DeviceControllerFactory {
    private static final Map<Long, DeviceController> controllerCache = new HashMap();

    public static DeviceController createDeviceController(Device device, EventEntryManagerService eventEntryManagerService, ShellyRestService shellyRestService) {
        if (device.getControlDeviceName() == null) {
            return null;
        }
        return controllerCache.compute(device.getId(), (key, cachedController) -> {
            if (cachedController != null && cachedController.getControlledDevice().equals((Object)device)) {
                return cachedController;
            }
            return switch (device.getControlDeviceName().trim()) {
                case "ShellyPlugS" -> new ShellyPlugSController(device, eventEntryManagerService, shellyRestService);
                case "Shelly1" -> new Shelly1Controller(device, eventEntryManagerService, shellyRestService);
                case "Shelly1PM" -> new Shelly1PMController(device, eventEntryManagerService, shellyRestService);
                case "Shelly1PMPlus" -> new Shelly1PMPlusController(device, eventEntryManagerService, shellyRestService);
                case "Shelly3EM" -> new Shelly3EMController(device, eventEntryManagerService, shellyRestService);
                case "ShellyPro3" -> new ShellyPro3Controller(device, eventEntryManagerService, shellyRestService);
                case "ShellyAddonDS18B20" -> new ShellyAddonDS18B20Controller(device, eventEntryManagerService, shellyRestService);
                case "ShellyPro4PM" -> new ShellyPro4PMController(device, eventEntryManagerService, shellyRestService);
                case "ShellyPro3EM" -> new ShellyPro3EMController(device, eventEntryManagerService, shellyRestService);
                case "ShellyPMMini" -> new ShellyPMMini(device, eventEntryManagerService, shellyRestService);
                case "ShellyPlusPlugS" -> new ShellyPlusPlugSController(device, eventEntryManagerService, shellyRestService);
                case "ShellyDimmerGen3" -> new ShellyDimmerGen3Controller(device, eventEntryManagerService, shellyRestService);
                default -> null;
            };
        });
    }

    public static List<String> getSmartDeviceList() {
        ArrayList<String> smartDeviceList = new ArrayList<String>();
        smartDeviceList.add("ShellyPlugS");
        smartDeviceList.add("ShellyPlusPlugS");
        smartDeviceList.add("Shelly1");
        smartDeviceList.add("Shelly1PM");
        smartDeviceList.add("Shelly1PMPlus");
        smartDeviceList.add("Shelly3EM");
        smartDeviceList.add("ShellyPro3");
        smartDeviceList.add("ShellyAddonDS18B20");
        smartDeviceList.add("ShellyPro3EM");
        smartDeviceList.add("ShellyPMMini");
        smartDeviceList.add("ShellyPro4PM");
        smartDeviceList.add("ShellyDimmerGen3");
        return smartDeviceList;
    }

    public static void removeControllerFromCache(Long id) {
        controllerCache.remove(id);
    }
}

