/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.invertermaps;

import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.invertermaps.InverterMappingConfiguration;
import cz.snyll.sunny.invertermaps.InverterMappingConfigurationFactory;
import cz.snyll.sunny.invertermaps.SolaxWallboxC3MappingConfiguration;
import cz.snyll.sunny.invertermaps.SolaxX1BoostMappingConfiguration;
import cz.snyll.sunny.invertermaps.SolaxX1HybridG4MappingConfiguration;
import cz.snyll.sunny.invertermaps.SolaxX3HybridG3MappingConfiguration;
import cz.snyll.sunny.invertermaps.SolaxX3HybridG3V2MappingConfiguration;
import cz.snyll.sunny.invertermaps.SolaxX3HybridG4MappingConfiguration;
import cz.snyll.sunny.invertermaps.SolaxX3HybridG4SettingsMappingConfiguration;
import cz.snyll.sunny.invertermaps.SolaxX3HybridG4WriteMappingConfiguration;
import cz.snyll.sunny.invertermaps.SolaxX3MicG2MappingConfiguration;
import cz.snyll.sunny.invertermaps.SolaxX3MicMappingConfiguration;
import cz.snyll.sunny.invertermaps.SolaxX3ProMappingConfiguration;
import cz.snyll.sunny.invertermaps.SolaxX3ProWriteMappingConfiguration;
import cz.snyll.sunny.invertermaps.SolaxX3UltraMappingConfiguration;
import cz.snyll.sunny.invertermapsMODBUS.SolaxX3HybridG4ModbusHoldingMappingConfiguration;
import cz.snyll.sunny.invertermapsMODBUS.SolaxX3HybridG4ModbusMappingConfiguration;
import cz.snyll.sunny.invertermapsMODBUS.SolaxX3HybridG4ModbusWriteMappingConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InverterMappingConfigurationFactory {
    private final SolaxX3HybridG4MappingConfiguration solaxX3HybridG4MC;
    private final SolaxX3HybridG3MappingConfiguration solaxX3HybridG3MC;
    private final SolaxX3HybridG3V2MappingConfiguration solaxX3HybridG3V2MC;
    private final SolaxX1BoostMappingConfiguration solaxX1BoostMC;
    private final SolaxX3ProMappingConfiguration solaxX3ProMC;
    private final SolaxX3MicMappingConfiguration solaxX3MicMC;
    private final SolaxX3MicG2MappingConfiguration solaxX3MicG2MC;
    private final SolaxX1HybridG4MappingConfiguration solaxX1HybridG4MC;
    private final SolaxX3HybridG4SettingsMappingConfiguration solaxX3HybridG4SettingsMC;
    private final SolaxWallboxC3MappingConfiguration solaxWallboxC3MC;
    private final SolaxX3UltraMappingConfiguration solaxX3UltraMC;
    private final SolaxX3HybridG4WriteMappingConfiguration solaxX3HybridG4WriteMC;
    private final SolaxX3ProWriteMappingConfiguration solaxX3ProWriteMC;
    private final SolaxX3HybridG4ModbusMappingConfiguration solaxX3HybridG4ModbusMC;
    private final SolaxX3HybridG4ModbusHoldingMappingConfiguration solaxX3HybridG4ModbusHoldingMC;
    private final SolaxX3HybridG4ModbusWriteMappingConfiguration solaxX3HybridG4ModbusWriteMC;

    @Autowired
    public InverterMappingConfigurationFactory(SolaxX3MicG2MappingConfiguration solaxX3MicG2MC, SolaxX3HybridG3MappingConfiguration solaxX3HybridG3MC, SolaxX3HybridG3V2MappingConfiguration solaxX3HybridG3V2MC, SolaxX3MicMappingConfiguration solaxX3MicMC, SolaxX3HybridG4MappingConfiguration solaxX3HybridG4MC, SolaxX1BoostMappingConfiguration solaxX1BoostMC, SolaxX3ProMappingConfiguration solaxX3ProMC, SolaxX1HybridG4MappingConfiguration solaxX1HybridG4MC, SolaxX3HybridG4SettingsMappingConfiguration solaxX3HybridG4SettingsMC, SolaxWallboxC3MappingConfiguration solaxWallboxC3MC, SolaxX3UltraMappingConfiguration solaxX3UltraMC, SolaxX3HybridG4ModbusMappingConfiguration solaxX3HybridG4ModbusMappingConfiguration, SolaxX3HybridG4ModbusHoldingMappingConfiguration solaxX3HybridG4ModbusHoldingMappingConfiguration, SolaxX3HybridG4WriteMappingConfiguration solaxX3HybridG4WriteMC, SolaxX3ProWriteMappingConfiguration solaxX3ProWriteMC, SolaxX3HybridG4ModbusWriteMappingConfiguration solaxX3HybridG4ModbusWriteMappingConfiguration) {
        this.solaxX3HybridG4MC = solaxX3HybridG4MC;
        this.solaxX1BoostMC = solaxX1BoostMC;
        this.solaxX3ProMC = solaxX3ProMC;
        this.solaxX3HybridG3MC = solaxX3HybridG3MC;
        this.solaxX3MicMC = solaxX3MicMC;
        this.solaxX1HybridG4MC = solaxX1HybridG4MC;
        this.solaxX3HybridG4SettingsMC = solaxX3HybridG4SettingsMC;
        this.solaxWallboxC3MC = solaxWallboxC3MC;
        this.solaxX3MicG2MC = solaxX3MicG2MC;
        this.solaxX3HybridG3V2MC = solaxX3HybridG3V2MC;
        this.solaxX3UltraMC = solaxX3UltraMC;
        this.solaxX3ProWriteMC = solaxX3ProWriteMC;
        this.solaxX3HybridG4WriteMC = solaxX3HybridG4WriteMC;
        this.solaxX3HybridG4ModbusMC = solaxX3HybridG4ModbusMappingConfiguration;
        this.solaxX3HybridG4ModbusHoldingMC = solaxX3HybridG4ModbusHoldingMappingConfiguration;
        this.solaxX3HybridG4ModbusWriteMC = solaxX3HybridG4ModbusWriteMappingConfiguration;
    }

    public InverterMappingConfiguration getInverterConfig(String inverterSN, Inverter.CommunicationType communicationType) {
        InverterType type = this.findInverterType(inverterSN);
        if (communicationType == Inverter.CommunicationType.ModbusRTU || communicationType == Inverter.CommunicationType.ModbusTCP) {
            return switch (1.$SwitchMap$cz$snyll$sunny$invertermaps$InverterMappingConfigurationFactory$InverterType[type.ordinal()]) {
                case 1 -> this.solaxX3HybridG4ModbusMC;
                default -> this.solaxX3HybridG4ModbusMC;
            };
        }
        return switch (1.$SwitchMap$cz$snyll$sunny$invertermaps$InverterMappingConfigurationFactory$InverterType[type.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.solaxX3HybridG4MC;
            case 2 -> this.solaxX3HybridG3MC;
            case 3 -> this.solaxX3HybridG3V2MC;
            case 4 -> this.solaxX3ProMC;
            case 5 -> this.solaxX1BoostMC;
            case 6 -> this.solaxX1HybridG4MC;
            case 7 -> this.solaxX3MicMC;
            case 8 -> this.solaxX3MicG2MC;
            case 9 -> this.solaxX3UltraMC;
            case 10 -> this.solaxWallboxC3MC;
        };
    }

    public InverterMappingConfiguration getInverterSettingsConfig(String inverterSN, Inverter.CommunicationType communicationType) {
        InverterType type = this.findInverterType(inverterSN);
        if (communicationType == Inverter.CommunicationType.ModbusRTU || communicationType == Inverter.CommunicationType.ModbusTCP) {
            return switch (1.$SwitchMap$cz$snyll$sunny$invertermaps$InverterMappingConfigurationFactory$InverterType[type.ordinal()]) {
                case 1 -> this.solaxX3HybridG4ModbusHoldingMC;
                default -> this.solaxX3HybridG4ModbusHoldingMC;
            };
        }
        return switch (1.$SwitchMap$cz$snyll$sunny$invertermaps$InverterMappingConfigurationFactory$InverterType[type.ordinal()]) {
            case 1 -> this.solaxX3HybridG4SettingsMC;
            default -> this.solaxX3HybridG4SettingsMC;
        };
    }

    public InverterMappingConfiguration getInverterWriteConfig(String inverterSN, Inverter.CommunicationType communicationType) {
        InverterType type = this.findInverterType(inverterSN);
        if (communicationType == Inverter.CommunicationType.ModbusRTU || communicationType == Inverter.CommunicationType.ModbusTCP) {
            return switch (1.$SwitchMap$cz$snyll$sunny$invertermaps$InverterMappingConfigurationFactory$InverterType[type.ordinal()]) {
                case 1 -> this.solaxX3HybridG4ModbusWriteMC;
                default -> null;
            };
        }
        return switch (1.$SwitchMap$cz$snyll$sunny$invertermaps$InverterMappingConfigurationFactory$InverterType[type.ordinal()]) {
            case 1 -> this.solaxX3HybridG4WriteMC;
            case 4 -> this.solaxX3ProWriteMC;
            default -> null;
        };
    }

    private InverterType findInverterType(String inverterSN) {
        if (inverterSN.startsWith("H34")) {
            return InverterType.SOLAX_X3_HYBRID_G4;
        }
        if (inverterSN.startsWith("H3UE08")) {
            return InverterType.SOLAX_X3_HYBRID_G3V2;
        }
        if (inverterSN.startsWith("H3UE")) {
            return InverterType.SOLAX_X3_HYBRID_G3V2;
        }
        if (inverterSN.startsWith("H3B")) {
            return InverterType.SOLAX_X3_ULTRA;
        }
        if (inverterSN.startsWith("H3")) {
            return InverterType.SOLAX_X3_HYBRID_G3V2;
        }
        if (inverterSN.startsWith("MPT")) {
            return InverterType.SOLAX_X3_PRO;
        }
        if (inverterSN.startsWith("MC106T") || inverterSN.startsWith("MP156T") || inverterSN.startsWith("MC204T") || inverterSN.startsWith("MC206T") || inverterSN.startsWith("MC215T") || inverterSN.startsWith("MU806T") || inverterSN.startsWith("MC210")) {
            return InverterType.SOLAX_X3_MIC_G2;
        }
        if (inverterSN.startsWith("MC103T") || inverterSN.startsWith("MP153T") || inverterSN.startsWith("MC203T") || inverterSN.startsWith("MC502T") || inverterSN.startsWith("MU502T") || inverterSN.startsWith("MC702T") || inverterSN.startsWith("MU702T") || inverterSN.startsWith("MU802T") || inverterSN.startsWith("MU803T")) {
            return InverterType.SOLAX_X3_MIC;
        }
        if (inverterSN.startsWith("XB3")) {
            return InverterType.SOLAX_X1_BOOST;
        }
        if (inverterSN.startsWith("XBE")) {
            return InverterType.SOLAX_X1_BOOST;
        }
        if (inverterSN.startsWith("H4")) {
            return InverterType.SOLAX_X1_HYBRID_G4;
        }
        if (inverterSN.startsWith("C3")) {
            return InverterType.SOLAX_WALLBOX_C3;
        }
        return InverterType.SOLAX_X3_HYBRID_G4;
    }
}

