/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.domain;

import cz.snyll.sunny.domain.DeviceSetting;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Set;

@Entity
@Table(name="email_notifications")
public class EmailNotification {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(columnDefinition="varchar(255) default ''")
    @Size(min=3, message="{emailnotification.error.size}")
    private @Size(min=3, message="{emailnotification.error.size}") String notificationName;
    @Column(columnDefinition="text default ''")
    @Size(min=3, max=5000, message="{emailnotification.error.size}")
    private @Size(min=3, max=5000, message="{emailnotification.error.size}") String emailBody;
    @Column(columnDefinition="varchar(255) default ''")
    @Size(min=3, message="{emailnotification.error.size}")
    private @Size(min=3, message="{emailnotification.error.size}") String emailSubject;
    @Column(columnDefinition="integer default 1")
    @Positive(message="{emailnotification.error.positive}")
    private @Positive(message="{emailnotification.error.positive}") int notificationDelay;
    @Column(columnDefinition="boolean default false")
    private boolean notificationActive;
    @Column(columnDefinition="boolean default true")
    private boolean enabled;
    @Column(columnDefinition="boolean default false")
    private boolean sendWhenEnds;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="devicesetting_notification", joinColumns={@JoinColumn(name="notification_id")}, inverseJoinColumns={@JoinColumn(name="devicesetting_id")})
    private Set<DeviceSetting> notificationConditions;
    @Column(columnDefinition="timestamp default current_timestamp")
    private LocalDateTime lastSent;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailNotification that = (EmailNotification)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Long getId() {
        return this.id;
    }

    public String getNotificationName() {
        return this.notificationName;
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public int getNotificationDelay() {
        return this.notificationDelay;
    }

    public boolean isNotificationActive() {
        return this.notificationActive;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSendWhenEnds() {
        return this.sendWhenEnds;
    }

    public Set<DeviceSetting> getNotificationConditions() {
        return this.notificationConditions;
    }

    public LocalDateTime getLastSent() {
        return this.lastSent;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNotificationName(String notificationName) {
        this.notificationName = notificationName;
    }

    public void setEmailBody(String emailBody) {
        this.emailBody = emailBody;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public void setNotificationDelay(int notificationDelay) {
        this.notificationDelay = notificationDelay;
    }

    public void setNotificationActive(boolean notificationActive) {
        this.notificationActive = notificationActive;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSendWhenEnds(boolean sendWhenEnds) {
        this.sendWhenEnds = sendWhenEnds;
    }

    public void setNotificationConditions(Set<DeviceSetting> notificationConditions) {
        this.notificationConditions = notificationConditions;
    }

    public void setLastSent(LocalDateTime lastSent) {
        this.lastSent = lastSent;
    }
}

