/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.domain;

import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.DeviceSetting;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import java.util.Set;

@Entity
@Table(name="diverters")
public class Diverter {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Size(min=3, message="Please enter some Diverter name at least 3 characters long.")
    private @Size(min=3, message="Please enter some Diverter name at least 3 characters long.") String diverterName;
    @Column(columnDefinition="float default 5")
    private float levelStep;
    @Column(columnDefinition="integer default 300")
    private int exportThreshold;
    @Column(columnDefinition="integer default -300")
    private int importThreshold;
    private String exportInfoDataKey;
    @ManyToOne
    @JoinColumn(name="diverter_device_id")
    private Device diverterDevice;
    @Column(columnDefinition="boolean default true")
    private boolean active;
    @Column(columnDefinition="integer default 0")
    private int priority;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="devicesetting_diverter", joinColumns={@JoinColumn(name="diverter_id")}, inverseJoinColumns={@JoinColumn(name="devicesetting_id")})
    private Set<DeviceSetting> deviceSettings;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="devicesetting_diverter_hard", joinColumns={@JoinColumn(name="diverter_id")}, inverseJoinColumns={@JoinColumn(name="devicesetting_id")})
    private Set<DeviceSetting> deviceSettingsHard;

    public Diverter(String diverterName, float levelStep, int exportThreshold, int importThreshold, String exportInfoDataKey, boolean active, int priority) {
        this.diverterName = diverterName;
        this.levelStep = levelStep;
        this.exportThreshold = exportThreshold;
        this.importThreshold = importThreshold;
        this.exportInfoDataKey = exportInfoDataKey;
        this.active = active;
        this.priority = priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Diverter diverter = (Diverter)o;
        return Objects.equals(this.id, diverter.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Long getId() {
        return this.id;
    }

    public String getDiverterName() {
        return this.diverterName;
    }

    public float getLevelStep() {
        return this.levelStep;
    }

    public int getExportThreshold() {
        return this.exportThreshold;
    }

    public int getImportThreshold() {
        return this.importThreshold;
    }

    public String getExportInfoDataKey() {
        return this.exportInfoDataKey;
    }

    public Device getDiverterDevice() {
        return this.diverterDevice;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getPriority() {
        return this.priority;
    }

    public Set<DeviceSetting> getDeviceSettings() {
        return this.deviceSettings;
    }

    public Set<DeviceSetting> getDeviceSettingsHard() {
        return this.deviceSettingsHard;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDiverterName(String diverterName) {
        this.diverterName = diverterName;
    }

    public void setLevelStep(float levelStep) {
        this.levelStep = levelStep;
    }

    public void setExportThreshold(int exportThreshold) {
        this.exportThreshold = exportThreshold;
    }

    public void setImportThreshold(int importThreshold) {
        this.importThreshold = importThreshold;
    }

    public void setExportInfoDataKey(String exportInfoDataKey) {
        this.exportInfoDataKey = exportInfoDataKey;
    }

    public void setDiverterDevice(Device diverterDevice) {
        this.diverterDevice = diverterDevice;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setDeviceSettings(Set<DeviceSetting> deviceSettings) {
        this.deviceSettings = deviceSettings;
    }

    public void setDeviceSettingsHard(Set<DeviceSetting> deviceSettingsHard) {
        this.deviceSettingsHard = deviceSettingsHard;
    }

    public Diverter() {
    }
}

