/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import cz.snyll.sunny.domain.Trigger;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.Size;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.springframework.format.annotation.DateTimeFormat;

@Table(name="devicesettings")
@Entity
public class DeviceSetting {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", nullable=false)
    private Long id;
    @Size(min=3, message="{devicesetting.devicesetting_name_error}")
    private @Size(min=3, message="{devicesetting.devicesetting_name_error}") String deviceSettingName;
    private int deviceSettingPriority;
    @DateTimeFormat(pattern="HH:mm")
    @JsonFormat(pattern="HH:mm")
    private LocalTime timeWindowFrom;
    @DateTimeFormat(pattern="HH:mm")
    @JsonFormat(pattern="HH:mm")
    private LocalTime timeWindowTo = LocalTime.parse("23:59");
    @JsonProperty(value="active")
    private boolean isActive;
    public boolean activeInAwayMode;
    private int triggerEveryNthDay;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="devicesetting_trigger", joinColumns={@JoinColumn(name="devicesetting_id")}, inverseJoinColumns={@JoinColumn(name="trigger_id")})
    private Set<Trigger> triggers;
    @Transient
    private String timeWindowFromText;
    @Transient
    private String timeWindowToText;
    private int timeSundown;
    private int timeSunrise;

    @JsonIgnore
    public void setTimeWindowFrom(String timeWindowFrom) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
        this.timeWindowFrom = LocalTime.parse(timeWindowFrom, formatter);
    }

    @JsonIgnore
    public void setTimeWindowTo(String timeWindowTo) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
        this.timeWindowTo = LocalTime.parse(timeWindowTo, formatter);
    }

    @JsonIgnore
    public void setIsActive(String value) {
        this.isActive = value.equals("true");
    }

    @JsonProperty(value="active")
    public void setActive(boolean active) {
        this.isActive = active;
    }

    @JsonIgnore
    public void setTriggers(String[] triggers) {
        this.triggers = new HashSet();
        for (String trigger : triggers) {
            Trigger newTrigger = new Trigger();
            newTrigger.setId(Long.valueOf(Long.parseLong(trigger)));
            this.triggers.add(newTrigger);
        }
    }

    @JsonProperty(value="triggers")
    public void setTriggers(Set<Trigger> triggers) {
        this.triggers = triggers;
    }

    public void addTrigger(Trigger trigger) {
        this.triggers.add(trigger);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceSetting that = (DeviceSetting)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "DeviceSetting{id=" + this.id + ", deviceSettingName='" + this.deviceSettingName + "', deviceSettingPriority=" + this.deviceSettingPriority + ", timeWindowFrom=" + this.timeWindowFrom + ", timeWindowTo=" + this.timeWindowTo + ", isActive=" + this.isActive + ", triggerEveryNthDay=" + this.triggerEveryNthDay + ", triggers=" + this.triggers + "}";
    }

    public String getTimeWindowFromText() {
        if (this.timeWindowFrom == null) {
            this.timeWindowFrom = LocalTime.parse("00:00");
        }
        return this.timeWindowFrom.toString();
    }

    public String getTimeWindowToText() {
        if (this.timeWindowTo == null) {
            this.timeWindowTo = LocalTime.parse("00:00");
        }
        return this.timeWindowTo.toString();
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setDeviceSettingName(String deviceSettingName) {
        this.deviceSettingName = deviceSettingName;
    }

    public String getDeviceSettingName() {
        return this.deviceSettingName;
    }

    public void setDeviceSettingPriority(int deviceSettingPriority) {
        this.deviceSettingPriority = deviceSettingPriority;
    }

    public int getDeviceSettingPriority() {
        return this.deviceSettingPriority;
    }

    public LocalTime getTimeWindowFrom() {
        return this.timeWindowFrom;
    }

    public LocalTime getTimeWindowTo() {
        return this.timeWindowTo;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isActiveInAwayMode() {
        return this.activeInAwayMode;
    }

    public void setActiveInAwayMode(boolean activeInAwayMode) {
        this.activeInAwayMode = activeInAwayMode;
    }

    public void setTriggerEveryNthDay(int triggerEveryNthDay) {
        this.triggerEveryNthDay = triggerEveryNthDay;
    }

    public int getTriggerEveryNthDay() {
        return this.triggerEveryNthDay;
    }

    public Set<Trigger> getTriggers() {
        return this.triggers;
    }

    public void setTimeSundown(int timeSundown) {
        this.timeSundown = timeSundown;
    }

    public int getTimeSundown() {
        return this.timeSundown;
    }

    public void setTimeSunrise(int timeSunrise) {
        this.timeSunrise = timeSunrise;
    }

    public int getTimeSunrise() {
        return this.timeSunrise;
    }
}

