/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Entity
@Table(name="daily_records")
public class DailyRecord {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private long Id;
    @Column(columnDefinition="int default 0")
    private int balance;
    @Column(columnDefinition="float default 0")
    private float totalConsumption;
    @Column(columnDefinition="float default 0")
    private float gridConsumption;
    @Column(columnDefinition="float default 0")
    private float gridFeedin;
    @Column(columnDefinition="float default 0")
    private float panelEnergy;
    @Column(columnDefinition="float default 0")
    private float acEnergy;
    @Column(columnDefinition="float default 0")
    private float selfConsumed;
    @Column(columnDefinition="float default 0")
    private float energyPricePerKwh;
    @Column(columnDefinition="float default 0")
    private float energyPricePerKwhSell;
    @Column(columnDefinition="float default 0")
    private float todaySpotEarnings;
    @Column(columnDefinition="float default 0")
    private float todaySpotEarningsLocalCurrency;
    @Column(columnDefinition="float default 0")
    private float todaySpotSavingsLocalCurrency;
    @Column(name="updated_timestamp")
    private LocalDateTime updatedTimestamp;
    private LocalDate date;

    public long getId() {
        return this.Id;
    }

    public int getBalance() {
        return this.balance;
    }

    public float getTotalConsumption() {
        return this.totalConsumption;
    }

    public float getGridConsumption() {
        return this.gridConsumption;
    }

    public float getGridFeedin() {
        return this.gridFeedin;
    }

    public float getPanelEnergy() {
        return this.panelEnergy;
    }

    public float getAcEnergy() {
        return this.acEnergy;
    }

    public float getSelfConsumed() {
        return this.selfConsumed;
    }

    public float getEnergyPricePerKwh() {
        return this.energyPricePerKwh;
    }

    public float getEnergyPricePerKwhSell() {
        return this.energyPricePerKwhSell;
    }

    public float getTodaySpotEarnings() {
        return this.todaySpotEarnings;
    }

    public float getTodaySpotEarningsLocalCurrency() {
        return this.todaySpotEarningsLocalCurrency;
    }

    public float getTodaySpotSavingsLocalCurrency() {
        return this.todaySpotSavingsLocalCurrency;
    }

    public LocalDateTime getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setId(long Id2) {
        this.Id = Id2;
    }

    public void setBalance(int balance) {
        this.balance = balance;
    }

    public void setTotalConsumption(float totalConsumption) {
        this.totalConsumption = totalConsumption;
    }

    public void setGridConsumption(float gridConsumption) {
        this.gridConsumption = gridConsumption;
    }

    public void setGridFeedin(float gridFeedin) {
        this.gridFeedin = gridFeedin;
    }

    public void setPanelEnergy(float panelEnergy) {
        this.panelEnergy = panelEnergy;
    }

    public void setAcEnergy(float acEnergy) {
        this.acEnergy = acEnergy;
    }

    public void setSelfConsumed(float selfConsumed) {
        this.selfConsumed = selfConsumed;
    }

    public void setEnergyPricePerKwh(float energyPricePerKwh) {
        this.energyPricePerKwh = energyPricePerKwh;
    }

    public void setEnergyPricePerKwhSell(float energyPricePerKwhSell) {
        this.energyPricePerKwhSell = energyPricePerKwhSell;
    }

    public void setTodaySpotEarnings(float todaySpotEarnings) {
        this.todaySpotEarnings = todaySpotEarnings;
    }

    public void setTodaySpotEarningsLocalCurrency(float todaySpotEarningsLocalCurrency) {
        this.todaySpotEarningsLocalCurrency = todaySpotEarningsLocalCurrency;
    }

    public void setTodaySpotSavingsLocalCurrency(float todaySpotSavingsLocalCurrency) {
        this.todaySpotSavingsLocalCurrency = todaySpotSavingsLocalCurrency;
    }

    public void setUpdatedTimestamp(LocalDateTime updatedTimestamp) {
        this.updatedTimestamp = updatedTimestamp;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DailyRecord)) {
            return false;
        }
        DailyRecord other = (DailyRecord)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getBalance() != other.getBalance()) {
            return false;
        }
        if (Float.compare(this.getTotalConsumption(), other.getTotalConsumption()) != 0) {
            return false;
        }
        if (Float.compare(this.getGridConsumption(), other.getGridConsumption()) != 0) {
            return false;
        }
        if (Float.compare(this.getGridFeedin(), other.getGridFeedin()) != 0) {
            return false;
        }
        if (Float.compare(this.getPanelEnergy(), other.getPanelEnergy()) != 0) {
            return false;
        }
        if (Float.compare(this.getAcEnergy(), other.getAcEnergy()) != 0) {
            return false;
        }
        if (Float.compare(this.getSelfConsumed(), other.getSelfConsumed()) != 0) {
            return false;
        }
        if (Float.compare(this.getEnergyPricePerKwh(), other.getEnergyPricePerKwh()) != 0) {
            return false;
        }
        if (Float.compare(this.getEnergyPricePerKwhSell(), other.getEnergyPricePerKwhSell()) != 0) {
            return false;
        }
        if (Float.compare(this.getTodaySpotEarnings(), other.getTodaySpotEarnings()) != 0) {
            return false;
        }
        if (Float.compare(this.getTodaySpotEarningsLocalCurrency(), other.getTodaySpotEarningsLocalCurrency()) != 0) {
            return false;
        }
        if (Float.compare(this.getTodaySpotSavingsLocalCurrency(), other.getTodaySpotSavingsLocalCurrency()) != 0) {
            return false;
        }
        LocalDateTime this$updatedTimestamp = this.getUpdatedTimestamp();
        LocalDateTime other$updatedTimestamp = other.getUpdatedTimestamp();
        if (this$updatedTimestamp == null ? other$updatedTimestamp != null : !((Object)this$updatedTimestamp).equals(other$updatedTimestamp)) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DailyRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $Id = this.getId();
        result = result * 59 + (int)($Id >>> 32 ^ $Id);
        result = result * 59 + this.getBalance();
        result = result * 59 + Float.floatToIntBits(this.getTotalConsumption());
        result = result * 59 + Float.floatToIntBits(this.getGridConsumption());
        result = result * 59 + Float.floatToIntBits(this.getGridFeedin());
        result = result * 59 + Float.floatToIntBits(this.getPanelEnergy());
        result = result * 59 + Float.floatToIntBits(this.getAcEnergy());
        result = result * 59 + Float.floatToIntBits(this.getSelfConsumed());
        result = result * 59 + Float.floatToIntBits(this.getEnergyPricePerKwh());
        result = result * 59 + Float.floatToIntBits(this.getEnergyPricePerKwhSell());
        result = result * 59 + Float.floatToIntBits(this.getTodaySpotEarnings());
        result = result * 59 + Float.floatToIntBits(this.getTodaySpotEarningsLocalCurrency());
        result = result * 59 + Float.floatToIntBits(this.getTodaySpotSavingsLocalCurrency());
        LocalDateTime $updatedTimestamp = this.getUpdatedTimestamp();
        result = result * 59 + ($updatedTimestamp == null ? 43 : ((Object)$updatedTimestamp).hashCode());
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    public String toString() {
        return "DailyRecord(Id=" + this.getId() + ", balance=" + this.getBalance() + ", totalConsumption=" + this.getTotalConsumption() + ", gridConsumption=" + this.getGridConsumption() + ", gridFeedin=" + this.getGridFeedin() + ", panelEnergy=" + this.getPanelEnergy() + ", acEnergy=" + this.getAcEnergy() + ", selfConsumed=" + this.getSelfConsumed() + ", energyPricePerKwh=" + this.getEnergyPricePerKwh() + ", energyPricePerKwhSell=" + this.getEnergyPricePerKwhSell() + ", todaySpotEarnings=" + this.getTodaySpotEarnings() + ", todaySpotEarningsLocalCurrency=" + this.getTodaySpotEarningsLocalCurrency() + ", todaySpotSavingsLocalCurrency=" + this.getTodaySpotSavingsLocalCurrency() + ", updatedTimestamp=" + this.getUpdatedTimestamp() + ", date=" + this.getDate() + ")";
    }
}

