/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.domain.Diverter;
import cz.snyll.sunny.repositories.DiverterRepository;
import cz.snyll.sunny.services.DeviceManagerService;
import cz.snyll.sunny.services.DeviceSettingManagerService;
import jakarta.transaction.Transactional;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DiverterController {
    private final DiverterRepository diverterRepository;
    private final DeviceManagerService deviceManagerService;
    private final DeviceSettingManagerService deviceSettingManagerService;

    @Autowired
    public DiverterController(DiverterRepository diverterRepository, DeviceManagerService deviceManagerService, DeviceSettingManagerService deviceSettingManagerService) {
        this.diverterRepository = diverterRepository;
        this.deviceManagerService = deviceManagerService;
        this.deviceSettingManagerService = deviceSettingManagerService;
    }

    @GetMapping(value={"/diverter"})
    public String diverterForm(Model model, @RequestParam(required=false) Long id) {
        Diverter diverter;
        Diverter diverter2 = diverter = id != null && id > 0L ? this.diverterRepository.findById((Object)id).orElse(new Diverter()) : new Diverter("Diverter 1", 10.0f, 300, -200, "solax_exported_power", true, 0);
        if (diverter.getExportInfoDataKey() == null || diverter.getExportInfoDataKey().isEmpty()) {
            diverter.setExportInfoDataKey("solax_exported_power");
        }
        List devices = this.deviceManagerService.loadAllDimmableDevices();
        model.addAttribute("diverter", (Object)diverter);
        model.addAttribute("devices", (Object)devices);
        model.addAttribute("devicesettings", (Object)this.deviceSettingManagerService.loadAll());
        model.addAttribute("devicesettingshard", (Object)this.deviceSettingManagerService.loadAll());
        return "diverter";
    }

    @PostMapping(value={"/diverter"})
    public String diverterSubmit(@Valid @ModelAttribute Diverter diverter, BindingResult result, Model model) {
        List devices = this.deviceManagerService.loadAllDimmableDevices();
        model.addAttribute("devices", (Object)devices);
        model.addAttribute("devicesettings", (Object)this.deviceSettingManagerService.loadAll());
        model.addAttribute("devicesettingshard", (Object)this.deviceSettingManagerService.loadAll());
        if (result.hasErrors()) {
            return "diverter";
        }
        this.diverterRepository.save((Object)diverter);
        return "redirect:/diverterlist?success=true";
    }

    @GetMapping(value={"/diverter/edit"})
    @Transactional
    public String diverterEdit(@RequestParam Long id, @RequestParam(required=false, defaultValue="false") boolean delete) {
        if (delete && id != null && id > 0L) {
            Optional diverterOpt = this.diverterRepository.findById((Object)id);
            if (diverterOpt.isPresent()) {
                Diverter diverter = (Diverter)diverterOpt.get();
                diverter.getDeviceSettings().clear();
                diverter.getDeviceSettingsHard().clear();
                this.diverterRepository.save((Object)diverter);
                this.diverterRepository.delete((Object)diverter);
            }
            return "redirect:/diverterlist?deletesuccess=true";
        }
        return "redirect:/diverter?id=" + id;
    }
}

