/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.domain.DeviceSetting;
import cz.snyll.sunny.domain.Trigger;
import cz.snyll.sunny.repositories.DeviceRepository;
import cz.snyll.sunny.repositories.DeviceSettingRepository;
import cz.snyll.sunny.repositories.TriggerRepository;
import cz.snyll.sunny.services.DeviceSettingManagerService;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DeviceSettingController {
    @Autowired
    private DeviceSettingManagerService deviceSettingManagerService;
    @Autowired
    private DeviceSettingRepository deviceSettingRepository;
    @Autowired
    private TriggerRepository triggerRepository;
    @Autowired
    private DeviceRepository deviceRepository;

    @GetMapping(value={"/devicesetting"})
    public String deviceSetting(Model model, @RequestParam(required=false) Long id) {
        if (id == null) {
            id = 0L;
        }
        DeviceSetting deviceSetting = this.deviceSettingRepository.findById((Object)id).orElseGet(() -> new DeviceSetting());
        ArrayList triggers = (ArrayList)this.triggerRepository.findAll();
        ArrayList devices = (ArrayList)this.deviceRepository.findAll();
        model.addAttribute("deviceSetting", (Object)deviceSetting);
        model.addAttribute("triggers", (Object)triggers);
        model.addAttribute("devices", (Object)devices);
        return "devicesetting";
    }

    @GetMapping(value={"/devicesetting/edit"})
    public String deviceSettingEdit(Model model, @RequestParam(required=false) Long id, @RequestParam(required=false) boolean delete) {
        if (delete && id > 0L) {
            try {
                this.deviceSettingManagerService.deleteDeviceSettingById(id.longValue());
            }
            catch (DataIntegrityViolationException e) {
                return "redirect:../devicesettingslist?deleteerror=true";
            }
            return "redirect:../devicesettingslist?deletesuccess=true";
        }
        return "redirect:../devicesettingslist";
    }

    @PostMapping(value={"/devicesetting"})
    public String deviceSubmit(@Valid @ModelAttribute DeviceSetting deviceSetting, BindingResult result, Model model) {
        try {
            model.addAttribute("deviceSetting", (Object)deviceSetting);
            if (deviceSetting.getTriggers() != null) {
                HashSet<Trigger> newTriggers = new HashSet<Trigger>();
                for (Trigger idTrigger : deviceSetting.getTriggers()) {
                    Trigger newTrigger = (Trigger)this.triggerRepository.findById((Object)idTrigger.getId()).get();
                    newTriggers.add(newTrigger);
                }
                deviceSetting.setTriggers(newTriggers);
            }
            ArrayList triggers = (ArrayList)this.triggerRepository.findAll();
            model.addAttribute("triggers", (Object)triggers);
            ArrayList devices = (ArrayList)this.deviceRepository.findAll();
            model.addAttribute("devices", (Object)devices);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result.hasErrors()) {
            return "devicesetting";
        }
        this.deviceSettingManagerService.saveDeviceSetting(deviceSetting);
        model.addAttribute("success", (Object)true);
        return "redirect:devicesettingslist?success=true";
    }
}

