/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.config;

import java.util.Map;

public class InverterMap {
    private int address;
    private float modifier;
    private String unit;
    private String dataType;
    private int length;

    public InverterMap(int address, float modifier, String unit, String dataType, int length) {
        this.address = address;
        this.modifier = modifier;
        this.unit = unit;
        this.dataType = dataType;
        this.length = length;
    }

    public static int getRegisterAddressOrDefault(Map<String, InverterMap> inverterMap, String key) {
        return inverterMap.containsKey(key) ? inverterMap.get(key).getAddress() : -1;
    }

    public static float getModifierOrDefault(Map<String, InverterMap> inverterMap, String key) {
        return inverterMap.containsKey(key) ? inverterMap.get(key).getModifier() : 1.0f;
    }

    public int getAddress() {
        return this.address;
    }

    public float getModifier() {
        return this.modifier;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getDataType() {
        return this.dataType;
    }

    public int getLength() {
        return this.length;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void setModifier(float modifier) {
        this.modifier = modifier;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InverterMap)) {
            return false;
        }
        InverterMap other = (InverterMap)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getAddress() != other.getAddress()) {
            return false;
        }
        if (Float.compare(this.getModifier(), other.getModifier()) != 0) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        return !(this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InverterMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAddress();
        result = result * 59 + Float.floatToIntBits(this.getModifier());
        result = result * 59 + this.getLength();
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        return result;
    }

    public String toString() {
        return "InverterMap(address=" + this.getAddress() + ", modifier=" + this.getModifier() + ", unit=" + this.getUnit() + ", dataType=" + this.getDataType() + ", length=" + this.getLength() + ")";
    }
}

