/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.smartinverterautomations;

import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.domain.SmartInverterAutomation;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.repositories.SmartInverterAutomationRepository;
import cz.snyll.sunny.services.DeviceSettingManagerService;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.InverterManagerService;
import cz.snyll.sunny.services.smartinverterautomations.ChargeAutomationManager;
import cz.snyll.sunny.services.smartinverterautomations.InverterWriteServiceFactory;
import cz.snyll.sunny.services.smartinverterautomations.InverterWriteServiceInterface;
import cz.snyll.sunny.services.smartinverterautomations.LimitExportAutomationManger;
import cz.snyll.sunny.services.smartinverterautomations.SmartInverterAutomationService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class SmartInverterAutomationService {
    private static final Logger log = LoggerFactory.getLogger(SmartInverterAutomationService.class);
    private final SmartInverterAutomationRepository automationRepository;
    private final InverterWriteServiceFactory writeServiceFactory;
    private final InfoDataManagerService infoDataManagerService;
    private final DeviceSettingManagerService deviceSettingManagerService;
    private final EventEntryManagerService eventEntryManagerService;
    private final ChargeAutomationManager chargeAutomationManager;
    private final LimitExportAutomationManger limitExportAutomationManger;
    private Map<Long, InverterState> tempInverterStates = new HashMap();
    private Map<Long, InverterState> actualInverterStates = new HashMap();
    private final InverterManagerService inverterManagerService;

    @Autowired
    public SmartInverterAutomationService(SmartInverterAutomationRepository automationRepository, InverterWriteServiceFactory writeServiceFactory, InfoDataManagerService infoDataManagerService, DeviceSettingManagerService deviceSettingManagerService, EventEntryManagerService eventEntryManagerService, ChargeAutomationManager chargeAutomationManager, LimitExportAutomationManger limitExportAutomationManger, InverterManagerService inverterManagerService) {
        this.automationRepository = automationRepository;
        this.writeServiceFactory = writeServiceFactory;
        this.infoDataManagerService = infoDataManagerService;
        this.deviceSettingManagerService = deviceSettingManagerService;
        this.eventEntryManagerService = eventEntryManagerService;
        this.chargeAutomationManager = chargeAutomationManager;
        this.limitExportAutomationManger = limitExportAutomationManger;
        this.inverterManagerService = inverterManagerService;
    }

    @Scheduled(fixedRate=6000L)
    public void processAutomations() {
        InverterState actualState;
        log.info("SMART INVERTER AUTOMATION: Starting automation processing");
        this.tempInverterStates = new HashMap();
        this.automationRepository.findAll().forEach(arg_0 -> this.processAutomation(arg_0));
        log.info("SMART INVERTER AUTOMATION: Applying changes to inverters");
        for (Map.Entry entry : this.actualInverterStates.entrySet()) {
            Long inverter = (Long)entry.getKey();
            actualState = (InverterState)entry.getValue();
            InverterState tempState = (InverterState)this.tempInverterStates.get(inverter);
            if (tempState == null) {
                tempState = new InverterState();
            }
            log.info("SMART INVERTER AUTOMATION: Inverter {} - Old state: battery: {}, export limit: {}", new Object[]{inverter, actualState.getBatteryState(), actualState.getExportLimitState()});
            log.info("SMART INVERTER AUTOMATION: Inverter {} - New state: battery: {}, export limit: {}", new Object[]{inverter, tempState.getBatteryState(), tempState.getExportLimitState()});
        }
        for (Map.Entry entry : this.tempInverterStates.entrySet()) {
            InverterState tempState = (InverterState)entry.getValue();
            actualState = (InverterState)this.actualInverterStates.get(entry.getKey());
            if (actualState == null) {
                actualState = new InverterState();
                this.actualInverterStates.put((Long)entry.getKey(), actualState);
            }
            Long inverterId = (Long)entry.getKey();
            InverterWriteServiceInterface writeService = this.writeServiceFactory.getInverterWriteService(inverterId);
            if (tempState.getBatteryState() != actualState.getBatteryState()) {
                switch (1.$SwitchMap$cz$snyll$sunny$services$smartinverterautomations$SmartInverterAutomationService$BatteryState[tempState.getBatteryState().ordinal()]) {
                    case 1: {
                        log.info("SMART INVERTER AUTOMATION: Starting battery charging for inverter {}", (Object)inverterId);
                        this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: Starting battery charging for inverter " + inverterId, EventEntry.EventType.INFO);
                        writeService.startBatteryCharging();
                        actualState.setBatteryState(BatteryState.CHARGE);
                        break;
                    }
                    case 2: {
                        log.info("SMART INVERTER AUTOMATION: Starting battery discharging for inverter {}", (Object)inverterId);
                        this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: Starting battery discharging for inverter " + inverterId, EventEntry.EventType.INFO);
                        writeService.startBatteryDischarging();
                        actualState.setBatteryState(BatteryState.DISCHARGE);
                        break;
                    }
                    case 3: {
                        if (actualState.getBatteryState() == BatteryState.DISCHARGE) {
                            log.info("SMART INVERTER AUTOMATION: Stopping battery discharging for inverter {}", (Object)inverterId);
                            this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: Stopping battery discharging for inverter " + inverterId, EventEntry.EventType.INFO);
                            writeService.stopBatteryDischarging();
                            actualState.setBatteryState(BatteryState.NO_ACTION);
                        }
                        if (actualState.getBatteryState() != BatteryState.CHARGE) break;
                        log.info("SMART INVERTER AUTOMATION: Stopping battery charging for inverter {}", (Object)inverterId);
                        this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: Stopping battery charging for inverter " + inverterId, EventEntry.EventType.INFO);
                        writeService.stopBatteryCharging();
                        actualState.setBatteryState(BatteryState.NO_ACTION);
                    }
                }
            }
            if (tempState.getExportLimitState() != actualState.getExportLimitState()) {
                Inverter inverter = this.inverterManagerService.loadInverter(inverterId);
                switch (1.$SwitchMap$cz$snyll$sunny$services$smartinverterautomations$SmartInverterAutomationService$ExportLimitState[tempState.getExportLimitState().ordinal()]) {
                    case 1: {
                        log.info("SMART INVERTER AUTOMATION: Setting original export limit for inverter {}", (Object)inverterId);
                        this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: Setting original export limit for inverter " + inverterId, EventEntry.EventType.INFO);
                        writeService.setExportLimit(inverter.getExportLimitOriginal());
                        actualState.setExportLimitState(ExportLimitState.NOT_LIMITED);
                        break;
                    }
                    case 2: {
                        log.info("SMART INVERTER AUTOMATION: Setting export limit for inverter {}", (Object)inverterId);
                        this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: Setting export limit for inverter " + inverterId, EventEntry.EventType.INFO);
                        writeService.setExportLimit(inverter.getExportLimitCustom());
                        actualState.setExportLimitState(ExportLimitState.LIMITED);
                        break;
                    }
                    case 3: {
                        log.error("SMART INVERTER AUTOMATION: Export limit state does not match real state for inverter {}", (Object)inverterId);
                        this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: Export limit state does not match real state for inverter " + inverterId, EventEntry.EventType.ERROR);
                        actualState.setExportLimitState(ExportLimitState.NOT_MATCHING_REAL_STATE);
                    }
                }
            }
            this.actualInverterStates.put(inverterId, actualState);
        }
    }

    private void processAutomation(SmartInverterAutomation automation) {
        log.info("SMART INVERTER AUTOMATION: Processing automation {}", (Object)automation.getAutomationName());
        ExportLimitState exportLimitState = ExportLimitState.NOT_LIMITED;
        BatteryState batteryState = BatteryState.NO_ACTION;
        if (!this.isAnyConditionMet(automation)) {
            log.info("SMART INVERTER AUTOMATION: No conditions met for automation {}", (Object)automation.getId());
            return;
        }
        if (automation.isExportLimitEnabled()) {
            try {
                exportLimitState = this.limitExportAutomationManger.getExportLimitState(automation, this.getCurrentSpotPrice().floatValue());
            }
            catch (Exception e) {
                log.error("SMART INVERTER AUTOMATION: Error while handling export limit state", (Throwable)e);
            }
        }
        Set inverters = automation.getInvertersApplied();
        for (Inverter inverter : inverters) {
            InverterState inverterState = (InverterState)this.tempInverterStates.get(inverter.getId());
            if (automation.isChargeEnabled() || automation.isForceDischargeEnabled()) {
                try {
                    batteryState = this.chargeAutomationManager.getBatteryState(automation, this.getCurrentBatteryPercentage(inverter), inverter.getChargeLimit(), inverter.getDischargeLimit(), (InverterState)this.actualInverterStates.get(inverter.getId()));
                    log.info("SMART INVERTER AUTOMATION: Battery state for automation {}: {}", (Object)automation.getId(), (Object)batteryState);
                }
                catch (Exception e) {
                    log.error("SMART INVERTER AUTOMATION: Error while handling battery state", (Throwable)e);
                }
            }
            if (inverterState == null) {
                inverterState = new InverterState();
                inverterState.setBatteryState(batteryState);
                inverterState.setExportLimitState(exportLimitState);
                this.tempInverterStates.put(inverter.getId(), inverterState);
                continue;
            }
            if (batteryState == BatteryState.CHARGE) {
                inverterState.setBatteryState(BatteryState.CHARGE);
            } else if (batteryState == BatteryState.DISCHARGE && inverterState.getBatteryState() != BatteryState.CHARGE) {
                inverterState.setBatteryState(BatteryState.DISCHARGE);
            }
            if (exportLimitState == ExportLimitState.LIMITED) {
                inverterState.setExportLimitState(ExportLimitState.LIMITED);
            }
            log.info("SMART INVERTER AUTOMATION: Saving state for inverter {} - battery: {}, export limit: {}", new Object[]{inverter.getId(), inverterState.getBatteryState(), inverterState.getExportLimitState()});
            this.tempInverterStates.put(inverter.getId(), inverterState);
        }
    }

    private boolean isAnyConditionMet(SmartInverterAutomation automation) {
        if (automation.getAutomationConditions().isEmpty()) {
            return true;
        }
        return automation.getAutomationConditions().stream().anyMatch(arg_0 -> ((DeviceSettingManagerService)this.deviceSettingManagerService).evaluateDeviceSetting(arg_0));
    }

    public List<SmartInverterAutomation> loadAll() {
        return (List)this.automationRepository.findAll();
    }

    private Float getCurrentSpotPrice() throws NumberFormatException {
        InfoData currentSpotPriceData = this.infoDataManagerService.findByDataKey("ote_price_current_hour_local_currency_kwh");
        if (currentSpotPriceData == null) {
            log.error("SMART INVERTER AUTOMATION: Current spot price data is null");
            this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: Error while getting current spot price data. Ignoring automation.", EventEntry.EventType.ERROR, 10);
            throw new NumberFormatException("Current spot price data is null");
        }
        float currentSpotPrice = 0.0f;
        try {
            currentSpotPrice = Float.parseFloat(currentSpotPriceData.getDataValue());
            if (!currentSpotPriceData.isValid()) {
                throw new NumberFormatException("Invalid data value");
            }
        }
        catch (NumberFormatException e) {
            log.error("SMART INVERTER AUTOMATION: Error while parsing current spot price data", (Throwable)e);
            this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: Error while parsing current spot price data or price is not valid. Ignoring automation.", EventEntry.EventType.ERROR, 10);
            throw new NumberFormatException("Current spot price data is null");
        }
        return Float.valueOf(currentSpotPrice);
    }

    private int getCurrentBatteryPercentage(Inverter inverter) throws NumberFormatException {
        InfoData currentBatteryPercentageData = this.infoDataManagerService.getInfoDataForInverter(inverter, "solax_battery_remaining_capacity");
        if (currentBatteryPercentageData == null) {
            log.error("SMART INVERTER AUTOMATION: Current battery percentage data is null");
            this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: Error while getting current battery percentage data. Ignoring automation.", EventEntry.EventType.ERROR, 10);
            return 0;
        }
        float currentBatteryPercentage = 0.0f;
        try {
            currentBatteryPercentage = Float.parseFloat(currentBatteryPercentageData.getDataValue());
            if (!currentBatteryPercentageData.isValid()) {
                throw new NumberFormatException("Invalid data value");
            }
        }
        catch (NumberFormatException e) {
            log.error("SMART INVERTER AUTOMATION: Error while parsing current battery percentage data", (Throwable)e);
            this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: Error while parsing current battery percentage data or percentage is not valid. Ignoring automation.", EventEntry.EventType.ERROR, 10);
            return 0;
        }
        return (int)currentBatteryPercentage;
    }
}

