/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.smartinverterautomations;

import cz.snyll.sunny.domain.SmartInverterAutomation;
import cz.snyll.sunny.services.smartinverterautomations.SmartInverterAutomationService;
import java.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LimitExportAutomationManger {
    private static final Logger log = LoggerFactory.getLogger(LimitExportAutomationManger.class);

    public SmartInverterAutomationService.ExportLimitState getExportLimitState(SmartInverterAutomation smartInverterAutomation, float currentPrice) {
        try {
            if (!this.isWithinTimeRange(smartInverterAutomation.getExportLimitStartTime(), smartInverterAutomation.getExportLimitEndTime())) {
                return SmartInverterAutomationService.ExportLimitState.NOT_LIMITED;
            }
            if (currentPrice <= smartInverterAutomation.getExportLimitPrice()) {
                return SmartInverterAutomationService.ExportLimitState.LIMITED;
            }
        }
        catch (Exception e) {
            log.error("SMART INVERTER AUTOMATION: Error while handling export limit state", (Throwable)e);
        }
        return SmartInverterAutomationService.ExportLimitState.NOT_LIMITED;
    }

    private boolean isWithinTimeRange(LocalTime startTime, LocalTime endTime) {
        if (startTime == null || endTime == null) {
            return false;
        }
        LocalTime now = LocalTime.now();
        return !now.isBefore(startTime) && !now.isAfter(endTime);
    }
}

