/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.smartinverterautomations;

import cz.snyll.sunny.config.InverterMap;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.invertermaps.InverterMappingConfigurationFactory;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.modbus.ModbusServiceFactory;
import cz.snyll.sunny.services.modbus.ModbusServiceInterface;
import cz.snyll.sunny.services.smartinverterautomations.InverterWriteServiceInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class InverterWriteServiceModbus
implements InverterWriteServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(InverterWriteServiceModbus.class);
    private Inverter inverter;
    private HashMap<String, InverterMap> inverterMap;
    private final InverterMappingConfigurationFactory inverterMappingConfigurationFactory;
    private final ModbusServiceFactory modbusServiceFactory;
    private ModbusServiceInterface modbusService;
    private final InfoDataManagerService infoDataManagerService;
    private int unlockRegisterAddress;
    private int systemOnOffRegisterAddress;
    private boolean isCharging = false;
    private boolean isDischarging = false;
    private static final int COMMAND_REGISTER_COUNT = 13;
    private static final int SOLAX_INVERTER_UNLOCK_VALUE = 2014;

    public InverterWriteServiceModbus(InverterMappingConfigurationFactory inverterMappingConfigurationFactory, ModbusServiceFactory modbusServiceFactory, InfoDataManagerService infoDataManagerService) {
        this.inverterMappingConfigurationFactory = inverterMappingConfigurationFactory;
        this.modbusServiceFactory = modbusServiceFactory;
        this.infoDataManagerService = infoDataManagerService;
    }

    public boolean startBatteryCharging() {
        if (this.validateChargeRegisterAddresses()) {
            log.error("Missing required register addresses for charging.");
            return false;
        }
        int powerControlMode = 3;
        int targetSetType = 1;
        int timeOfDuration = 60;
        int targetSoc = this.inverter.getChargeLimit();
        int targetActivePower = 0;
        int[] modbusData = this.prepareModbusData(powerControlMode, targetSetType, targetActivePower, timeOfDuration, targetSoc, 10000);
        this.wakeUpInverter();
        this.isCharging = true;
        int startAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"modbus_power_control");
        return this.modbusService.writeMultipleRegisters(startAddress, modbusData, false, 3);
    }

    public boolean startBatteryDischarging() {
        if (this.validateChargeRegisterAddresses()) {
            log.error("Missing required register addresses for discharging.");
            return false;
        }
        int powerControlMode = 1;
        int targetSetType = 1;
        int timeOfDuration = 60;
        int targetSoc = 0;
        int targetActivePower = -10000;
        int[] modbusData = this.prepareModbusData(powerControlMode, targetSetType, targetActivePower, timeOfDuration, targetSoc, 0);
        this.wakeUpInverter();
        this.isDischarging = true;
        int startAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"modbus_power_control");
        return this.modbusService.writeMultipleRegisters(startAddress, modbusData, false, 3);
    }

    public boolean stopBatteryDischarging() {
        int startAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"modbus_power_control");
        if (startAddress == -1) {
            log.error("Missing modbus_power_control register address for stopping discharging.");
            return false;
        }
        this.wakeUpInverter();
        int[] resetData = new int[]{0};
        this.isDischarging = false;
        return this.modbusService.writeMultipleRegisters(startAddress, resetData, false, 3);
    }

    public boolean stopBatteryCharging() {
        int startAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"modbus_power_control");
        if (startAddress == -1) {
            log.error("Missing modbus_power_control register address for stopping charging.");
            return false;
        }
        int[] resetData = new int[]{0};
        this.wakeUpInverter();
        this.isCharging = false;
        return this.modbusService.writeMultipleRegisters(startAddress, resetData, false, 3);
    }

    public boolean setExportLimit(int limitWatts) {
        int exportLimitRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"user_export_limit");
        float exportLimitModifier = InverterMap.getModifierOrDefault((Map)this.inverterMap, (String)"user_export_limit");
        int exportLimit = (int)((float)limitWatts * exportLimitModifier);
        if (exportLimitRegisterAddress == -1) {
            log.error("Missing export limit register address.");
            return false;
        }
        this.wakeUpInverter();
        boolean result = this.modbusService.writeSingleRegister(exportLimitRegisterAddress, exportLimit, false, 3);
        if (result) {
            log.info("Export limit set to {} watts", (Object)limitWatts);
        } else {
            log.error("Failed to set export limit to {} watts", (Object)limitWatts);
        }
        return result;
    }

    private int[] prepareModbusData(int enableValue, int targetType, int remoteControlActivePower, int duration, int targetSoc, int chargeDischargePower) {
        int[] data = new int[]{enableValue, targetType, remoteControlActivePower & 0xFFFF, remoteControlActivePower >> 16 & 0xFFFF, 0, 0, duration, targetSoc, 0, 0, chargeDischargePower & 0xFFFF, chargeDischargePower >> 16 & 0xFFFF, 10};
        return data;
    }

    private boolean validateChargeRegisterAddresses() {
        return InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"modbus_power_control") == -1 || InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"unlock") == -1 || InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"system_on_off") == -1 || InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"target_set_type") == -1 || InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"active_power") == -1 || InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"reactive_power") == -1 || InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"time_of_duration") == -1 || InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"target_soc") == -1;
    }

    private void unlockInverter() {
        try {
            if (this.modbusService.writeSingleRegister(this.unlockRegisterAddress, 2014, false, 3)) {
                log.info("Inverter unlocked successfully.");
            } else {
                log.error("Failed to unlock inverter.");
            }
        }
        catch (Exception e) {
            log.error("Failed to unlock inverter: {}", (Object)e.getMessage());
        }
    }

    private void wakeUpInverter() {
        try {
            int runmode = (int)Double.parseDouble(this.infoDataManagerService.getInfoDataForInverter(this.inverter, "solax_inverter_runmode").getDataValue());
            if (runmode == 9) {
                this.modbusService.writeSingleRegister(this.systemOnOffRegisterAddress, 1, false, 3);
            }
        }
        catch (Exception e) {
            log.error("Failed to wake up the inverter: {}", (Object)e.getMessage());
        }
    }

    public void setInverter(Inverter inverter) {
        this.inverter = inverter;
        this.initializeInverterMap();
        this.modbusService = this.modbusServiceFactory.getModbusService(this.inverter);
        this.unlockRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"unlock");
        this.systemOnOffRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"system_on_off");
    }

    private void initializeInverterMap() {
        try {
            Map apiMapperString = this.inverterMappingConfigurationFactory.getInverterWriteConfig(this.inverter.getInverterSerialNumber(), Inverter.CommunicationType.ModbusRTU).getInverterMap();
            this.inverterMap = new HashMap();
            for (Map.Entry entry : apiMapperString.entrySet()) {
                try {
                    String key = (String)entry.getKey();
                    InverterMap inverterMapValue = new InverterMap(Integer.parseInt((String)((ArrayList)entry.getValue()).get(0)), Float.parseFloat((String)((ArrayList)entry.getValue()).get(1)), (String)((ArrayList)entry.getValue()).get(2), (String)((ArrayList)entry.getValue()).get(3), Integer.parseInt((String)((ArrayList)entry.getValue()).get(4)));
                    this.inverterMap.put(key, inverterMapValue);
                }
                catch (Exception e) {
                    log.error("Error parsing inverter map for key {}: {}", entry.getKey(), (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            log.error("Error initializing inverter map: {}", (Object)e.getMessage());
        }
    }

    @Scheduled(fixedDelay=5000L)
    private void repeatCommand() {
        if (this.isCharging) {
            log.info("Repeating charging command...");
            this.startBatteryCharging();
        }
        if (this.isDischarging) {
            log.info("Repeating discharging command...");
            this.startBatteryDischarging();
        }
    }
}

