/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.smartinverterautomations;

import cz.snyll.sunny.domain.inverter.CloudDetails;
import cz.snyll.sunny.domain.inverter.ConnectionDetails;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.domain.inverter.LocalAPIDetails;
import cz.snyll.sunny.domain.inverter.ModbusRTUDetails;
import cz.snyll.sunny.domain.inverter.ModbusTCPDetails;
import cz.snyll.sunny.repositories.InverterRepository;
import cz.snyll.sunny.services.smartinverterautomations.InverterWriteServiceAPI;
import cz.snyll.sunny.services.smartinverterautomations.InverterWriteServiceFactory;
import cz.snyll.sunny.services.smartinverterautomations.InverterWriteServiceInterface;
import cz.snyll.sunny.services.smartinverterautomations.InverterWriteServiceModbus;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class InverterWriteServiceFactory {
    private final ApplicationContext context;
    private static final ConcurrentHashMap<Long, InverterWriteServiceInterface> writeServiceCache = new ConcurrentHashMap();
    public final InverterRepository inverterRepository;

    @Autowired
    public InverterWriteServiceFactory(ApplicationContext context, InverterRepository inverterRepository) {
        this.context = context;
        this.inverterRepository = inverterRepository;
    }

    public InverterWriteServiceInterface getInverterWriteService(Long inverterId) {
        return writeServiceCache.computeIfAbsent(inverterId, arg_0 -> this.createWriteService(arg_0));
    }

    private InverterWriteServiceInterface createWriteService(Long inverterId) {
        Inverter inverter = (Inverter)this.inverterRepository.findById((Object)inverterId).orElseThrow();
        ConnectionDetails details = inverter.getConnectionDetails();
        InverterWriteServiceInterface writeService = switch (1.$SwitchMap$cz$snyll$sunny$domain$inverter$Inverter$Manufacturer[inverter.getInverterManufacturer().ordinal()]) {
            case 1 -> {
                if (details instanceof LocalAPIDetails) {
                    yield (InverterWriteServiceInterface)this.context.getBean(InverterWriteServiceAPI.class);
                }
                if (details instanceof ModbusRTUDetails || details instanceof ModbusTCPDetails) {
                    yield (InverterWriteServiceInterface)this.context.getBean(InverterWriteServiceModbus.class);
                }
                if (details instanceof CloudDetails) {
                    yield (InverterWriteServiceInterface)this.context.getBean(InverterWriteServiceAPI.class);
                }
                throw new IllegalArgumentException("Unsupported connection details type for Solax: " + details.getClass().getName());
            }
            default -> throw new IllegalArgumentException("Unsupported manufacturer: " + inverter.getInverterManufacturer());
        };
        writeService.setInverter(inverter);
        return writeService;
    }

    public void updateWriteServiceCache(Inverter inverter) {
        InverterWriteServiceInterface writeService = this.createWriteService(inverter.getId());
        writeService.setInverter(inverter);
        writeServiceCache.put(inverter.getId(), writeService);
    }

    public void removeWriteServiceFromCache(Long id) {
        writeServiceCache.remove(id);
    }
}

