/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.smartinverterautomations;

import cz.snyll.sunny.config.InverterMap;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.invertermaps.InverterMappingConfigurationFactory;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.automation.InverterCloudController;
import cz.snyll.sunny.services.smartinverterautomations.InverterWriteServiceInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class InverterWriteServiceAPI
implements InverterWriteServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(InverterWriteServiceAPI.class);
    private Inverter inverter;
    private HashMap<String, InverterMap> inverterMap;
    private final InverterMappingConfigurationFactory inverterMappingConfigurationFactory;
    private final InfoDataManagerService infoDataManagerService;
    private final InverterCloudController inverterCloudController;
    private int inverterWorkmodeWhenDischargingStarted;

    @Autowired
    public InverterWriteServiceAPI(InverterMappingConfigurationFactory inverterMappingConfigurationFactory, InfoDataManagerService infoDataManagerService, InverterCloudController inverterCloudController) {
        this.infoDataManagerService = infoDataManagerService;
        this.inverter = null;
        this.inverterMappingConfigurationFactory = inverterMappingConfigurationFactory;
        this.inverterCloudController = inverterCloudController;
    }

    public boolean startBatteryCharging() {
        if (this.inverter == null) {
            return false;
        }
        try {
            int gridChargeEnabledRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"grid_charge_enabled");
            int gridChargeToRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"charge_battery_to");
            int gridChargePeriodStartRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"charge_period_start");
            int gridChargePeriodEndRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"charge_period_end");
            if (gridChargeEnabledRegisterAddress == -1 || gridChargeToRegisterAddress == -1 || gridChargePeriodStartRegisterAddress == -1 || gridChargePeriodEndRegisterAddress == -1) {
                return false;
            }
            this.wakeUpInverter();
            this.inverterCloudController.unlockInverter(this.inverter);
            String CHARGE_ADDRESS = "1";
            String CHARGE_PERIOD_START_VALUE = "1";
            String CHARGE_PERIOD_END_VALUE = "5947";
            this.inverterCloudController.sendInverterSettings(gridChargeEnabledRegisterAddress, CHARGE_ADDRESS, true, this.inverter);
            this.inverterCloudController.sendInverterSettings(gridChargeToRegisterAddress, String.valueOf(this.inverter.getChargeLimit()), true, this.inverter);
            this.inverterCloudController.sendInverterSettings(gridChargePeriodStartRegisterAddress, CHARGE_PERIOD_START_VALUE, true, this.inverter);
            this.inverterCloudController.sendInverterSettings(gridChargePeriodEndRegisterAddress, CHARGE_PERIOD_END_VALUE, true, this.inverter);
            log.info("Started battery charging for inverter {}", (Object)this.inverter.getInverterName());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean startBatteryDischarging() {
        if (this.inverter == null) {
            return false;
        }
        try {
            String workmodeStr = this.infoDataManagerService.findByDataKey("inverter_workmode").getDataValue();
            if (workmodeStr != null) {
                try {
                    this.inverterWorkmodeWhenDischargingStarted = (int)Double.parseDouble(workmodeStr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid inverter_workmode value: " + workmodeStr, e);
                }
            } else {
                throw new IllegalStateException("inverter_workmode key not found in infoDataManagerService");
            }
            int workModeRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"work_mode");
            int manualModeSettingsRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"manual_mode_settings");
            if (workModeRegisterAddress == -1 || manualModeSettingsRegisterAddress == -1) {
                return false;
            }
            this.wakeUpInverter();
            String MANUAL_MODE = "3";
            String DISCHARGE = "2";
            this.inverterCloudController.sendInverterSettings(workModeRegisterAddress, MANUAL_MODE, true, this.inverter);
            this.inverterCloudController.sendInverterSettings(manualModeSettingsRegisterAddress, DISCHARGE, true, this.inverter);
            log.info("Started battery discharging for inverter {}", (Object)this.inverter.getInverterName());
            return true;
        }
        catch (Exception e) {
            log.info("Error starting battery discharging for inverter {}", (Object)this.inverter.getInverterName());
            return false;
        }
    }

    public boolean stopBatteryDischarging() {
        if (this.inverter == null) {
            return false;
        }
        try {
            int workModeRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"work_mode");
            int manualModeSettingsRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"manual_mode_settings");
            if (workModeRegisterAddress == -1 || manualModeSettingsRegisterAddress == -1) {
                return false;
            }
            this.wakeUpInverter();
            String STOP_CHARGE_DISCHARGE_VALUE = "3";
            this.inverterCloudController.sendInverterSettings(workModeRegisterAddress, String.valueOf(this.inverterWorkmodeWhenDischargingStarted), true, this.inverter);
            this.inverterCloudController.sendInverterSettings(manualModeSettingsRegisterAddress, STOP_CHARGE_DISCHARGE_VALUE, true, this.inverter);
            log.info("Stopped battery discharging for inverter {}", (Object)this.inverter.getInverterName());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setExportLimit(int limitWatts) {
        if (this.inverter == null) {
            return false;
        }
        try {
            int userExportLimitRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"user_export_limit");
            if (userExportLimitRegisterAddress == -1) {
                return false;
            }
            int finalLimitWatts = (int)((float)limitWatts * InverterMap.getModifierOrDefault((Map)this.inverterMap, (String)"user_export_limit"));
            log.info("Setting export limit to: {}", (Object)finalLimitWatts);
            this.wakeUpInverter();
            this.inverterCloudController.unlockInverter(this.inverter);
            if (!this.inverterCloudController.sendInverterSettings(userExportLimitRegisterAddress, String.valueOf(finalLimitWatts), true, this.inverter)) {
                log.error("Error setting export limit for inverter {}", (Object)this.inverter.getInverterName());
            } else {
                log.info("Export limit set to: {} for inverter {}", (Object)finalLimitWatts, (Object)this.inverter.getInverterName());
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean stopBatteryCharging() {
        if (this.inverter == null) {
            return false;
        }
        try {
            int gridChargeEnabledRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"grid_charge_enabled");
            int gridChargePeriodStartRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"charge_period_start");
            int gridChargePeriodEndRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"charge_period_end");
            if (gridChargeEnabledRegisterAddress == -1 || gridChargePeriodStartRegisterAddress == -1 || gridChargePeriodEndRegisterAddress == -1) {
                return false;
            }
            this.wakeUpInverter();
            this.inverterCloudController.sendInverterSettings(gridChargeEnabledRegisterAddress, "0", true, this.inverter);
            this.inverterCloudController.sendInverterSettings(gridChargePeriodStartRegisterAddress, "0", true, this.inverter);
            this.inverterCloudController.sendInverterSettings(gridChargePeriodEndRegisterAddress, "0", true, this.inverter);
            log.info("Stopped battery charging for inverter {}", (Object)this.inverter.getInverterName());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void wakeUpInverter() {
        if (this.inverter == null) {
            return;
        }
        try {
            int runmode = (int)Double.parseDouble(this.infoDataManagerService.getInfoDataForInverter(this.inverter, "solax_inverter_runmode").getDataValue());
            if (runmode != 9) {
                return;
            }
            int wakeUpRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"system_on");
            if (wakeUpRegisterAddress == -1) {
                return;
            }
            this.inverterCloudController.sendInverterSettings(wakeUpRegisterAddress, "1", true, this.inverter);
            log.info("Waking up inverter {}", (Object)this.inverter.getInverterName());
        }
        catch (Exception e) {
            log.error("Error waking up inverter: {}", (Object)e.getMessage());
        }
    }

    public void setInverter(Inverter inverter) {
        this.inverter = inverter;
        try {
            Map apiMapperString = this.inverterMappingConfigurationFactory.getInverterWriteConfig(inverter.getInverterSerialNumber(), Inverter.CommunicationType.LocalAPI).getInverterMap();
            this.inverterMap = new HashMap();
            for (Map.Entry entry : apiMapperString.entrySet()) {
                try {
                    String key = (String)entry.getKey();
                    InverterMap inverterMap = new InverterMap(Integer.parseInt((String)((ArrayList)entry.getValue()).get(0)), Float.parseFloat((String)((ArrayList)entry.getValue()).get(1)), (String)((ArrayList)entry.getValue()).get(2), (String)((ArrayList)entry.getValue()).get(3), Integer.parseInt((String)((ArrayList)entry.getValue()).get(4)));
                    this.inverterMap.put(key, inverterMap);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

