/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.smartinverterautomations;

import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.SmartInverterAutomation;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.smartinverterautomations.SmartInverterAutomationService;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ChargeAutomationManager {
    private static final Logger log = LoggerFactory.getLogger(ChargeAutomationManager.class);
    private final InfoDataManagerService infoDataManagerService;
    private final EventEntryManagerService eventEntryManagerService;
    private final int DISCHARGING_THRESHOLD = 10;
    private final int CHARGING_THRESHOLD = 5;

    @Autowired
    public ChargeAutomationManager(InfoDataManagerService infoDataManagerService, EventEntryManagerService eventEntryManagerService) {
        this.infoDataManagerService = infoDataManagerService;
        this.eventEntryManagerService = eventEntryManagerService;
    }

    public SmartInverterAutomationService.BatteryState getBatteryState(SmartInverterAutomation smartInverterAutomation, int currentBatteryPercentage, int chargeTo, int dischargeTo, SmartInverterAutomationService.InverterState inverterState) {
        SmartInverterAutomationService.BatteryState batteryState = inverterState.getBatteryState();
        SmartInverterAutomationService.BatteryState chargingState = SmartInverterAutomationService.BatteryState.NO_ACTION;
        SmartInverterAutomationService.BatteryState dischargingState = SmartInverterAutomationService.BatteryState.NO_ACTION;
        if (smartInverterAutomation.isChargeEnabled()) {
            chargingState = this.handleCharging(smartInverterAutomation, currentBatteryPercentage, chargeTo, batteryState);
        }
        if (smartInverterAutomation.isForceDischargeEnabled()) {
            dischargingState = this.handleDischarging(smartInverterAutomation, currentBatteryPercentage, dischargeTo, batteryState);
        }
        if (chargingState == SmartInverterAutomationService.BatteryState.CHARGE) {
            return SmartInverterAutomationService.BatteryState.CHARGE;
        }
        if (dischargingState == SmartInverterAutomationService.BatteryState.DISCHARGE) {
            return SmartInverterAutomationService.BatteryState.DISCHARGE;
        }
        return SmartInverterAutomationService.BatteryState.NO_ACTION;
    }

    private SmartInverterAutomationService.BatteryState handleCharging(SmartInverterAutomation smartInverterAutomation, int currentBatteryPercentage, int chargeTo, SmartInverterAutomationService.BatteryState batteryState) {
        try {
            if (!this.isWithinTimeRange(smartInverterAutomation.getChargeStartTime(), smartInverterAutomation.getChargeEndTime())) {
                return SmartInverterAutomationService.BatteryState.NO_ACTION;
            }
            if (batteryState == SmartInverterAutomationService.BatteryState.CHARGE ? currentBatteryPercentage >= chargeTo : currentBatteryPercentage >= chargeTo - 5) {
                return SmartInverterAutomationService.BatteryState.NO_ACTION;
            }
            LocalDateTime chargeStartTime = this.getCheapestHoursFromInfoData(smartInverterAutomation.getChargeXHours(), smartInverterAutomation.getChargeStartTime(), smartInverterAutomation.getChargeEndTime(), smartInverterAutomation.getChargeLimitPrice());
            if (chargeStartTime == null) {
                log.info("SMART INVERTER AUTOMATION: No charge start time found, returning NO_ACTION");
                this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: No charge start time found for automation: " + smartInverterAutomation.getAutomationName(), EventEntry.EventType.INFO);
                return SmartInverterAutomationService.BatteryState.NO_ACTION;
            }
            LocalDateTime now = LocalDateTime.now();
            if (now.isAfter(chargeStartTime) && now.isBefore(chargeStartTime.plusHours(smartInverterAutomation.getChargeXHours()))) {
                return SmartInverterAutomationService.BatteryState.CHARGE;
            }
        }
        catch (Exception e) {
            log.error("SMART INVERTER AUTOMATION: {} - Error while handling battery state", (Object)smartInverterAutomation.getAutomationName(), (Object)e);
        }
        return SmartInverterAutomationService.BatteryState.NO_ACTION;
    }

    private SmartInverterAutomationService.BatteryState handleDischarging(SmartInverterAutomation smartInverterAutomation, int currentBatteryPercentage, int dischargeTo, SmartInverterAutomationService.BatteryState batteryState) {
        try {
            if (!this.isWithinTimeRange(smartInverterAutomation.getForceDischargeStartTime(), smartInverterAutomation.getForceDischargeEndTime())) {
                return SmartInverterAutomationService.BatteryState.NO_ACTION;
            }
            if (batteryState == SmartInverterAutomationService.BatteryState.DISCHARGE ? currentBatteryPercentage <= dischargeTo : currentBatteryPercentage <= dischargeTo + 10) {
                return SmartInverterAutomationService.BatteryState.NO_ACTION;
            }
            LocalDateTime dischargeStartTime = this.getHighestHoursFromInfoData(smartInverterAutomation.getDischargeXHours(), smartInverterAutomation.getForceDischargeStartTime(), smartInverterAutomation.getForceDischargeEndTime(), smartInverterAutomation.getForceDischargePrice());
            if (dischargeStartTime == null) {
                log.info("SMART INVERTER AUTOMATION: No discharge start time found, returning NO_ACTION");
                this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: No discharge start time found for automation: " + smartInverterAutomation.getAutomationName(), EventEntry.EventType.INFO);
                return SmartInverterAutomationService.BatteryState.NO_ACTION;
            }
            LocalDateTime now = LocalDateTime.now();
            if (now.isAfter(dischargeStartTime) && now.isBefore(dischargeStartTime.plusHours(smartInverterAutomation.getDischargeXHours()))) {
                return SmartInverterAutomationService.BatteryState.DISCHARGE;
            }
        }
        catch (Exception e) {
            log.error("SMART INVERTER AUTOMATION: {} - Error while handling battery state", (Object)smartInverterAutomation.getAutomationName(), (Object)e);
        }
        return SmartInverterAutomationService.BatteryState.NO_ACTION;
    }

    private boolean isWithinTimeRange(LocalTime startTime, LocalTime endTime) {
        LocalTime now = LocalTime.now();
        return !now.isBefore(startTime) && !now.isAfter(endTime);
    }

    private LocalDateTime getConsecutiveHoursFromInfoData(int hours, LocalTime startTime, int endHour, float threshold, boolean findMax) {
        if (LocalTime.now().isBefore(startTime)) {
            return null;
        }
        Set pricesToday = this.infoDataManagerService.findByPrefix("energy_spot_price_today_local_");
        int startHourIndex = startTime.getHour() + 1;
        HashMap<CallSite, Float> allPrices = new HashMap<CallSite, Float>();
        for (int i = startHourIndex; i <= endHour; ++i) {
            log.info("SMART INVERTER AUTOMATION: Adding price for hour {}", (Object)i);
            String key = "energy_spot_price_today_local_" + i + "_hour";
            allPrices.put((CallSite)((Object)key), Float.valueOf(Float.parseFloat(this.infoDataManagerService.findByDataKey(key).getDataValue())));
        }
        log.info("SMART INVERTER AUTOMATION: All prices for the specified time range: {}", allPrices);
        List bestHours = ChargeAutomationManager.findConsecutiveHours(allPrices, (int)hours, (double)threshold, (boolean)findMax);
        if (findMax) {
            log.info("SMART INVERTER AUTOMATION: Highest hours: {}", (Object)bestHours);
        } else {
            log.info("SMART INVERTER AUTOMATION: Cheapest hours: {}", (Object)bestHours);
        }
        if (!bestHours.isEmpty()) {
            return LocalDateTime.now().withHour((Integer)bestHours.get(0) - 1).withMinute(0).withSecond(0).withNano(0);
        }
        return null;
    }

    private LocalDateTime getCheapestHoursFromInfoData(int hours, LocalTime startTime, LocalTime endTime, float maxPrice) {
        return this.getConsecutiveHoursFromInfoData(hours, startTime, endTime.getHour(), maxPrice, false);
    }

    private LocalDateTime getHighestHoursFromInfoData(int hours, LocalTime startTime, LocalTime forceDischargeEndTime, float minPrice) {
        return this.getConsecutiveHoursFromInfoData(hours, startTime, forceDischargeEndTime.getHour(), minPrice, true);
    }

    private static List<Integer> findConsecutiveHours(Map<String, Float> priceMap, int x, double threshold, boolean findMax) {
        ArrayList<Map.Entry> hourPrices = new ArrayList<Map.Entry>();
        Pattern pattern = Pattern.compile(".*_(\\d+)_hour");
        if (priceMap.size() < x) {
            x = priceMap.size();
        }
        for (Map.Entry<String, Float> entry : priceMap.entrySet()) {
            Matcher matcher = pattern.matcher(entry.getKey());
            if (!matcher.matches()) continue;
            int hour = Integer.parseInt(matcher.group(1));
            hourPrices.add(new AbstractMap.SimpleEntry<Integer, Float>(hour, entry.getValue()));
        }
        hourPrices.sort(Comparator.comparingInt(Map.Entry::getKey));
        double bestAverage = findMax ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        ArrayList<Integer> bestWindow = new ArrayList<Integer>();
        for (int i = 0; i <= hourPrices.size() - x; ++i) {
            boolean isConsecutive = true;
            double sum = 0.0;
            int startHour = (Integer)((Map.Entry)hourPrices.get(i)).getKey();
            ArrayList<Integer> currentWindow = new ArrayList<Integer>();
            for (int j = 0; j < x; ++j) {
                Map.Entry entry = (Map.Entry)hourPrices.get(i + j);
                int currentHour = (Integer)entry.getKey();
                if (currentHour != startHour + j) {
                    isConsecutive = false;
                    break;
                }
                sum += (double)((Float)entry.getValue()).floatValue();
                currentWindow.add(currentHour);
            }
            if (!isConsecutive) continue;
            double average = sum / (double)x;
            if (findMax && average > bestAverage) {
                bestAverage = average;
                bestWindow = currentWindow;
                continue;
            }
            if (findMax || !(average < bestAverage)) continue;
            bestAverage = average;
            bestWindow = currentWindow;
        }
        if (findMax && bestAverage < threshold || !findMax && bestAverage > threshold) {
            return new ArrayList<Integer>();
        }
        return bestWindow;
    }
}

