/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.modbus;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.io.ModbusRTUTransport;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransaction;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersResponse;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersResponse;
import com.ghgande.j2mod.modbus.msg.WriteMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.msg.WriteSingleRegisterRequest;
import com.ghgande.j2mod.modbus.net.SerialConnection;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import com.ghgande.j2mod.modbus.util.SerialParameters;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.domain.inverter.ModbusRTUDetails;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.modbus.ModbusServiceInterface;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Lazy
@Service
@Scope(value="prototype")
public class ModbusRTUService
implements ModbusServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(ModbusRTUService.class);
    private static final int REGISTERS_TO_READ = 700;
    private static final int HOLDING_REGISTERS_LIMIT = 200;
    private static final int REGISTERS_PER_REQUEST = 100;
    private static final int MODBUS_TIMEOUT = 1500;
    private static final int RETRY_DELAY_MS = 5000;
    private static final int SLEEP_BETWEEN_READS_MS = 100;
    private Inverter inverter;
    private SerialConnection serialConnection;
    private final EventEntryManagerService eventEntryManagerService;
    private ModbusRTUDetails modbusRTUDetails;

    @Autowired
    public ModbusRTUService(EventEntryManagerService eventEntryManagerService) {
        this.eventEntryManagerService = eventEntryManagerService;
    }

    public void initializeModbusService() {
        try {
            this.modbusRTUDetails = (ModbusRTUDetails)this.inverter.getConnectionDetails();
            String portName = this.modbusRTUDetails.getDevicePath();
            int baudRate = this.modbusRTUDetails.getBaudRate();
            int dataBits = this.modbusRTUDetails.getDataBits();
            String parity = this.modbusRTUDetails.getParity();
            int stopBits = this.modbusRTUDetails.getStopBits();
            String encoding = this.modbusRTUDetails.getEncoding();
            log.info("Opening modbus connection on port: {} at {} baud", (Object)portName, (Object)baudRate);
            if (this.serialConnection != null && this.serialConnection.isOpen()) {
                this.serialConnection.close();
            }
            this.serialConnection = this.openConnection(portName, baudRate, dataBits, parity, stopBits, encoding);
        }
        catch (Exception e) {
            log.error("Error initializing modbus service: {}", (Object)e.getMessage());
            this.eventEntryManagerService.raiseEvent("MODBUS: Error initializing modbus service - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
        }
    }

    public SerialConnection openConnection(String portName, int baudRate, int dataBits, String parity, int stopBits, String encoding) {
        SerialParameters params = new SerialParameters();
        params.setPortName(portName);
        params.setBaudRate(baudRate);
        params.setDatabits(dataBits);
        params.setParity(parity);
        params.setStopbits(stopBits);
        params.setEncoding(encoding);
        params.setEcho(false);
        SerialConnection connection = new SerialConnection(params);
        try {
            connection.open();
        }
        catch (Exception e) {
            log.error("Error opening modbus connection: {}", (Object)e.getMessage());
            this.eventEntryManagerService.raiseEvent("MODBUS: Issue with modbus connection - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
        }
        return connection;
    }

    public ModbusSerialTransaction createModbusTransaction(SerialConnection connection, int timeout) {
        ModbusRTUTransport transport = (ModbusRTUTransport)connection.getModbusTransport();
        transport.setTimeout(timeout);
        ModbusSerialTransaction transaction = new ModbusSerialTransaction();
        transaction.setTransport((ModbusSerialTransport)transport);
        return transaction;
    }

    public synchronized ArrayList<Integer> readAllInputRegisters() {
        ArrayList<Integer> registerValues = new ArrayList<Integer>();
        for (int currentAddress = 0; currentAddress <= 700; currentAddress += 100) {
            try {
                ModbusSerialTransaction transaction = this.createModbusTransaction(this.serialConnection, 1500);
                ReadInputRegistersRequest request = new ReadInputRegistersRequest(currentAddress, 100);
                request.setUnitID(1);
                transaction.setRequest((ModbusRequest)request);
                transaction.execute();
                ReadInputRegistersResponse response = (ReadInputRegistersResponse)transaction.getResponse();
                for (int i = 0; i < 100; ++i) {
                    registerValues.add(response.getRegisterValue(i));
                }
                Thread.sleep(100L);
                continue;
            }
            catch (Exception e) {
                log.error("Exception during readAllInputRegisters at address {}: {}", (Object)currentAddress, (Object)e.getMessage());
                this.eventEntryManagerService.raiseEvent("MODBUS: Error reading input registers - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
                break;
            }
        }
        return registerValues;
    }

    public synchronized ArrayList<Integer> readAllHoldingRegisters() {
        ArrayList<Integer> registerValues = new ArrayList<Integer>();
        for (int currentAddress = 0; currentAddress <= 200; currentAddress += 100) {
            try {
                ModbusSerialTransaction transaction = this.createModbusTransaction(this.serialConnection, 1500);
                ReadMultipleRegistersRequest request = new ReadMultipleRegistersRequest(currentAddress, 100);
                request.setUnitID(1);
                transaction.setRequest((ModbusRequest)request);
                transaction.execute();
                ReadMultipleRegistersResponse response = (ReadMultipleRegistersResponse)transaction.getResponse();
                for (int i = 0; i < 100; ++i) {
                    registerValues.add(response.getRegisterValue(i));
                }
                Thread.sleep(100L);
                continue;
            }
            catch (Exception e) {
                log.error("Exception during readAllHoldingRegisters at address {}: {}", (Object)currentAddress, (Object)e.getMessage());
                this.eventEntryManagerService.raiseEvent("MODBUS: Error reading holding registers - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
                break;
            }
        }
        return registerValues;
    }

    public synchronized boolean writeSingleRegister(int registerAddress, int registerValue, boolean testMode, int maxRetries) {
        this.eventEntryManagerService.raiseEvent("WRITE REGISTER: Writing single register: " + registerAddress + " with value: " + registerValue, EventEntry.EventType.INFO, 0);
        if (testMode) {
            this.eventEntryManagerService.raiseEvent("WRITE REGISTER: Test mode, not writing register", EventEntry.EventType.WARNING, 0);
            return true;
        }
        try {
            ModbusSerialTransaction transaction = this.createModbusTransaction(this.serialConnection, 1500);
            WriteSingleRegisterRequest request = new WriteSingleRegisterRequest(registerAddress, (Register)new SimpleRegister(registerValue));
            request.setUnitID(1);
            request.setHeadless();
            transaction.setRequest((ModbusRequest)request);
            return this.executeWithRetry(transaction, maxRetries, "single register");
        }
        catch (Exception e) {
            log.error("Exception in writeSingleRegister: {}", (Object)e.getMessage());
            this.eventEntryManagerService.raiseEvent("WRITE REGISTER: Exception while writing register: " + e.getMessage(), EventEntry.EventType.WARNING, 0);
            return false;
        }
    }

    public synchronized boolean writeMultipleRegisters(int registerAddress, int[] registerValues, boolean testMode, int maxRetries) {
        this.eventEntryManagerService.raiseEvent("WRITE REGISTER: Writing multiple registers at address: " + registerAddress + " with values: " + Arrays.toString(registerValues), EventEntry.EventType.INFO, 0);
        if (testMode) {
            this.eventEntryManagerService.raiseEvent("WRITE REGISTER: Test mode, not writing register", EventEntry.EventType.WARNING, 0);
            return true;
        }
        try {
            ModbusSerialTransaction transaction = this.createModbusTransaction(this.serialConnection, 1500);
            Register[] registers = new Register[registerValues.length];
            for (int i = 0; i < registerValues.length; ++i) {
                registers[i] = new SimpleRegister(registerValues[i]);
            }
            WriteMultipleRegistersRequest request = new WriteMultipleRegistersRequest(registerAddress, registers);
            request.setUnitID(1);
            request.setHeadless();
            transaction.setRequest((ModbusRequest)request);
            return this.executeWithRetry(transaction, maxRetries, "multiple registers");
        }
        catch (Exception e) {
            log.error("Exception in writeMultipleRegisters: {}", (Object)e.getMessage());
            this.eventEntryManagerService.raiseEvent("WRITE REGISTER: Exception while writing registers: " + e.getMessage(), EventEntry.EventType.WARNING, 0);
            return false;
        }
    }

    private boolean executeWithRetry(ModbusSerialTransaction transaction, int maxRetries, String operation) throws InterruptedException {
        for (int retries = 0; retries <= maxRetries; ++retries) {
            try {
                transaction.execute();
                this.eventEntryManagerService.raiseEvent("RTU MODBUS WRITE: " + operation + " write succeeded after " + (retries + 1) + " attempt(s).", EventEntry.EventType.SUCCESS, 60);
                return true;
            }
            catch (ModbusException e) {
                log.error("Error during write {}: {}. Attempt {}/{}", new Object[]{operation, e.getMessage(), retries + 1, maxRetries + 1});
                this.eventEntryManagerService.raiseEvent("MODBUS: Error when writing " + operation + " - " + e.getMessage() + ". Retrying...", EventEntry.EventType.ERROR, 60);
                Thread.sleep(5000L);
                continue;
            }
        }
        this.eventEntryManagerService.raiseEvent("RTU MODBUS WRITE: " + operation + " write failed after " + (maxRetries + 1) + " attempts.", EventEntry.EventType.ERROR, 60);
        return false;
    }

    public void setInverter(Inverter inverter) {
        this.inverter = inverter;
    }
}

