/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.otherinfocollectors;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.services.SunnyConfigurationService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class NewsReadCollector {
    private final SunnyConfigurationService sunnyConfigurationService;
    private final RestTemplate restTemplate;
    private final String latestNewsTimestampUrl;

    public NewsReadCollector(SunnyConfigurationService sunnyConfigurationService, RestTemplate restTemplate, @Value(value="${sunnyhomeonline.url}") String sunnyHomeOnlineUrl) {
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.restTemplate = restTemplate;
        this.latestNewsTimestampUrl = sunnyHomeOnlineUrl + "/news/news/latest/timestamp";
    }

    @Scheduled(fixedDelay=3600000L)
    public void allNewsRead() {
        NicePrinter.nicePrint((String)"SUNNYHOME NEWSREAD GETTER: Fetching last read time from configuration", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        String lastReadTimeStr = this.sunnyConfigurationService.getSetting("last_read_time");
        if (lastReadTimeStr == null || lastReadTimeStr.isEmpty()) {
            lastReadTimeStr = "2024-02-26T20:07:59";
        }
        NicePrinter.nicePrint((String)("SUNNYHOME NEWSREAD GETTER: Last read time: " + lastReadTimeStr), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        try {
            LocalDateTime lastReadTime = LocalDateTime.parse(lastReadTimeStr, DateTimeFormatter.ISO_DATE_TIME);
            String token = this.sunnyConfigurationService.getSetting("sunnyhome_click_token");
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(List.of(MediaType.APPLICATION_JSON));
            if (token != null && !token.isBlank()) {
                headers.setBearerAuth(token);
            }
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(this.latestNewsTimestampUrl, HttpMethod.GET, entity, String.class, new Object[0]);
            ObjectMapper objectMapper = new ObjectMapper();
            Map responseMap = (Map)objectMapper.readValue((String)response.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            String latestTimestampStr = (String)responseMap.get("latest_timestamp");
            NicePrinter.nicePrint((String)("SUNNYHOME NEWSREAD GETTER: Latest news added time from sunnyhome.click: " + latestTimestampStr), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            LocalDateTime latestNewsTime = LocalDateTime.parse(latestTimestampStr, DateTimeFormatter.ISO_DATE_TIME);
            if (latestNewsTime.isAfter(lastReadTime)) {
                NicePrinter.nicePrint((String)"SUNNYHOME NEWSREAD GETTER: News read flag set to false", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                this.sunnyConfigurationService.saveSetting("news_read", "False");
            } else {
                NicePrinter.nicePrint((String)"SUNNYHOME NEWSREAD GETTER: News read flag set to true", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                this.sunnyConfigurationService.saveSetting("news_read", "True");
            }
        }
        catch (Exception e) {
            NicePrinter.nicePrint((String)("SUNNYHOME NEWSREAD GETTER: Error while getting last news added time from sunnyhome.click: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
    }
}

