/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.otherinfocollectors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DataCollectorWeatherForecast
extends DataCollectorAbstractService {
    private static final Logger log = LoggerFactory.getLogger(DataCollectorWeatherForecast.class);
    private final RestTemplate restTemplate;
    private final SunnyConfigurationService sunnyConfigurationService;
    private static final String API_URL = "https://api.openweathermap.org/data/3.0/onecall?lat=%f&lon=%f&appid=%s&units=metric";

    @Autowired
    public DataCollectorWeatherForecast(InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService, RestTemplateBuilder restTemplateBuilder) {
        super(infoDataManagerService);
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.restTemplate = restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(15L)).setReadTimeout(Duration.ofSeconds(15L)).build();
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        try {
            float lat = this.sunnyConfigurationService.GetConfiguration().getLatitude();
            float lon = this.sunnyConfigurationService.GetConfiguration().getLongitude();
            String apiKeyOpenWeather = this.sunnyConfigurationService.GetConfiguration().getOpenWeatherApiKey();
            String url = String.format(API_URL, Float.valueOf(lat), Float.valueOf(lon), apiKeyOpenWeather);
            String response = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
            NicePrinter.nicePrint((String)response, (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(response);
            JsonNode hourlyData = rootNode.path("hourly");
            if (hourlyData.isArray()) {
                int i;
                int totalHours = Math.min(hourlyData.size(), 48);
                int[] cloudValues = new int[totalHours];
                float[] tempValues = new float[totalHours];
                for (i = 0; i < totalHours; ++i) {
                    float temp;
                    int cloudiness;
                    JsonNode hourEntry = hourlyData.get(i);
                    cloudValues[i] = cloudiness = hourEntry.path("clouds").asInt(0);
                    String cloudKey = "weather_clouds_hour_" + (i + 1);
                    InfoData cloudInfo = new InfoData(cloudKey, String.valueOf(cloudiness), "%", 3900);
                    super.getInfoDataManagerService().save(cloudInfo, false);
                    tempValues[i] = temp = (float)hourEntry.path("temp").asDouble(0.0);
                    String tempKey = "weather_temp_hour_" + (i + 1);
                    InfoData tempInfo = new InfoData(tempKey, String.format(Locale.US, "%.1f", Float.valueOf(temp)), "\u00b0C", 3900);
                    super.getInfoDataManagerService().save(tempInfo, false);
                }
                for (i = 0; i < totalHours; i += 3) {
                    int endIndex = Math.min(i + 3, totalHours);
                    int cloudSum = 0;
                    for (int j = i; j < endIndex; ++j) {
                        cloudSum += cloudValues[j];
                    }
                    int cloudAvg = Math.round((float)cloudSum / (float)(endIndex - i));
                    String cloudAvgKey = String.format("weather_clouds_hour_%d_%d", i + 1, endIndex);
                    InfoData cloudAvgInfo = new InfoData(cloudAvgKey, String.valueOf(cloudAvg), "%", 3900);
                    super.getInfoDataManagerService().save(cloudAvgInfo, false);
                    float tempSum = 0.0f;
                    for (int j = i; j < endIndex; ++j) {
                        tempSum += tempValues[j];
                    }
                    float tempAvg = tempSum / (float)(endIndex - i);
                    String tempAvgKey = String.format("weather_temp_hour_%d_%d", i + 1, endIndex);
                    InfoData tempAvgInfo = new InfoData(tempAvgKey, String.format(Locale.US, "%.1f", Float.valueOf(tempAvg)), "\u00b0C", 3900);
                    super.getInfoDataManagerService().save(tempAvgInfo, false);
                }
                log.info("Successfully saved cloudiness and temperature data for 48 hours and 3-hour averages.");
            }
        }
        catch (Exception e) {
            log.error("Error while collecting data from OpenWeather API: {}", (Object)e.getMessage());
            NicePrinter.nicePrint((String)("Error while collecting data: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
        return new HashMap<String, Map.Entry<String, String>>();
    }
}

