/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.deviceCollectors;

import cz.snyll.sunny.config.ShellyConfiguration;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataCollectorShellyHTPlus
extends DataCollectorAbstractService {
    private static final Logger log = LoggerFactory.getLogger(DataCollectorShellyHTPlus.class);
    private EventEntryManagerService eventEntryManagerService;
    private String temperature;
    private String humidity;
    private String shellyHtId;

    @Autowired
    public DataCollectorShellyHTPlus(InfoDataManagerService infoDataManagerService, ShellyConfiguration shellyConfiguration, EventEntryManagerService eventEntryManagerService) {
        super(infoDataManagerService);
        this.eventEntryManagerService = eventEntryManagerService;
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        if (this.temperature == null && this.humidity == null) {
            return new HashMap<String, Map.Entry<String, String>>();
        }
        if (this.temperature != null && !this.temperature.isEmpty()) {
            this.saveinfodata(new InfoData("shellyhtplus_temperature_" + this.shellyHtId, this.temperature, "\u00b0C", 540000));
        }
        if (this.humidity != null && !this.humidity.isEmpty()) {
            this.saveinfodata(new InfoData("shellyhtplus_humidity_" + this.shellyHtId, this.humidity, "%", 540000));
        }
        this.eventEntryManagerService.raiseEvent("ShellyHT: Shelly HT device with id " + this.shellyHtId + " reported values: temperature - " + this.temperature + "; humidity - " + this.humidity, EventEntry.EventType.INFO);
        this.resetData();
        return new HashMap<String, Map.Entry<String, String>>();
    }

    public void resetData() {
        this.temperature = null;
        this.humidity = null;
        this.shellyHtId = null;
    }

    public void ReceiveGetParameters(Map<String, String[]> parameterMap) {
        for (Map.Entry<String, String[]> mapElement : parameterMap.entrySet()) {
            String[] values;
            String getKey = mapElement.getKey();
            if (!getKey.equals("id") || !(values = mapElement.getValue())[0].startsWith("shellyht")) continue;
            if (parameterMap.get("temp") != null) {
                this.setTemperature(parameterMap.get("temp")[0]);
            }
            if (parameterMap.get("hum") != null) {
                this.setHumidity(parameterMap.get("hum")[0]);
            }
            this.setShellyHtId(values[0].toLowerCase());
            this.collectData();
            break;
        }
    }

    public void setEventEntryManagerService(EventEntryManagerService eventEntryManagerService) {
        this.eventEntryManagerService = eventEntryManagerService;
    }

    public void setTemperature(String temperature) {
        this.temperature = temperature;
    }

    public void setHumidity(String humidity) {
        this.humidity = humidity;
    }

    public void setShellyHtId(String shellyHtId) {
        this.shellyHtId = shellyHtId;
    }
}

