/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors;

import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.repositories.InverterRepository;
import cz.snyll.sunny.services.InverterCollectorAbstractService;
import cz.snyll.sunny.services.InverterManagerService;
import cz.snyll.sunny.services.collectors.collectorfactories.InverterCollectorFactory;
import cz.snyll.sunny.services.datasenders.SunnyHomeOnlineDataSender;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class InverterCollectorsManagerService {
    private final InverterRepository inverterRepository;
    private final InverterCollectorFactory collectorFactory;
    private final ExecutorService executorService;
    private final ReentrantLock lock = new ReentrantLock();
    private final SunnyHomeOnlineDataSender sunnyHomeOnlineDataSender;
    private final InverterManagerService inverterManagerService;
    private List<Future<Boolean>> previousFutures = new ArrayList();

    @Autowired
    public InverterCollectorsManagerService(InverterRepository inverterRepository, InverterCollectorFactory collectorFactory, SunnyHomeOnlineDataSender sunnyHomeOnlineDataSender, InverterManagerService inverterManagerService) {
        this.inverterRepository = inverterRepository;
        this.collectorFactory = collectorFactory;
        this.sunnyHomeOnlineDataSender = sunnyHomeOnlineDataSender;
        this.inverterManagerService = inverterManagerService;
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRate=5000L)
    public void collectDataForAllInverters() {
        if (this.lock.tryLock()) {
            try {
                for (Future future : this.previousFutures) {
                    try {
                        if (future.isDone()) continue;
                        future.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.previousFutures.clear();
                List inverters = (List)this.inverterRepository.findAll();
                ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
                for (Inverter inverter : inverters) {
                    if (!inverter.getActive().booleanValue()) continue;
                    Callable<Boolean> callable = () -> {
                        try {
                            long pause = ThreadLocalRandom.current().nextLong(500L, 2001L);
                            Thread.sleep(pause);
                            InverterCollectorAbstractService collector = this.collectorFactory.getInverterCollector(inverter);
                            collector.collectData();
                            return true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return false;
                        }
                    };
                    futures.add(this.executorService.submit(callable));
                }
                this.previousFutures = futures;
                boolean allSuccess = true;
                for (Future future : futures) {
                    try {
                        if (((Boolean)future.get()).booleanValue()) continue;
                        allSuccess = false;
                    }
                    catch (Exception e) {
                        allSuccess = false;
                        e.printStackTrace();
                    }
                }
                if (allSuccess) {
                    this.inverterManagerService.concatenateInvertersData();
                    this.sunnyHomeOnlineDataSender.SendSunnyHomeData();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void updateInverterConfiguration(Inverter inverter) {
        this.collectorFactory.updateCollectorCache(inverter);
    }

    public void shutdown() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
        }
    }
}

