/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.EVCollectors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.invertermaps.InverterMappingConfigurationFactory;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SolaxWallboxCollector
extends DataCollectorAbstractService {
    private final EventEntryManagerService eventEntryManagerService;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final InverterMappingConfigurationFactory inverterMappingConfigurationFactory;
    private final RestTemplate restTemplate;

    @Autowired
    public SolaxWallboxCollector(InfoDataManagerService infoDataManagerService, InverterMappingConfigurationFactory inverterMappingConfigurationFactory, SunnyConfigurationService sunnyConfigurationService, EventEntryManagerService eventEntryManagerService) {
        super(infoDataManagerService);
        this.inverterMappingConfigurationFactory = inverterMappingConfigurationFactory;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.eventEntryManagerService = eventEntryManagerService;
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(5000);
        clientHttpRequestFactory.setReadTimeout(5000);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
    }

    @Scheduled(fixedDelay=5000L)
    public void scheduledCollection() {
        this.collectData();
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        String localIp = this.sunnyConfigurationService.getSetting("wallbox_ip_address");
        String localPassword = this.sunnyConfigurationService.getSetting("wallbox_password");
        if (localIp == null || localPassword == null || localIp.isEmpty() || localPassword.isEmpty()) {
            return new HashMap<String, Map.Entry<String, String>>();
        }
        NicePrinter.nicePrint((String)"Collecting data from Solax Wallbox", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        HashMap<String, Map.Entry<String, String>> dataMap = new HashMap<String, Map.Entry<String, String>>();
        try {
            String response = this.CallSolaxWallbox(localIp, localPassword);
            if (response == null || response.isEmpty()) {
                return new HashMap<String, Map.Entry<String, String>>();
            }
            ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
            JsonNode jsonResponseWhole = mapper.readTree(response);
            JsonNode informationNode = jsonResponseWhole.get("Information");
            String wallboxSN = "";
            if (informationNode.isArray()) {
                wallboxSN = jsonResponseWhole.get("type").isTextual() ? informationNode.get(3).textValue() : informationNode.get(2).textValue();
                dataMap.put("solax_wallbox_serial_number", new AbstractMap.SimpleEntry<String, String>(wallboxSN, ""));
                String armVersion = informationNode.get(5).asText();
                dataMap.put("solax_wallbox_arm_version", new AbstractMap.SimpleEntry<String, String>(armVersion, ""));
                String dspVersion = informationNode.get(4).asText();
                dataMap.put("solax_wallbox_dsp_version", new AbstractMap.SimpleEntry<String, String>(dspVersion, ""));
            }
            Map apiMapperString = this.inverterMappingConfigurationFactory.getInverterConfig(wallboxSN, Inverter.CommunicationType.LocalAPI).getInverterMap();
            HashMap apiMapper = this.getFinalMap(apiMapperString);
            JsonNode jsonResponseData = jsonResponseWhole.get("Data");
            try {
                if (jsonResponseData.isArray()) {
                    dataMap.putAll(this.parseValues(jsonResponseData, apiMapper));
                }
            }
            catch (Exception e) {
                NicePrinter.nicePrint((String)("Issue while parsing the data from the Wallbox. Error: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                this.eventEntryManagerService.raiseEvent("SOLAX: Solax Wallbox data parsing threw en exception: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            }
            this.saveinfodata(dataMap);
            return dataMap;
        }
        catch (Exception e) {
            NicePrinter.nicePrint((String)("Issue while connecting to the Wallbox. Error: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            this.eventEntryManagerService.raiseEvent("SOLAX: Solax Wallbox request threw en exception: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            return new HashMap<String, Map.Entry<String, String>>();
        }
    }

    public String CallSolaxWallbox(String ip, String password) {
        try {
            HttpEntity entity = SolaxWallboxCollector.getMultiValueMapHttpEntity((String)password);
            ResponseEntity response = this.restTemplate.exchange("http://" + ip + "/", HttpMethod.POST, entity, String.class, new Object[0]);
            return (String)response.getBody();
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("Solax wallbox did not return any data: " + e.getMessage(), EventEntry.EventType.ERROR);
            NicePrinter.nicePrint((String)("Solax wallbox did not return any data: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return "";
        }
    }

    @NotNull
    private static HttpEntity<MultiValueMap<String, String>> getMultiValueMapHttpEntity(String password) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("'X-Forwarded-For'", "'5.8.8.8'");
        LinkedMultiValueMap postData = new LinkedMultiValueMap();
        postData.add((Object)"optType", (Object)"ReadRealTimeData");
        postData.add((Object)"pwd", (Object)password);
        HttpEntity entity = new HttpEntity((Object)postData, (MultiValueMap)headers);
        return entity;
    }
}

