/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors;

import com.fasterxml.jackson.databind.ObjectMapper;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import cz.snyll.sunny.services.collectors.DataCollectorSpotSavings;
import jakarta.annotation.PostConstruct;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class DataCollectorSpotEarnings
extends DataCollectorAbstractService {
    private ObjectMapper objectMapper;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final EventEntryManagerService eventEntryManagerService;

    @Autowired
    public DataCollectorSpotEarnings(InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService, EventEntryManagerService eventEntryManagerService) {
        super(infoDataManagerService);
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.eventEntryManagerService = eventEntryManagerService;
    }

    @PostConstruct
    public void CollectDataAtStartup() {
        this.collectData();
    }

    @Scheduled(cron="00 59 * * * *")
    public HashMap<String, Map.Entry<String, String>> collectData() {
        try {
            String formattedDate = DataCollectorSpotSavings.getToday();
            if (this.sunnyConfigurationService.getSetting("spot_prices") != null && this.sunnyConfigurationService.getSetting("spot_prices").equals("true")) {
                float spotPriceSellExtra = Optional.ofNullable(this.sunnyConfigurationService.getSetting("spot_price_sell_extra")).map(value -> {
                    try {
                        return Float.valueOf(Float.parseFloat(value));
                    }
                    catch (NumberFormatException e) {
                        return Float.valueOf(0.0f);
                    }
                }).orElse(Float.valueOf(0.0f)).floatValue();
                HashMap<String, Map.Entry<String, String>> dataMap = new HashMap<String, Map.Entry<String, String>>();
                InfoData eurToCzkInfoData = this.getInfoDataManagerService().findByDataKey("euro_to_czk");
                InfoData lastHourOtePriceInfoData = this.getInfoDataManagerService().findByDataKey("ote_price_current_hour");
                InfoData lastHourTotalFeedinInfoData = this.getInfoDataManagerService().findByDataKey("last_hour_total_feedin");
                InfoData totalFeedinInfoData = this.getInfoDataManagerService().findByDataKey("solax_total_feedin_energy");
                InfoData spotEarningsTodayInfoData = this.getInfoDataManagerService().findByDataKey("spot_earnings_today");
                InfoData spotEarningsTodayLocalCurrencyInfoData = this.getInfoDataManagerService().findByDataKey("spot_earnings_today_local_currency");
                InfoData spotEarningsTodayCsResetDateInfoData = this.getInfoDataManagerService().findByDataKey("spot_earnings_today_cs_reset_date");
                float eurToCzk = 0.0f;
                float lastHourTotalFeedin = 0.0f;
                float totalFeedin = 0.0f;
                float lastHourFeedinValue = 0.0f;
                float spotEarningsTodayValue = 0.0f;
                float spotEarningTodayLocalCurrencyValue = 0.0f;
                float spotEarningsTodayFinalLocalCurrency = 0.0f;
                float spotEarningsTodayFinal = 0.0f;
                float lastHourOtePrice = 0.0f;
                String resetDate = "-";
                if (spotEarningsTodayCsResetDateInfoData != null) {
                    resetDate = spotEarningsTodayCsResetDateInfoData.getDataValue();
                }
                if (eurToCzkInfoData != null) {
                    eurToCzk = Float.parseFloat(eurToCzkInfoData.getDataValue());
                }
                if (lastHourOtePriceInfoData != null) {
                    lastHourOtePrice = Float.parseFloat(lastHourOtePriceInfoData.getDataValue());
                }
                if (totalFeedinInfoData != null) {
                    totalFeedin = Float.parseFloat(totalFeedinInfoData.getDataValue());
                }
                lastHourTotalFeedin = totalFeedin;
                if (lastHourTotalFeedinInfoData != null) {
                    lastHourTotalFeedin = Float.parseFloat(lastHourTotalFeedinInfoData.getDataValue());
                }
                if (lastHourTotalFeedin == 0.0f) {
                    lastHourTotalFeedin = totalFeedin;
                }
                lastHourFeedinValue = totalFeedin - lastHourTotalFeedin;
                if (spotEarningsTodayInfoData != null) {
                    spotEarningsTodayValue = Float.parseFloat(spotEarningsTodayInfoData.getDataValue());
                }
                if (spotEarningsTodayLocalCurrencyInfoData != null) {
                    spotEarningTodayLocalCurrencyValue = Float.parseFloat(spotEarningsTodayLocalCurrencyInfoData.getDataValue());
                }
                if (!resetDate.equals(formattedDate) || spotEarningsTodayCsResetDateInfoData == null) {
                    spotEarningsTodayValue = 0.0f;
                    spotEarningTodayLocalCurrencyValue = 0.0f;
                    dataMap.put("spot_earnings_today_cs_reset_date", new AbstractMap.SimpleEntry<String, String>(formattedDate, "-"));
                }
                float earnedLastHour = lastHourFeedinValue * lastHourOtePrice / 1000.0f * eurToCzk - spotPriceSellExtra * lastHourFeedinValue;
                spotEarningsTodayFinalLocalCurrency = spotEarningTodayLocalCurrencyValue + earnedLastHour;
                spotEarningsTodayFinal = spotEarningsTodayValue + lastHourFeedinValue * lastHourOtePrice / 1000.0f - spotPriceSellExtra * lastHourFeedinValue / eurToCzk;
                NicePrinter.nicePrint((String)("EARNINGS: Earned today so far: " + spotEarningsTodayFinalLocalCurrency + " CZK; Last hour: " + earnedLastHour + " CZK"), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                this.eventEntryManagerService.raiseEvent("EARNINGS: Earned last hour: " + earnedLastHour + " CZK", EventEntry.EventType.INFO, 60);
                dataMap.put("spot_earnings_today", new AbstractMap.SimpleEntry<String, String>(Float.toString(spotEarningsTodayFinal), "EUR"));
                dataMap.put("spot_earnings_today_local_currency", new AbstractMap.SimpleEntry<String, String>(Float.toString(spotEarningsTodayFinalLocalCurrency), "CZK"));
                dataMap.put("last_hour_total_feedin", new AbstractMap.SimpleEntry<String, String>(Float.toString(totalFeedin), "kWh"));
                this.saveinfodata(dataMap);
                return dataMap;
            }
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("EARNINGS: Some issue with calculating spot earnings - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            NicePrinter.nicePrint((String)("EARNINGS: Some issue with calculating spot earnings - - " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
        return new HashMap<String, Map.Entry<String, String>>();
    }
}

