/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.automation;

import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.domain.Trigger;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.TriggerManagerService;
import cz.snyll.sunny.services.automation.TriggerEvaluation;
import cz.snyll.sunny.services.automation.TriggerEvaluationService;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class TriggerEvaluationService
implements TriggerEvaluation {
    private static final Logger log = LoggerFactory.getLogger(TriggerEvaluationService.class);
    private final TriggerManagerService triggerManagerService;
    private final InfoDataManagerService infoDataManagerService;
    private final EventEntryManagerService eventEntryManagerService;

    @Autowired
    public TriggerEvaluationService(TriggerManagerService triggerManagerService, InfoDataManagerService infoDataManagerService, EventEntryManagerService eventEntryManagerService) {
        this.triggerManagerService = triggerManagerService;
        this.infoDataManagerService = infoDataManagerService;
        this.eventEntryManagerService = eventEntryManagerService;
    }

    @Scheduled(fixedDelay=5000L)
    public void evaluateTriggers() {
        try {
            for (Trigger trigger : this.triggerManagerService.loadAll()) {
                String key;
                InfoData infoData;
                InfoData infoDataCompare;
                log.info("Evaluating trigger: {} with id {} and key {} and value {} and operation {} and state {} and compare key {}", new Object[]{trigger.getTriggerName(), trigger.getId(), trigger.getInfoDataKey(), Float.valueOf(trigger.getInfoDataValue()), trigger.getTriggerOperation(), trigger.isTriggerState(), trigger.getInfoDataKeyCompare()});
                float val = trigger.getInfoDataValue();
                String keyCompare = trigger.getInfoDataKeyCompare();
                if (keyCompare != null && !keyCompare.isBlank() && (infoDataCompare = this.infoDataManagerService.findByDataKey(keyCompare)) != null) {
                    val = Float.parseFloat(infoDataCompare.getDataValue());
                }
                if ((infoData = this.infoDataManagerService.findByDataKey(key = trigger.getInfoDataKey())) == null) {
                    log.info("Trigger {} with id {} has not existing InfoData key name.", (Object)trigger.getTriggerName(), (Object)trigger.getId());
                    this.eventEntryManagerService.raiseEvent("Trigger " + trigger.getTriggerName() + " with id " + trigger.getId() + " has not existing InfoData key name.", EventEntry.EventType.WARNING, 60);
                    this.triggerManagerService.setTriggerState(false, trigger);
                    continue;
                }
                boolean EvaluatedState = false;
                float infoDataVal = 0.0f;
                if (trigger.getInfoDataKey().equals("today_dusk_time") || trigger.getInfoDataKey().equals("today_dawn_time")) {
                    LocalTime triggerTime;
                    LocalTime infoDataValueTime;
                    Date minus24hours = new Date(System.currentTimeMillis() - 86400000L);
                    if (infoData.getDataFreshness().before(minus24hours)) {
                        log.info("Trigger {} with id {} has old data in the database. Not triggering.", (Object)trigger.getTriggerName(), (Object)trigger.getId());
                        this.eventEntryManagerService.raiseEvent("Trigger " + trigger.getTriggerName() + " with id " + trigger.getId() + " has old data in the database. Not triggering.", EventEntry.EventType.WARNING, 60);
                        this.triggerManagerService.setTriggerState(false, trigger);
                        continue;
                    }
                    try {
                        infoDataValueTime = LocalTime.parse(infoData.getDataValue());
                        Instant instant = Instant.ofEpochSecond((long)trigger.getInfoDataValue());
                        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                        triggerTime = localDateTime.toLocalTime();
                    }
                    catch (Exception e) {
                        log.info("Time in wrong format, cannot evaluate trigger {}", (Object)trigger.getTriggerName());
                        this.eventEntryManagerService.raiseEvent("Time in wrong format, cannot evaluate trigger " + trigger.getTriggerName(), EventEntry.EventType.ERROR, 60);
                        this.triggerManagerService.setTriggerState(false, trigger);
                        continue;
                    }
                    switch (1.$SwitchMap$cz$snyll$sunny$domain$Trigger$TriggerOperation[trigger.getTriggerOperation().ordinal()]) {
                        case 1: {
                            this.triggerManagerService.setTriggerState(infoDataValueTime.equals(triggerTime), trigger);
                            break;
                        }
                        case 2: {
                            this.triggerManagerService.setTriggerState(infoDataValueTime.isBefore(triggerTime), trigger);
                            break;
                        }
                        case 3: {
                            this.triggerManagerService.setTriggerState(infoDataValueTime.isAfter(triggerTime), trigger);
                            break;
                        }
                        case 4: {
                            this.triggerManagerService.setTriggerState(!infoDataValueTime.isAfter(triggerTime), trigger);
                            break;
                        }
                        case 5: {
                            this.triggerManagerService.setTriggerState(!infoDataValueTime.isBefore(triggerTime), trigger);
                            break;
                        }
                        case 6: {
                            this.triggerManagerService.setTriggerState(infoDataValueTime.isBefore(triggerTime) || infoDataValueTime.isAfter(triggerTime), trigger);
                        }
                    }
                    log.info("Trigger {} with id {} evaluated to {}", new Object[]{trigger.getTriggerName(), trigger.getId(), trigger.isTriggerState()});
                    continue;
                }
                if (!infoData.isValid()) {
                    this.eventEntryManagerService.raiseEvent("Trigger " + trigger.getTriggerName() + " with id " + trigger.getId() + " has old data in the database. Not triggering.", EventEntry.EventType.WARNING, 60);
                    this.triggerManagerService.setTriggerState(false, trigger);
                    log.info("Trigger {} with id {} has old data in the database. Not triggering.", (Object)trigger.getTriggerName(), (Object)trigger.getId());
                    continue;
                }
                try {
                    infoDataVal = Float.parseFloat(infoData.getDataValue());
                }
                catch (Exception e) {
                    log.info("Trigger {} with id {} could not parse InfoData value into float.", (Object)trigger.getTriggerName(), (Object)trigger.getId());
                    this.eventEntryManagerService.raiseEvent("Trigger " + trigger.getTriggerName() + " with id " + trigger.getId() + ": could not parse InfoData value into float.", EventEntry.EventType.WARNING);
                    this.triggerManagerService.setTriggerState(false, trigger);
                }
                switch (1.$SwitchMap$cz$snyll$sunny$domain$Trigger$TriggerOperation[trigger.getTriggerOperation().ordinal()]) {
                    case 1: {
                        this.triggerManagerService.setTriggerState(infoDataVal == val, trigger);
                        break;
                    }
                    case 2: {
                        this.triggerManagerService.setTriggerState(infoDataVal < val, trigger);
                        break;
                    }
                    case 3: {
                        this.triggerManagerService.setTriggerState(infoDataVal > val, trigger);
                        break;
                    }
                    case 4: {
                        this.triggerManagerService.setTriggerState(infoDataVal <= val, trigger);
                        break;
                    }
                    case 5: {
                        this.triggerManagerService.setTriggerState(infoDataVal >= val, trigger);
                        break;
                    }
                    case 6: {
                        this.triggerManagerService.setTriggerState(infoDataVal != val, trigger);
                    }
                }
                log.info("Trigger {} with id {} evaluated to {}", new Object[]{trigger.getTriggerName(), trigger.getId(), trigger.isTriggerState()});
            }
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("Trigger evaluation failed: " + e.getMessage(), EventEntry.EventType.ERROR);
        }
    }
}

