/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.automation;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.domain.inverter.LocalAPIDetails;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.InverterActionServiceManager;
import cz.snyll.sunny.services.SunnyConfigurationService;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class InverterCloudController {
    private static final Logger log = LoggerFactory.getLogger(InverterCloudController.class);
    private final EventEntryManagerService eventEntryManagerService;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final InfoDataManagerService infoDataManagerService;
    private final RestTemplate restTemplate;
    private final InverterActionServiceManager inverterActionServiceManager;

    public InverterCloudController(EventEntryManagerService eventEntryManagerService, RestTemplateBuilder restTemplateBuilder, SunnyConfigurationService sunnyConfigurationService, InfoDataManagerService infoDataManagerService, InverterActionServiceManager inverterActionServiceManager) {
        this.eventEntryManagerService = eventEntryManagerService;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.infoDataManagerService = infoDataManagerService;
        this.restTemplate = restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(15L)).setReadTimeout(Duration.ofSeconds(15L)).build();
        this.inverterActionServiceManager = inverterActionServiceManager;
    }

    private static HttpEntity<MultiValueMap<String, String>> getMultiValueMapHttpEntity(int reg, String val, String localPassword) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("'X-Forwarded-For'", "'5.8.8.8'");
        LinkedMultiValueMap postData = new LinkedMultiValueMap();
        postData.add((Object)"optType", (Object)"setReg");
        postData.add((Object)"pwd", (Object)localPassword);
        postData.add((Object)"data", (Object)("{\"num\":1,\"Data\":[{\"reg\":" + reg + ",\"val\":" + val + "}]}"));
        return new HttpEntity((Object)postData, (MultiValueMap)headers);
    }

    public boolean sendInverterSettings(int reg, String val, boolean numeric, Inverter inverter) {
        String wifiSn;
        String inverterSn;
        this.inverterActionServiceManager.countCheck(inverter);
        val = numeric ? String.valueOf(Integer.parseInt((String)val)) : "'" + (String)val + "'";
        String tokenId = "";
        if (inverter.getConnectionDetails().getCommunicationType() == Inverter.CommunicationType.LocalAPI) {
            tokenId = ((LocalAPIDetails)inverter.getConnectionDetails()).getTokenId();
        }
        if (tokenId == null || tokenId.isEmpty()) {
            this.eventEntryManagerService.raiseEvent("InverterCloudController: issue when getting inverter token id, cannot send action: " + tokenId, EventEntry.EventType.ERROR);
            log.warn("InverterCloudController: issue when getting inverter token id, cannot send action: {}", (Object)tokenId);
            return false;
        }
        try {
            inverterSn = this.infoDataManagerService.getInfoDataForInverter(inverter, "solax_inverter_serial_number").getDataValue();
            wifiSn = this.infoDataManagerService.getInfoDataForInverter(inverter, "solax_wifi_serial_number").getDataValue();
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("InverterCloudController: issue when getting inverter sn and wifi sn, cannot send action: " + e.getMessage(), EventEntry.EventType.ERROR);
            NicePrinter.nicePrint((String)("InverterCloudController: issue when getting inverter sn and wifi sn, cannot send action: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return false;
        }
        if (inverterSn == null || wifiSn == null) {
            this.eventEntryManagerService.raiseEvent("InverterCloudController: inverterSn or wifiSn is null: " + inverterSn + ", " + wifiSn, EventEntry.EventType.ERROR);
            log.warn("InverterCloudController: inverterSn or wifiSn is null: {}, {}", (Object)inverterSn, (Object)wifiSn);
            return false;
        }
        LinkedMultiValueMap postData = new LinkedMultiValueMap();
        postData.add((Object)"optType", (Object)"setReg");
        postData.add((Object)"num", (Object)"1");
        postData.add((Object)"sn", (Object)wifiSn);
        postData.add((Object)"inverterSn", (Object)inverterSn);
        postData.add((Object)"deviceType", (Object)"1");
        postData.add((Object)"tokenId", (Object)tokenId);
        postData.add((Object)"Data", (Object)("[{'reg':" + reg + ",'val':" + (String)val + "}]"));
        HttpHeaders headers = new HttpHeaders();
        HttpEntity entity = new HttpEntity((Object)postData, (MultiValueMap)headers);
        String url = "https://www.solaxcloud.com/proxy/settingnew/paramSet";
        for (int attempt = 1; attempt <= 3; ++attempt) {
            try {
                NicePrinter.nicePrint((String)("InverterCloudController - Attempt " + attempt + ": sending inverter cloud action to https://www.solaxcloud.com/proxy/settingnew/paramSet with data: " + (MultiValueMap)postData), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                ResponseEntity response = this.restTemplate.exchange("https://www.solaxcloud.com/proxy/settingnew/paramSet", HttpMethod.POST, entity, String.class, new Object[0]);
                if (!response.getStatusCode().is2xxSuccessful()) {
                    this.eventEntryManagerService.raiseEvent("InverterCloudController - attempt " + attempt + ": failed with status " + response.getStatusCode() + ", response: " + (String)response.getBody(), EventEntry.EventType.WARNING);
                    continue;
                }
                NicePrinter.nicePrint((String)("InverterCloudController - attempt " + attempt + ": response = " + (String)response.getBody()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                if (response.getBody() != null && ((String)response.getBody()).contains("\"success\":true")) {
                    Thread.sleep(5000L);
                    return true;
                }
                this.eventEntryManagerService.raiseEvent("InverterCloudController - attempt " + attempt + ": action failed, response: " + (String)response.getBody(), EventEntry.EventType.WARNING);
            }
            catch (Exception e) {
                this.eventEntryManagerService.raiseEvent("InverterCloudController - attempt " + attempt + ": exception occurred - " + e.getMessage(), EventEntry.EventType.WARNING);
                NicePrinter.nicePrint((String)("InverterCloudController - exception on attempt " + attempt + ": " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            }
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
        this.eventEntryManagerService.raiseEvent("InverterCloudController - failed to send inverter cloud action after 3 attempts.", EventEntry.EventType.ERROR);
        return false;
    }

    public void unlockInverter(Inverter inverter) throws InterruptedException {
        if (!this.sendInverterSettings(0, "2014", false, inverter)) {
            Thread.sleep(1000L);
            if (!this.sendInverterSettings(0, "6868", false, inverter)) {
                this.eventEntryManagerService.raiseEvent("InverterCloudController: Unable to unlock the inverter for changes.", EventEntry.EventType.ERROR, 60);
                return;
            }
        }
        NicePrinter.nicePrint((String)"InverterCloudController: Inverter unlocked.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
    }
}

