/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.automation;

import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.DeviceSetting;
import cz.snyll.sunny.domain.Diverter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.repositories.DiverterRepository;
import cz.snyll.sunny.services.DeviceControllers.DeviceController;
import cz.snyll.sunny.services.DeviceControllers.DeviceControllerFactory;
import cz.snyll.sunny.services.DeviceControllers.DimmerController;
import cz.snyll.sunny.services.DeviceControllers.ShellyRestService;
import cz.snyll.sunny.services.DeviceSettingManagerService;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.automation.DiverterAutomationService;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class DiverterAutomationService {
    private static final Logger log = LoggerFactory.getLogger(DiverterAutomationService.class);
    private final DiverterRepository diverterRepository;
    private final InfoDataManagerService infoDataManagerService;
    private final EventEntryManagerService eventEntryManagerService;
    private final ShellyRestService shellyRestService;
    private final DeviceSettingManagerService deviceSettingManagerService;
    private int cycleCounter = 0;
    private static final int CYCLES_PER_CHANGE = 4;
    private final Map<String, Deque<Float>> exportHistory = new ConcurrentHashMap();

    @Scheduled(fixedRate=5000L)
    public void controlDiverters() {
        block30: {
            try {
                this.cycleCounter = (this.cycleCounter + 1) % 4;
                List diverters = this.diverterRepository.findAllByOrderByPriorityDesc();
                if (diverters.isEmpty()) {
                    return;
                }
                ArrayList<DiverterControl> controllable = new ArrayList<DiverterControl>();
                for (Diverter diverter : diverters) {
                    try {
                        Device device = diverter.getDiverterDevice();
                        DeviceController controller = DeviceControllerFactory.createDeviceController((Device)device, (EventEntryManagerService)this.eventEntryManagerService, (ShellyRestService)this.shellyRestService);
                        if (!(controller instanceof DimmerController)) continue;
                        DimmerController dimmer = (DimmerController)controller;
                        controllable.add(new DiverterControl(diverter, dimmer));
                    }
                    catch (Exception e) {
                        log.error("Failed to initialize controller for diverter '{}': {}", new Object[]{diverter.getDiverterName(), e.getMessage(), e});
                        this.eventEntryManagerService.raiseEvent("Failed to initialize controller for diverter '" + diverter.getDiverterName() + "': " + e.getMessage(), EventEntry.EventType.ERROR, 60);
                    }
                }
                for (DiverterControl diverterControl : controllable) {
                    try {
                        String key = diverterControl.diverter.getExportInfoDataKey();
                        if (key == null) {
                            log.warn("Diverter '{}' has null exportInfoDataKey, skipping.", (Object)diverterControl.diverter.getDiverterName());
                            continue;
                        }
                        InfoData info = this.infoDataManagerService.findByDataKey(key);
                        float exportValue = info != null && info.isValid() ? info.floatValue().floatValue() : 0.0f;
                        Deque history = this.exportHistory.computeIfAbsent(key, k -> new LinkedList());
                        if (history.size() >= 4) {
                            history.removeFirst();
                        }
                        history.addLast(Float.valueOf(exportValue));
                        float avgExport = (float)history.stream().mapToDouble(Float::doubleValue).average().orElse(0.0);
                        diverterControl.setAverageExport(avgExport);
                        log.info("Diverter '{}' avg export: {}", (Object)diverterControl.diverter.getDiverterName(), (Object)Float.valueOf(avgExport));
                    }
                    catch (Exception e) {
                        log.error("Failed to update export history for diverter '{}': {}", new Object[]{diverterControl.diverter.getDiverterName(), e.getMessage(), e});
                        this.eventEntryManagerService.raiseEvent("Failed to update export history for diverter '" + diverterControl.diverter.getDiverterName() + "': " + e.getMessage(), EventEntry.EventType.ERROR, 30);
                    }
                }
                if (this.cycleCounter != 0) break block30;
                for (DiverterControl diverterControl : controllable) {
                    try {
                        Diverter diverter = diverterControl.diverter;
                        DimmerController dimmer = diverterControl.dimmer;
                        float currentLevel = dimmer.getLevel();
                        if (diverter.isActive() && (this.shouldProceedDiverter(diverter) || this.shouldProceedDiverterHard(diverter)) || !(currentLevel > 0.0f)) continue;
                        dimmer.setLevel(0.0f);
                        log.info("Diverter '{}' decreasing from level {} to 0%", (Object)diverter.getDiverterName(), (Object)Float.valueOf(currentLevel));
                        this.eventEntryManagerService.raiseEvent("Diverter '" + diverter.getDiverterName() + "' set to 0%", EventEntry.EventType.INFO, 30);
                    }
                    catch (Exception e) {
                        log.error("Failed to handle inactive diverter '{}': {}", new Object[]{diverterControl.diverter.getDiverterName(), e.getMessage(), e});
                    }
                }
                List<DiverterControl> activeDiverters = controllable.stream().filter(dc -> dc.diverter.isActive()).toList();
                for (DiverterControl dc3 : activeDiverters) {
                    try {
                        boolean setOk;
                        float currentLevel;
                        Diverter diverter = dc3.diverter;
                        DimmerController dimmer = dc3.dimmer;
                        if (!this.shouldProceedDiverterHard(diverter) || !((currentLevel = dimmer.getLevel()) < 100.0f) || !(setOk = dimmer.setLevel(100.0f))) continue;
                        log.info("Diverter '{}' set to 100% due to hard device settings (from {}%)", (Object)diverter.getDiverterName(), (Object)Float.valueOf(currentLevel));
                        this.eventEntryManagerService.raiseEvent("Diverter '" + diverter.getDiverterName() + "' set to 100% (hard override)", EventEntry.EventType.INFO, 30);
                    }
                    catch (Exception e) {
                        log.error("Failed to handle hard device settings for diverter '{}': {}", new Object[]{dc3.diverter.getDiverterName(), e.getMessage(), e});
                        this.eventEntryManagerService.raiseEvent("Failed to handle hard device settings for diverter '" + dc3.diverter.getDiverterName() + "': " + e.getMessage(), EventEntry.EventType.ERROR, 30);
                    }
                }
                List<DiverterControl> list = activeDiverters.stream().filter(dc -> !this.shouldProceedDiverterHard(dc.diverter) && this.shouldProceedDiverter(dc.diverter)).toList();
                boolean allHigherMaxed = true;
                for (DiverterControl dc4 : list) {
                    try {
                        float currentLevel;
                        Diverter diverter = dc4.diverter;
                        DimmerController dimmer = dc4.dimmer;
                        float avgExport = dc4.getAverageExport();
                        float newLevel = currentLevel = dimmer.getLevel();
                        boolean changed = false;
                        int exportThreshold = diverter.getExportThreshold();
                        int importThreshold = diverter.getImportThreshold();
                        if (allHigherMaxed && avgExport > (float)exportThreshold) {
                            if (currentLevel < 100.0f) {
                                newLevel = Math.min(100.0f, currentLevel + diverter.getLevelStep());
                                log.info("Diverter '{}' increasing to level {} from {}, avgExport={}, exportThreshold={}", new Object[]{diverter.getDiverterName(), Float.valueOf(newLevel), Float.valueOf(currentLevel), Float.valueOf(avgExport), exportThreshold});
                                changed = true;
                            }
                        } else if (avgExport < (float)importThreshold) {
                            if (currentLevel > 0.0f) {
                                newLevel = Math.max(0.0f, currentLevel - diverter.getLevelStep());
                                log.info("Diverter '{}' decreasing from level {} to {}, avgExport={}, importThreshold={}", new Object[]{diverter.getDiverterName(), Float.valueOf(currentLevel), Float.valueOf(newLevel), Float.valueOf(avgExport), importThreshold});
                                changed = true;
                            }
                        } else {
                            log.info("Diverter '{}' not changing (avgExport={} within thresholds {}...{})", new Object[]{diverter.getDiverterName(), Float.valueOf(avgExport), importThreshold, exportThreshold});
                        }
                        if (changed && (double)Math.abs(newLevel - currentLevel) > 0.01) {
                            try {
                                boolean setOk = dimmer.setLevel(newLevel);
                                if (setOk) {
                                    this.eventEntryManagerService.raiseEvent("Diverter '" + diverter.getDiverterName() + "' set to " + (int)newLevel + "%", newLevel > currentLevel ? EventEntry.EventType.INFO : EventEntry.EventType.WARNING, 30);
                                    log.info("Diverter '{}' set to {}%", (Object)diverter.getDiverterName(), (Object)Float.valueOf(newLevel));
                                }
                            }
                            catch (Exception e) {
                                log.error("Failed to set level for diverter '{}': {}", new Object[]{diverter.getDiverterName(), e.getMessage(), e});
                                this.eventEntryManagerService.raiseEvent("Failed to set level for diverter '" + diverter.getDiverterName() + "': " + e.getMessage(), EventEntry.EventType.ERROR, 30);
                            }
                        }
                        if (!(newLevel < 100.0f)) continue;
                        allHigherMaxed = false;
                    }
                    catch (Exception e) {
                        log.error("Exception in diverter control loop for '{}': {}", new Object[]{dc4.diverter.getDiverterName(), e.getMessage(), e});
                        this.eventEntryManagerService.raiseEvent("Exception in diverter control loop for '" + dc4.diverter.getDiverterName() + "': " + e.getMessage(), EventEntry.EventType.ERROR, 60);
                    }
                }
            }
            catch (Exception e) {
                log.error("Diverter control scheduler failed: {}", (Object)e.getMessage(), (Object)e);
                this.eventEntryManagerService.raiseEvent("Diverter control scheduler failed: " + e.getMessage(), EventEntry.EventType.ERROR, 90);
            }
        }
    }

    public boolean shouldProceedDiverter(Diverter diverter) {
        if (diverter.getDeviceSettings().isEmpty()) {
            return true;
        }
        for (DeviceSetting deviceSettings : diverter.getDeviceSettings()) {
            if (!deviceSettings.isActive() || !this.deviceSettingManagerService.evaluateDeviceSetting(deviceSettings)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldProceedDiverterHard(Diverter diverter) {
        if (diverter.getDeviceSettingsHard() == null || diverter.getDeviceSettingsHard().isEmpty()) {
            return false;
        }
        for (DeviceSetting deviceSettings : diverter.getDeviceSettingsHard()) {
            if (!deviceSettings.isActive() || !this.deviceSettingManagerService.evaluateDeviceSetting(deviceSettings)) continue;
            return true;
        }
        return false;
    }

    public DiverterAutomationService(DiverterRepository diverterRepository, InfoDataManagerService infoDataManagerService, EventEntryManagerService eventEntryManagerService, ShellyRestService shellyRestService, DeviceSettingManagerService deviceSettingManagerService) {
        this.diverterRepository = diverterRepository;
        this.infoDataManagerService = infoDataManagerService;
        this.eventEntryManagerService = eventEntryManagerService;
        this.shellyRestService = shellyRestService;
        this.deviceSettingManagerService = deviceSettingManagerService;
    }
}

