/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.automation;

import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.DeviceSetting;
import cz.snyll.sunny.domain.DeviceStatus;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.DeviceControllers.DeviceController;
import cz.snyll.sunny.services.DeviceControllers.DeviceControllerFactory;
import cz.snyll.sunny.services.DeviceControllers.ShellyRestService;
import cz.snyll.sunny.services.DeviceManagerService;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AutomationService
extends DataCollectorAbstractService {
    private static final Logger log = LoggerFactory.getLogger(AutomationService.class);
    private static final Logger logger = LoggerFactory.getLogger(AutomationService.class);
    private static final int AUTOMATE_DEVICES_DELAY = 10000;
    private static final int SLEEP_DURATION = 1000;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final DeviceManagerService deviceManagerService;
    private final EventEntryManagerService eventEntryManagerService;
    private final ShellyRestService shellyRestService;

    public AutomationService(InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService, DeviceManagerService deviceManagerService, EventEntryManagerService eventEntryManagerService, ShellyRestService shellyRestService) {
        super(infoDataManagerService);
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.deviceManagerService = deviceManagerService;
        this.eventEntryManagerService = eventEntryManagerService;
        this.shellyRestService = shellyRestService;
    }

    @Scheduled(fixedDelay=10000L)
    public void automateDevices() {
        if (!Boolean.parseBoolean(this.sunnyConfigurationService.getSetting("automation"))) {
            log.info("Automation is disabled.");
            return;
        }
        ArrayList turnOnDevices = new ArrayList();
        ArrayList turnOffDevices = new ArrayList();
        this.deviceManagerService.loadAll().forEach(device -> {
            logger.info("Automation for device: {}", (Object)device.getDeviceName());
            this.handleDeviceErrorState(device);
            DeviceController deviceController = DeviceControllerFactory.createDeviceController((Device)device, (EventEntryManagerService)this.eventEntryManagerService, (ShellyRestService)this.shellyRestService);
            if (deviceController != null) {
                log.info("Device {} - Automation started", (Object)device.getDeviceName());
                try {
                    this.refreshDeviceData(device, deviceController);
                    this.collectAndSaveDeviceData(device, deviceController);
                    this.deviceManagerService.dailyReset(device, deviceController);
                    if (!this.isAnyConditionActive(device)) {
                        log.info("No active conditions for device {}", (Object)device.getDeviceName());
                        return;
                    }
                    this.handleDeviceOverride(device);
                    if (device.getDeviceStatus().isManualOverride()) {
                        log.info("Device {} - Manual override in place. Not automating.", (Object)device.getDeviceName());
                        return;
                    }
                    this.evaluateDeviceStatus(device, deviceController, turnOnDevices, turnOffDevices);
                }
                catch (Exception e) {
                    this.eventEntryManagerService.raiseEvent("Error during automation for device " + device.getDeviceName() + ": " + e.getMessage(), EventEntry.EventType.ERROR, 60);
                }
            } else {
                this.eventEntryManagerService.raiseEvent("No Device Controller for " + device.getDeviceName(), EventEntry.EventType.WARNING, 60);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.eventEntryManagerService.raiseEvent("Interrupted during sleep: " + e.getMessage(), EventEntry.EventType.WARNING, 60);
            }
        });
        this.processTurnOffDevices(turnOffDevices);
        this.processTurnOnDevices(turnOnDevices);
    }

    private boolean isAnyConditionActive(Device device) {
        return device.getDeviceSettings().stream().anyMatch(DeviceSetting::isActive);
    }

    private void handleDeviceErrorState(Device device) {
        Duration errorDuration;
        if (device.getDeviceStatus().getCurrentState() == DeviceStatus.OperationStatus.ERROR && (errorDuration = Duration.between(device.getDeviceStatus().getLastStateChange(), LocalDateTime.now())).toMinutes() > 10L) {
            logger.debug("Restarting faulty device status - {}", (Object)device.getDeviceName());
            device.getDeviceStatus().setCurrentState(DeviceStatus.OperationStatus.OFF);
            this.deviceManagerService.saveDeviceStatus(device.getDeviceStatus());
        }
    }

    protected void refreshDeviceData(Device device, DeviceController deviceController) throws Exception {
        deviceController.refreshData();
        device.getDeviceStatus().setCurrentConsumption(deviceController.getCurrentConsumption());
        device.getDeviceStatus().setTodayConsumption(deviceController.getTodayConsumption());
        device.getDeviceStatus().setTemperature(deviceController.getTemperature());
        Duration runningTime = Duration.ZERO;
        if (device.getDeviceStatus().getCurrentState() == DeviceStatus.OperationStatus.ON) {
            runningTime = Duration.between(device.getDeviceStatus().getLastStateChange(), LocalDateTime.now());
        }
        device.getDeviceStatus().setCurrentRuntime(runningTime.toMinutes());
        this.deviceManagerService.saveDeviceStatus(device.getDeviceStatus());
    }

    protected void collectAndSaveDeviceData(Device device, DeviceController deviceController) {
        HashMap<CallSite, Map.Entry<String, String>> dataMap = new HashMap<CallSite, Map.Entry<String, String>>();
        dataMap.put((CallSite)((Object)("device_" + device.getId() + "_current_consumption")), Map.entry(String.valueOf(device.getDeviceStatus().getCurrentConsumption()), "W"));
        dataMap.put((CallSite)((Object)("device_" + device.getId() + "_today_consumption")), Map.entry(String.valueOf(device.getDeviceStatus().getTodayConsumption()), "kWh"));
        dataMap.put((CallSite)((Object)("device_" + device.getId() + "_last_day_total_consumption")), Map.entry(String.valueOf(device.getDeviceStatus().getLastDayTotalConsumption()), "kWh"));
        dataMap.put((CallSite)((Object)("device_" + device.getId() + "_state")), Map.entry(String.valueOf(device.getDeviceStatus().getCurrentState()), ""));
        dataMap.put((CallSite)((Object)("device_" + device.getId() + "_real_state")), Map.entry(String.valueOf(deviceController.getActualStatus()), ""));
        dataMap.put((CallSite)((Object)("device_" + device.getId() + "_real_state_numeric")), Map.entry(String.valueOf(deviceController.getActualStatus() ? 1 : 0), ""));
        dataMap.put((CallSite)((Object)("device_" + device.getId() + "_state_numeric")), Map.entry(String.valueOf(device.getDeviceStatus().getCurrentState() == DeviceStatus.OperationStatus.ON ? 1 : 0), ""));
        Optional<InfoData> solarPowerNow = Optional.ofNullable(super.getInfoDataManagerService().findByDataKey("solax_solar_panels_power_total"));
        Optional<InfoData> houseConsumptionNow = Optional.ofNullable(super.getInfoDataManagerService().findByDataKey("solax_power_consumption_now"));
        if (solarPowerNow.isPresent() && houseConsumptionNow.isPresent()) {
            try {
                double powerLeftAfterTurnOn = AutomationService.getPowerLeftAfterTurnOn((Device)device, (InfoData)solarPowerNow.get(), (InfoData)houseConsumptionNow.get());
                dataMap.put((CallSite)((Object)("device_" + device.getId() + "_power_left_after_turn_on")), Map.entry(String.valueOf(powerLeftAfterTurnOn), "W"));
            }
            catch (NumberFormatException e) {
                this.eventEntryManagerService.raiseEvent("Error calculating power left after turn on.", EventEntry.EventType.WARNING, 60);
            }
        }
        dataMap.put((CallSite)((Object)("device_" + device.getId() + "_temperature")), Map.entry(String.valueOf(device.getDeviceStatus().getTemperature()), "\u00b0C"));
        dataMap.put((CallSite)((Object)("device_" + device.getId() + "_today_runtime")), Map.entry(String.valueOf(device.getDeviceStatus().getTodayRuntime() + device.getDeviceStatus().getCurrentRuntime()), "min"));
        this.saveinfodata(dataMap);
    }

    private void evaluateDeviceStatus(Device device, DeviceController deviceController, ArrayList<Device> turnOnDevices, ArrayList<Device> turnOffDevices) {
        boolean actualStatus = deviceController.getActualStatus();
        if (actualStatus != (device.getDeviceStatus().getCurrentState() == DeviceStatus.OperationStatus.ON)) {
            this.handleDeviceStatusMismatch(device, actualStatus);
        } else if (this.deviceManagerService.shouldDeviceTurnOn(device) && device.getDeviceStatus().getCurrentState() == DeviceStatus.OperationStatus.OFF) {
            log.info("Device {} - Turning ON", (Object)device.getDeviceName());
            this.eventEntryManagerService.raiseEvent("Device " + device.getDeviceName() + " is going to be turned ON.", EventEntry.EventType.INFO, 0);
            turnOnDevices.add(device);
        } else if (!this.deviceManagerService.shouldDeviceTurnOn(device) && device.getDeviceStatus().getCurrentState() == DeviceStatus.OperationStatus.ON) {
            log.info("Device {} - Turning OFF", (Object)device.getDeviceName());
            this.eventEntryManagerService.raiseEvent("Device " + device.getDeviceName() + " is going to be turned OFF.", EventEntry.EventType.INFO, 0);
            turnOffDevices.add(device);
        } else {
            log.info("Device {} - No action needed: state: {}, should turn on: {}", new Object[]{device.getDeviceName(), device.getDeviceStatus().getCurrentState(), this.deviceManagerService.shouldDeviceTurnOn(device)});
            this.eventEntryManagerService.raiseEvent("Device " + device.getDeviceName() + " staying in current state. State: " + device.getDeviceStatus().getCurrentState() + "; should turn on: " + this.deviceManagerService.shouldDeviceTurnOn(device), EventEntry.EventType.INFO, 1);
        }
    }

    private void handleDeviceStatusMismatch(Device device, boolean actualStatus) {
        if (device.isForceActualStatus()) {
            boolean result;
            boolean bl = result = actualStatus ? this.deviceManagerService.turnOnDevice(device, false) : this.deviceManagerService.turnOffDevice(device, false);
            if (result) {
                this.eventEntryManagerService.raiseEvent("Device " + device.getDeviceName() + " state forced successfully.", EventEntry.EventType.WARNING, 60);
            } else {
                this.eventEntryManagerService.raiseEvent("Device " + device.getDeviceName() + " could not be forced.", EventEntry.EventType.ERROR, 60);
            }
        } else {
            this.eventEntryManagerService.raiseEvent("Device " + device.getDeviceName() + " - Status mismatch. Not forcing.", EventEntry.EventType.WARNING, 30);
        }
    }

    private void handleDeviceOverride(Device device) {
        if (device.getDeviceStatus().isManualOverride()) {
            if (LocalDateTime.now().isAfter(device.getDeviceStatus().getOverriddenUntil())) {
                logger.debug("Device {} - Manual override ended. Resuming automation.", (Object)device.getDeviceName());
                this.deviceManagerService.resetOverride(device);
            } else {
                logger.debug("Override in place for device {}, not automating.", (Object)device.getDeviceName());
            }
        }
    }

    private void processTurnOffDevices(ArrayList<Device> turnOffDevices) {
        if (!turnOffDevices.isEmpty()) {
            turnOffDevices.sort(Comparator.comparing(Device::getCurrentDevicePriority));
            Device deviceToTurnOff = turnOffDevices.get(0);
            if (this.deviceManagerService.turnOffDevice(deviceToTurnOff, false)) {
                this.eventEntryManagerService.raiseEvent("Device " + deviceToTurnOff.getDeviceName() + " turned OFF successfully.", EventEntry.EventType.SUCCESS);
            } else {
                this.eventEntryManagerService.raiseEvent("Device " + deviceToTurnOff.getDeviceName() + " - turn OFF was not confirmed!", EventEntry.EventType.ERROR);
                deviceToTurnOff.getDeviceStatus().setCurrentState(DeviceStatus.OperationStatus.ERROR);
                deviceToTurnOff.getDeviceStatus().setLastStateChange(LocalDateTime.now());
            }
        }
    }

    private void processTurnOnDevices(ArrayList<Device> turnOnDevices) {
        if (!turnOnDevices.isEmpty()) {
            turnOnDevices.sort(Comparator.comparing(Device::getCurrentDevicePriority).reversed());
            Device deviceToTurnOn = turnOnDevices.get(0);
            if (this.deviceManagerService.turnOnDevice(deviceToTurnOn, false)) {
                this.eventEntryManagerService.raiseEvent("Device " + deviceToTurnOn.getDeviceName() + " turned ON successfully.", EventEntry.EventType.SUCCESS);
            } else {
                this.eventEntryManagerService.raiseEvent("Device " + deviceToTurnOn.getDeviceName() + " - turn ON was not confirmed! Device in error state.", EventEntry.EventType.ERROR, 10);
                deviceToTurnOn.getDeviceStatus().setCurrentState(DeviceStatus.OperationStatus.ERROR);
                deviceToTurnOn.getDeviceStatus().setLastStateChange(LocalDateTime.now());
            }
        }
    }

    private static double getPowerLeftAfterTurnOn(Device device, InfoData solarPowerNow, InfoData houseConsumptionNow) {
        double solarPowerNowValue = Double.parseDouble(solarPowerNow.getDataValue());
        double houseConsumptionNowValue = Double.parseDouble(houseConsumptionNow.getDataValue());
        return device.getDeviceStatus().getCurrentState() == DeviceStatus.OperationStatus.OFF ? solarPowerNowValue - houseConsumptionNowValue - (double)device.getDeviceConsumption() : solarPowerNowValue - houseConsumptionNowValue;
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        return new HashMap<String, Map.Entry<String, String>>();
    }
}

