/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services;

import cz.snyll.sunny.config.SchedulerConfig;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class SchedulerManagement {
    @Autowired
    private EventEntryManagerService eventEntryManagerService;
    private final SchedulerConfig schedulerConfig;
    private final SunnyConfigurationService sunnyConfigurationService;

    @Autowired
    public SchedulerManagement(SchedulerConfig schedulerConfig, SunnyConfigurationService sunnyConfigurationService) {
        this.schedulerConfig = schedulerConfig;
        this.sunnyConfigurationService = sunnyConfigurationService;
    }

    @Scheduled(fixedDelay=10000L)
    public void checkSchedules() {
        ThreadPoolTaskScheduler taskScheduler = this.schedulerConfig.getTaskScheduler();
        if (taskScheduler.getActiveCount() >= this.schedulerConfig.getPOOL_SIZE() - 5) {
            this.eventEntryManagerService.raiseEvent("ERROR: There is too many threads running, application might get stuck soon.", EventEntry.EventType.ERROR);
        }
        NicePrinter.nicePrint((String)("Scheduled active tasks: " + taskScheduler.getActiveCount()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
    }
}

