/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services;

import com.google.gson.Gson;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.DeviceSetting;
import cz.snyll.sunny.domain.EmailNotification;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.repositories.NotificationRepository;
import cz.snyll.sunny.services.DeviceSettingManagerService;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.NotificationServiceManager;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import cz.snyll.sunny.services.datasenders.SunnyHomeClickAPIManager;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class NotificationServiceManager
extends DataCollectorAbstractService {
    public static final String SUNNYHOME_NOTIFICATION = "SUNNYHOME NOTIFICATION:";
    private final SunnyConfigurationService sunnyConfigurationService;
    private final NotificationRepository notificationRepository;
    private final DeviceSettingManagerService deviceSettingManagerService;
    private final EventEntryManagerService eventEntryManagerService;
    private final SunnyHomeClickAPIManager sunnyHomeClickAPIManager;
    @Value(value="${sunnyhomeonline.url}")
    private String sunnyHomeOnlineUrl;

    @Autowired
    public NotificationServiceManager(EventEntryManagerService eventEntryManagerService, InfoDataManagerService infoDataManagerService, DeviceSettingManagerService deviceSettingManagerService, SunnyConfigurationService sunnyConfigurationService, NotificationRepository notificationRepository, SunnyHomeClickAPIManager sunnyHomeClickAPIManager) {
        super(infoDataManagerService);
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.notificationRepository = notificationRepository;
        this.deviceSettingManagerService = deviceSettingManagerService;
        this.eventEntryManagerService = eventEntryManagerService;
        this.sunnyHomeClickAPIManager = sunnyHomeClickAPIManager;
    }

    @Scheduled(fixedDelay=10000L)
    public void automateNotifications() {
        if (this.sunnyConfigurationService.getSetting("sunnyhome_click_user") == null || this.sunnyConfigurationService.getSetting("sunnyhome_click_token") == null || this.sunnyConfigurationService.getSetting("sunnyhome_click_email") == null) {
            NicePrinter.nicePrint((String)"SUNNYHOME NOTIFICATION: Missing sunnyhome.click API settings, skipping notifications.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return;
        }
        if (this.sunnyConfigurationService.getSetting("sunnyhome_click_user").isEmpty() || this.sunnyConfigurationService.getSetting("sunnyhome_click_token").isEmpty() || this.sunnyConfigurationService.getSetting("sunnyhome_click_email").isEmpty()) {
            NicePrinter.nicePrint((String)"SUNNYHOME NOTIFICATION: Missing sunnyhome.click API settings (empty), skipping notifications.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return;
        }
        Iterable notifications = this.notificationRepository.findAll();
        for (EmailNotification notification : notifications) {
            NicePrinter.nicePrint((String)("SUNNYHOME NOTIFICATION: Processing notification " + notification.getNotificationName()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            if (!notification.isEnabled()) continue;
            NicePrinter.nicePrint((String)("SUNNYHOME NOTIFICATION: Notification " + notification.getNotificationName() + " is enabled."), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            if (this.conditionsValid(notification)) {
                NicePrinter.nicePrint((String)("SUNNYHOME NOTIFICATION: Notification " + notification.getNotificationName() + " conditions are valid."), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                if (notification.getLastSent().plusMinutes(notification.getNotificationDelay()).isBefore(LocalDateTime.now()) && !notification.isNotificationActive()) {
                    if (this.sendNotification(notification, false)) {
                        notification.setNotificationActive(true);
                        notification.setLastSent(LocalDateTime.now());
                        this.notificationRepository.save((Object)notification);
                        this.eventEntryManagerService.raiseEvent("Notification " + notification.getNotificationName() + " sent successfully.", EventEntry.EventType.SUCCESS);
                    } else {
                        NicePrinter.nicePrint((String)("SUNNYHOME NOTIFICATION: Notification " + notification.getNotificationName() + " failed to send."), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                        this.eventEntryManagerService.raiseEvent("Notification " + notification.getNotificationName() + " failed while sending.", EventEntry.EventType.ERROR);
                    }
                }
            }
            if (notification.isSendWhenEnds() && notification.isNotificationActive() && !this.conditionsValid(notification)) {
                if (this.sendNotification(notification, true)) {
                    NicePrinter.nicePrint((String)("SUNNYHOME NOTIFICATION: Notification " + notification.getNotificationName() + " is active and set to send when ends."), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                    notification.setNotificationActive(false);
                    this.notificationRepository.save((Object)notification);
                    this.eventEntryManagerService.raiseEvent("Notification END " + notification.getNotificationName() + " sent successfully.", EventEntry.EventType.SUCCESS);
                } else {
                    NicePrinter.nicePrint((String)("SUNNYHOME NOTIFICATION: Notification " + notification.getNotificationName() + " is active and set to send when ends, but failed to send."), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                    this.eventEntryManagerService.raiseEvent("Notification END " + notification.getNotificationName() + " failed while sending.", EventEntry.EventType.ERROR);
                }
            }
            if (notification.isSendWhenEnds() || !notification.isNotificationActive() || this.conditionsValid(notification)) continue;
            NicePrinter.nicePrint((String)("SUNNYHOME NOTIFICATION: Notification " + notification.getNotificationName() + " is active, but not set to send when ends."), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            notification.setNotificationActive(false);
            this.notificationRepository.save((Object)notification);
        }
    }

    public boolean conditionsValid(EmailNotification emailNotification) {
        for (DeviceSetting notificationCondition : emailNotification.getNotificationConditions()) {
            if (!notificationCondition.isActive() || !this.deviceSettingManagerService.evaluateDeviceSetting(notificationCondition)) continue;
            return true;
        }
        return false;
    }

    public boolean sendNotification(EmailNotification emailNotification, boolean notificationEnd) {
        try {
            String sunnyHomeOnlineUser = this.sunnyConfigurationService.getSetting("sunnyhome_click_user");
            sunnyHomeOnlineUser = sunnyHomeOnlineUser.trim();
            String token = this.sunnyConfigurationService.getSetting("sunnyhome_click_token");
            token = token.trim();
            String notification_email = this.sunnyConfigurationService.getSetting("sunnyhome_click_email");
            notification_email = notification_email.trim();
            Gson gson = new Gson();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String formattedDateTime = LocalDateTime.now().format(formatter);
            String endString = " - START: " + formattedDateTime;
            if (notificationEnd) {
                endString = " - END: " + formattedDateTime;
            }
            if (!emailNotification.isSendWhenEnds()) {
                endString = " - " + formattedDateTime;
            }
            EmailNotificationDTO emailNotificationDTO = this.getEmailNotificationDTO(emailNotification, endString, notification_email);
            String json = gson.toJson((Object)emailNotificationDTO);
            NicePrinter.nicePrint((String)("SUNNYHOME NOTIFICATION: Sending notification email for " + emailNotification.getNotificationName() + " to sunnyhome.click API. JSON: " + json), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            String url = this.sunnyHomeOnlineUrl + "/emails/" + sunnyHomeOnlineUser + "/send_email";
            String response = this.sunnyHomeClickAPIManager.CallSunnyHomeClickAPI(token, url, json);
            if (response != null) {
                this.eventEntryManagerService.raiseEvent("Notification email for " + emailNotification.getNotificationName() + " sent, response: " + response, EventEntry.EventType.INFO);
                NicePrinter.nicePrint((String)("SUNNYHOME NOTIFICATION: Response from sunnyhome.click API: " + response), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            }
        }
        catch (Exception e) {
            NicePrinter.nicePrint((String)("SUNNYHOME NOTIFICATION: Error while sending notification email for " + emailNotification.getNotificationName() + ": " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            this.eventEntryManagerService.raiseEvent("Error while sending notification email via sunnyhome.click: " + e.getMessage(), EventEntry.EventType.ERROR);
            return false;
        }
        return true;
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        return new HashMap<String, Map.Entry<String, String>>();
    }

    public void saveEmailNotification(EmailNotification emailNotification) {
        this.notificationRepository.save((Object)emailNotification);
    }

    public void deleteEmailNotificationById(Long id) {
        this.notificationRepository.deleteById((Object)id);
    }

    public Iterable<EmailNotification> loadAll() {
        return this.notificationRepository.findAll();
    }

    public EmailNotification loadById(Long id) {
        return this.notificationRepository.findById((Object)id).orElseGet(EmailNotification::new);
    }

    private EmailNotificationDTO getEmailNotificationDTO(EmailNotification emailNotification, String endString, String notificationEmail) {
        EmailNotificationDTO emailNotificationDTO = new EmailNotificationDTO();
        InfoDataManagerService infoDataManagerService = this.getInfoDataManagerService();
        emailNotificationDTO.setBody(emailNotification.getEmailBody());
        for (InfoData infoData : infoDataManagerService.findAll()) {
            emailNotificationDTO.setBody(emailNotificationDTO.getBody().replace("{{" + infoData.getDataKey() + "}}", infoData.getDataValue()));
        }
        emailNotificationDTO.setSubject(emailNotification.getEmailSubject() + endString);
        emailNotificationDTO.setEmail(notificationEmail);
        return emailNotificationDTO;
    }
}

