/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.DeviceSetting;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.domain.InverterAction;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.repositories.InverterActionRepository;
import cz.snyll.sunny.services.DeviceSettingManagerService;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import cz.snyll.sunny.services.modbus.ModbusServiceFactory;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class InverterActionServiceManager
extends DataCollectorAbstractService {
    private final SunnyConfigurationService sunnyConfigurationService;
    private final InverterActionRepository inverterActionRepository;
    private final DeviceSettingManagerService deviceSettingManagerService;
    private final EventEntryManagerService eventEntryManagerService;
    private final ModbusServiceFactory modbusServiceFactory;
    private final Queue<InverterAction> inverterActionQueue;

    @Autowired
    public InverterActionServiceManager(ModbusServiceFactory modbusServiceFactory, EventEntryManagerService eventEntryManagerService, InfoDataManagerService infoDataManagerService, DeviceSettingManagerService deviceSettingManagerService, SunnyConfigurationService sunnyConfigurationService, InverterActionRepository inverterActionRepository) {
        super(infoDataManagerService);
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.inverterActionRepository = inverterActionRepository;
        this.deviceSettingManagerService = deviceSettingManagerService;
        this.eventEntryManagerService = eventEntryManagerService;
        this.modbusServiceFactory = modbusServiceFactory;
        this.inverterActionQueue = new LinkedList();
    }

    @Scheduled(fixedDelay=60000L)
    public void automateInverterActions() {
        NicePrinter.nicePrint((String)"Automation cycle for inverter actions starting.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        if (!Boolean.parseBoolean(this.sunnyConfigurationService.getSetting("automation"))) {
            return;
        }
        NicePrinter.nicePrint((String)"Automation cycle for inverter actions started.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        Iterable inverterActions = this.getAllInverterActions();
        LocalDateTime now = LocalDateTime.now();
        for (InverterAction inverterAction : inverterActions) {
            NicePrinter.nicePrint((String)("Automation cycle for inverter actions: Checking inverter action " + inverterAction.getInverteractionName() + "."), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            if (inverterAction.isEnabled()) {
                if (inverterAction.getLastStateChange() == null) {
                    inverterAction.setLastStateChange(now);
                }
                Duration activeDuration = Duration.between(inverterAction.getLastStateChange(), now);
                int currentActiveMinutes = (int)activeDuration.toMinutes();
                inverterAction.setCurrentActiveTime(currentActiveMinutes);
            } else {
                inverterAction.setCurrentActiveTime(0);
            }
            this.inverterActionRepository.save((Object)inverterAction);
            if (inverterAction.getCurrentActiveTime() < inverterAction.getMinActiveTime() || inverterAction.getCurrentActiveTime() > inverterAction.getMaxActiveTime() && inverterAction.getMaxActiveTime() > 0) {
                this.eventEntryManagerService.raiseEvent("INVERTER ACTION AUTOMATION: Inverter action " + inverterAction.getInverteractionName() + " is outside active time bounds.", EventEntry.EventType.WARNING, 60);
                continue;
            }
            if (inverterAction.getDeviceSettings() == null || inverterAction.getDeviceSettings().isEmpty()) {
                this.eventEntryManagerService.raiseEvent("INVERTER ACTION AUTOMATION: Automation not happening as inverter action " + inverterAction.getInverteractionName() + " does not have any Automation Condition active.", EventEntry.EventType.SUCCESS, 60);
                continue;
            }
            if (this.shouldExecuteAction(inverterAction)) {
                this.eventEntryManagerService.raiseEvent("INVERTER ACTION AUTOMATION: Executing inverter action " + inverterAction.getInverteractionName() + ".", EventEntry.EventType.SUCCESS, 60);
                this.executeInverterAction(inverterAction);
                continue;
            }
            if (inverterAction.shouldSetOriginalValue) {
                this.setOriginalValue(inverterAction);
                continue;
            }
            this.eventEntryManagerService.raiseEvent("INVERTER ACTION AUTOMATION: Inverter action " + inverterAction.getInverteractionName() + " no longer valid, but not setting original value.", EventEntry.EventType.WARNING, 60);
            inverterAction.setEnabled(false);
            this.inverterActionRepository.save((Object)inverterAction);
        }
        this.collectData();
    }

    public void saveInverterAction(InverterAction inverterAction) {
        this.inverterActionRepository.save((Object)inverterAction);
    }

    public void deleteInverterAction(InverterAction inverterAction) {
        this.inverterActionRepository.delete((Object)inverterAction);
    }

    public void deleteInverterActionById(Long id) {
        this.inverterActionRepository.deleteById((Object)id);
    }

    public InverterAction getInverterActionById(Long id) {
        return this.inverterActionRepository.findById((Object)id).orElse(null);
    }

    public Iterable<InverterAction> getAllInverterActions() {
        return this.inverterActionRepository.findAll();
    }

    public boolean shouldExecuteAction(InverterAction inverterAction) {
        for (DeviceSetting deviceSettings : inverterAction.getDeviceSettings()) {
            if (!deviceSettings.isActive() || !this.deviceSettingManagerService.evaluateDeviceSetting(deviceSettings)) continue;
            return true;
        }
        return false;
    }

    public boolean countCheck(Inverter inverter) {
        LocalDate today = LocalDate.now();
        DateTimeFormatter formatter_today = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String formattedDateToday = today.format(formatter_today);
        InfoData inverterActionCountToday = Optional.ofNullable(super.getInfoDataManagerService().findByDataKey("inverteraction_count_today_" + inverter.getId())).orElse(new InfoData("inverteraction_count_today_" + inverter.getId(), "0", "", 600));
        InfoData inverterActionCountResetDate = Optional.ofNullable(super.getInfoDataManagerService().findByDataKey("inverteraction_count_reset_date_" + inverter.getId())).orElse(new InfoData("inverteraction_count_reset_date_" + inverter.getId(), "1970-01-01", "", 60000));
        if (!inverterActionCountResetDate.getDataValue().equals(formattedDateToday)) {
            inverterActionCountResetDate.setDataValue(formattedDateToday);
            super.saveinfodata(inverterActionCountResetDate, true);
            inverterActionCountToday.setDataValue("0");
            super.saveinfodata(inverterActionCountToday, true);
        }
        int count = 0;
        try {
            count = Integer.parseInt(inverterActionCountToday.getDataValue());
        }
        catch (NumberFormatException e) {
            count = 10;
            this.eventEntryManagerService.raiseEvent("INVERTER ACTION: Inverter " + inverter.getInverterName() + " - Could not parse inverteraction_count_today to int. Setting to 10.", EventEntry.EventType.WARNING, 60);
            super.saveinfodata(inverterActionCountToday, true);
        }
        if (count >= 10) {
            this.eventEntryManagerService.raiseEvent("INVERTER ACTION: Inverter " + inverter.getInverterName() + " -  You already executed " + count + " actions on the inverter today. Be careful of running too many changes! It could damage your inverter.", EventEntry.EventType.WARNING, 10);
        }
        if (count >= 50) {
            this.eventEntryManagerService.raiseEvent("INVERTER ACTION: Inverter " + inverter.getInverterName() + " -  You already executed " + count + " actions on the inverter today. No more actions are allowed to prevent damage on the inverter. Canceling action.", EventEntry.EventType.WARNING, 10);
            return false;
        }
        inverterActionCountToday.setDataValue(String.valueOf(++count));
        super.saveinfodata(inverterActionCountToday, true);
        return true;
    }

    public void executeInverterAction(InverterAction inverterAction) {
        for (Inverter inverter : inverterAction.getInvertersApplied()) {
            if (this.modbusServiceFactory.getModbusService(inverter) == null) {
                this.eventEntryManagerService.raiseEvent("INVERTER ACTION: Inverter " + inverter.getInverterName() + " - Could not execute action " + inverterAction.getInverteractionName() + " on the inverter as the modbus service is not available. You have to select modbus protocol as a connection type.", EventEntry.EventType.WARNING, 60);
                return;
            }
            if (inverterAction.isEnabled()) {
                return;
            }
            if (!this.countCheck(inverter)) {
                return;
            }
            this.inverterActionQueue.offer(inverterAction);
            inverterAction.setEnabled(true);
            inverterAction.setLastStateChange(LocalDateTime.now());
            this.inverterActionRepository.save((Object)inverterAction);
            this.eventEntryManagerService.raiseEvent("INVERTER ACTION: Inverter " + inverter.getInverterName() + " - Added to queue action " + inverterAction.getInverteractionName() + " on the inverter.", EventEntry.EventType.INFO, 0);
        }
    }

    @Scheduled(fixedDelay=1000L)
    protected void ProcessQueue() {
        if (this.inverterActionQueue.isEmpty()) {
            return;
        }
        InverterAction inverterAction = (InverterAction)this.inverterActionQueue.poll();
        if (inverterAction == null) {
            return;
        }
        if (inverterAction.getWriteMode() == InverterAction.WriteMode.SINGLE) {
            for (Inverter inverter : inverterAction.getInvertersApplied()) {
                this.modbusServiceFactory.getModbusService(inverter).writeSingleRegister(inverterAction.registerAddress, inverterAction.registerValue, inverterAction.testMode, 0);
            }
        }
    }

    public void setOriginalValue(InverterAction inverterAction) {
        if (!inverterAction.shouldSetOriginalValue) {
            return;
        }
        NicePrinter.nicePrint((String)("INVERTER ACTION AUTOMATION: Setting original value for action " + inverterAction.getInverteractionName() + " on the inverter."), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        if (!inverterAction.isEnabled()) {
            return;
        }
        if (inverterAction.getWriteMode() == InverterAction.WriteMode.SINGLE) {
            for (Inverter inverter : inverterAction.getInvertersApplied()) {
                this.modbusServiceFactory.getModbusService(inverter).writeSingleRegister(inverterAction.registerAddress, inverterAction.originalValue, inverterAction.testMode, 0);
            }
        }
        inverterAction.setEnabled(false);
        inverterAction.setLastStateChange(LocalDateTime.now());
        this.inverterActionRepository.save((Object)inverterAction);
        this.eventEntryManagerService.raiseEvent("INVERTER ACTION: Set original value on action " + inverterAction.getInverteractionName() + " on the inverter.", EventEntry.EventType.INFO, 0);
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        try {
            for (InverterAction inverterAction : this.inverterActionRepository.findAll()) {
                this.saveinfodata(new InfoData("inverteraction_" + inverterAction.getId() + "_enabled", String.valueOf(inverterAction.isEnabled()), "", 60000), true);
                if (inverterAction.isEnabled()) {
                    this.saveinfodata(new InfoData("inverteraction_" + inverterAction.getId() + "_enabled_numeric", "1", "", 60000), true);
                    continue;
                }
                this.saveinfodata(new InfoData("inverteraction_" + inverterAction.getId() + "_enabled_numeric", "0", "", 60000), true);
            }
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("INVERTER ACTION: Could not collect data for inverter actions: " + e.getMessage(), EventEntry.EventType.WARNING, 60);
        }
        return new HashMap<String, Map.Entry<String, String>>();
    }
}

