/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services;

import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.repositories.EventRepository;
import cz.snyll.sunny.services.EventEntryManager;
import cz.snyll.sunny.services.EventEntryManagerService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EventEntryManagerService
implements EventEntryManager {
    private static final Logger log = LoggerFactory.getLogger(EventEntryManagerService.class);
    EventRepository eventRepository;

    @Autowired
    public EventEntryManagerService(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    private void persistEvent(EventEntry eventEntry) {
        this.eventRepository.save((Object)eventEntry);
    }

    @Transactional
    public void raiseEvent(String message, EventEntry.EventType eventType) {
        EventEntry.EventEntryBuilder eventEntryBuilder = EventEntry.builder().eventMessage(message).eventType(eventType).updatedTimestamp(LocalDateTime.now());
        this.eventRepository.save((Object)eventEntryBuilder.build());
    }

    @Transactional
    public void raiseEvent(String message, EventEntry.EventType eventType, int everyXminutes) {
        EventEntry withMessage = this.findLastEventEntryWithMessage(message);
        if (withMessage == null) {
            this.raiseEvent(message, eventType);
            return;
        }
        if (LocalDateTime.now().isBefore(withMessage.getUpdatedTimestamp().plusMinutes(everyXminutes))) {
            withMessage.setUpdatedTimestamp(LocalDateTime.now());
            this.eventRepository.save((Object)withMessage);
            return;
        }
        switch (1.$SwitchMap$cz$snyll$sunny$domain$EventEntry$EventType[eventType.ordinal()]) {
            case 1: {
                log.error(message);
                break;
            }
            case 2: {
                log.warn(message);
                break;
            }
            case 3: 
            case 4: {
                log.info(message);
                break;
            }
            default: {
                log.debug(message);
            }
        }
        this.raiseEvent(message, eventType);
    }

    @Transactional(readOnly=true)
    public Set<EventEntry> getAllEventsOfType(EventEntry.EventType eventType) {
        return this.eventRepository.findByEventType(eventType);
    }

    @Transactional(readOnly=true)
    public ArrayList<EventEntry> getLastEvents(int x) {
        return this.eventRepository.getLastEvents(x);
    }

    @Transactional(readOnly=true)
    public EventEntry findLastEventEntryWithMessage(String message) {
        return this.eventRepository.getEventEntryWithMessage(message);
    }

    @Scheduled(fixedDelay=1000000L)
    @Transactional
    public void cleanDatabase() {
        this.eventRepository.deleteAllExceptLast10000();
    }
}

