/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.DeviceControllers;

import cz.snyll.sunny.config.HttpComponentsClientHttpRequestFactoryDigestAuth;
import cz.snyll.sunny.config.http.CloseableHttpClientSingleton;
import java.time.Duration;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ShellyRestService {
    private static final Duration CONNECT_TIMEOUT = Duration.ofMillis(5000L);
    private static final Duration READ_TIMEOUT = Duration.ofMillis(5000L);
    private RestTemplate restTemplate = this.createRestTemplateBuilderTimeouts().build();

    public RestTemplate getBasicAuthRestTemplate(String username, String password) {
        return this.createRestTemplateBuilderTimeouts().basicAuthentication(username, password).build();
    }

    public RestTemplate getDigestAuthRestTemplate(String username, String password) {
        HttpHost host = new HttpHost("http", "localhost", 8080);
        CloseableHttpClient client = CloseableHttpClientSingleton.getInstance();
        CredentialsProvider credentialsProvider = this.digestProvider(username, password);
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider(credentialsProvider);
        HttpComponentsClientHttpRequestFactoryDigestAuth requestFactory = new HttpComponentsClientHttpRequestFactoryDigestAuth(host, (HttpClient)client, context);
        requestFactory.setConnectTimeout(CONNECT_TIMEOUT);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    public RestTemplate getDefaultRestTemplate() {
        return this.createRestTemplateBuilderTimeouts().build();
    }

    private RestTemplateBuilder createRestTemplateBuilderTimeouts() {
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(CONNECT_TIMEOUT).setReadTimeout(READ_TIMEOUT);
    }

    private CredentialsProvider digestProvider(String user, String pass) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, pass.toCharArray());
        AuthScope authScope = new AuthScope(null, null, -1, null, null);
        provider.setCredentials(authScope, (Credentials)credentials);
        return provider;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShellyRestService)) {
            return false;
        }
        ShellyRestService other = (ShellyRestService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RestTemplate this$restTemplate = this.getRestTemplate();
        RestTemplate other$restTemplate = other.getRestTemplate();
        return !(this$restTemplate == null ? other$restTemplate != null : !this$restTemplate.equals(other$restTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShellyRestService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RestTemplate $restTemplate = this.getRestTemplate();
        result = result * 59 + ($restTemplate == null ? 43 : $restTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "ShellyRestService(restTemplate=" + this.getRestTemplate() + ")";
    }
}

