/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.domain;

import cz.snyll.sunny.domain.Trigger;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.Date;
import java.util.Objects;

@Entity
@Table(name="triggers")
public class Trigger {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Size(min=3, message="Must have at least 3 characters.")
    private @Size(min=3, message="Must have at least 3 characters.") String triggerName;
    @NotBlank(message="Cannot be empty.")
    private @NotBlank(message="Cannot be empty.") String infoDataKey;
    private float infoDataValue;
    private String infoDataKeyCompare;
    @Enumerated(value=EnumType.STRING)
    private TriggerOperation triggerOperation;
    private int triggerDelay;
    private boolean triggerState;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="status_updated_time")
    private Date statusUpdatedTime;

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trigger)) {
            return false;
        }
        return Objects.equals(this.id, ((Trigger)obj).getId());
    }

    public boolean shouldBeOn(long milliseconds) {
        Date minusDelay = new Date(milliseconds - (long)this.triggerDelay * 1000L);
        return this.triggerState == minusDelay.after(this.statusUpdatedTime);
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public void setInfoDataKey(String infoDataKey) {
        this.infoDataKey = infoDataKey;
    }

    public void setInfoDataValue(float infoDataValue) {
        this.infoDataValue = infoDataValue;
    }

    public void setInfoDataKeyCompare(String infoDataKeyCompare) {
        this.infoDataKeyCompare = infoDataKeyCompare;
    }

    public void setTriggerOperation(TriggerOperation triggerOperation) {
        this.triggerOperation = triggerOperation;
    }

    public void setTriggerDelay(int triggerDelay) {
        this.triggerDelay = triggerDelay;
    }

    public void setTriggerState(boolean triggerState) {
        this.triggerState = triggerState;
    }

    public void setStatusUpdatedTime(Date statusUpdatedTime) {
        this.statusUpdatedTime = statusUpdatedTime;
    }

    public Long getId() {
        return this.id;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public String getInfoDataKey() {
        return this.infoDataKey;
    }

    public float getInfoDataValue() {
        return this.infoDataValue;
    }

    public String getInfoDataKeyCompare() {
        return this.infoDataKeyCompare;
    }

    public TriggerOperation getTriggerOperation() {
        return this.triggerOperation;
    }

    public int getTriggerDelay() {
        return this.triggerDelay;
    }

    public boolean isTriggerState() {
        return this.triggerState;
    }

    public Date getStatusUpdatedTime() {
        return this.statusUpdatedTime;
    }
}

