/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.domain;

import cz.snyll.sunny.domain.DeviceSetting;
import cz.snyll.sunny.domain.InverterAction;
import cz.snyll.sunny.domain.inverter.Inverter;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Set;

@Entity
public class InverterAction {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="inverter_inverteraction", joinColumns={@JoinColumn(name="inverteraction_id")}, inverseJoinColumns={@JoinColumn(name="inverter_id")})
    @Size(min=1, message="must select at least 1 inverter")
    private @Size(min=1, message="must select at least 1 inverter") Set<Inverter> invertersApplied;
    @Size(min=3, max=255)
    public @Size(min=3, max=255) String inverteractionName;
    @Min(value=0L, message="must be equal or greater than 0")
    @Max(value=300L, message="must be equal or less than 300")
    public @Min(value=0L, message="must be equal or greater than 0") @Max(value=300L, message="must be equal or less than 300") int registerAddress;
    @Min(value=0L, message="must be equal or greater than 0")
    @Max(value=65535L, message="must be equal or less than 65535")
    public @Min(value=0L, message="must be equal or greater than 0") @Max(value=65535L, message="must be equal or less than 65535") int registerValue;
    @Min(value=0L, message="must be equal or greater than 0")
    @Max(value=65535L, message="must be equal or less than 65535")
    public @Min(value=0L, message="must be equal or greater than 0") @Max(value=65535L, message="must be equal or less than 65535") int originalValue;
    @Column(name="should_set_original_value", columnDefinition="BOOLEAN default false")
    public boolean shouldSetOriginalValue;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="devicesetting_inverteraction", joinColumns={@JoinColumn(name="inverteraction_id")}, inverseJoinColumns={@JoinColumn(name="devicesetting_id")})
    private Set<DeviceSetting> deviceSettings;
    @Column(name="enabled", columnDefinition="BOOLEAN default false")
    private boolean enabled = false;
    @Column(name="test_mode", columnDefinition="BOOLEAN default true")
    public boolean testMode = true;
    @Column(name="last_state_change", columnDefinition="TIMESTAMP DEFAULT CURRENT_TIMESTAMP")
    private LocalDateTime lastStateChange;
    @Column(name="min_active_time", columnDefinition="INTEGER default 0")
    public int minActiveTime;
    @Column(name="max_active_time", columnDefinition="INTEGER default 0")
    public int maxActiveTime;
    @Column(name="current_active_time", columnDefinition="INTEGER default 0")
    public int currentActiveTime;
    public WriteMode writeMode;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InverterAction that = (InverterAction)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Long getId() {
        return this.id;
    }

    public Set<Inverter> getInvertersApplied() {
        return this.invertersApplied;
    }

    public String getInverteractionName() {
        return this.inverteractionName;
    }

    public int getRegisterAddress() {
        return this.registerAddress;
    }

    public int getRegisterValue() {
        return this.registerValue;
    }

    public int getOriginalValue() {
        return this.originalValue;
    }

    public boolean isShouldSetOriginalValue() {
        return this.shouldSetOriginalValue;
    }

    public Set<DeviceSetting> getDeviceSettings() {
        return this.deviceSettings;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public LocalDateTime getLastStateChange() {
        return this.lastStateChange;
    }

    public int getMinActiveTime() {
        return this.minActiveTime;
    }

    public int getMaxActiveTime() {
        return this.maxActiveTime;
    }

    public int getCurrentActiveTime() {
        return this.currentActiveTime;
    }

    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setInvertersApplied(Set<Inverter> invertersApplied) {
        this.invertersApplied = invertersApplied;
    }

    public void setInverteractionName(String inverteractionName) {
        this.inverteractionName = inverteractionName;
    }

    public void setRegisterAddress(int registerAddress) {
        this.registerAddress = registerAddress;
    }

    public void setRegisterValue(int registerValue) {
        this.registerValue = registerValue;
    }

    public void setOriginalValue(int originalValue) {
        this.originalValue = originalValue;
    }

    public void setShouldSetOriginalValue(boolean shouldSetOriginalValue) {
        this.shouldSetOriginalValue = shouldSetOriginalValue;
    }

    public void setDeviceSettings(Set<DeviceSetting> deviceSettings) {
        this.deviceSettings = deviceSettings;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public void setLastStateChange(LocalDateTime lastStateChange) {
        this.lastStateChange = lastStateChange;
    }

    public void setMinActiveTime(int minActiveTime) {
        this.minActiveTime = minActiveTime;
    }

    public void setMaxActiveTime(int maxActiveTime) {
        this.maxActiveTime = maxActiveTime;
    }

    public void setCurrentActiveTime(int currentActiveTime) {
        this.currentActiveTime = currentActiveTime;
    }

    public void setWriteMode(WriteMode writeMode) {
        this.writeMode = writeMode;
    }

    public String toString() {
        return "InverterAction(id=" + this.getId() + ", invertersApplied=" + this.getInvertersApplied() + ", inverteractionName=" + this.getInverteractionName() + ", registerAddress=" + this.getRegisterAddress() + ", registerValue=" + this.getRegisterValue() + ", originalValue=" + this.getOriginalValue() + ", shouldSetOriginalValue=" + this.isShouldSetOriginalValue() + ", deviceSettings=" + this.getDeviceSettings() + ", enabled=" + this.isEnabled() + ", testMode=" + this.isTestMode() + ", lastStateChange=" + this.getLastStateChange() + ", minActiveTime=" + this.getMinActiveTime() + ", maxActiveTime=" + this.getMaxActiveTime() + ", currentActiveTime=" + this.getCurrentActiveTime() + ", writeMode=" + this.getWriteMode() + ")";
    }
}

