/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.text.DecimalFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="info_data")
public class InfoData {
    private static final Logger log = LoggerFactory.getLogger(InfoData.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(unique=true)
    private String dataKey;
    private String dataValue;
    private String units;
    private Date dataFreshness;
    @Column(columnDefinition="integer default 600")
    private int validTime = 600;

    public InfoData(String dataKey, String dataValue, String units, int validTime) {
        this.dataKey = dataKey;
        this.dataValue = dataValue;
        this.units = units;
        this.validTime = validTime;
        this.dataFreshness = new Date();
        if (log.isDebugEnabled()) {
            log.debug("Created InfoData with key: {}, value: {}, units: {}", new Object[]{dataKey, dataValue, units});
        }
    }

    public String prettyValue() {
        if (!this.isValid()) {
            log.warn("Data for key {} is not valid", (Object)this.dataKey);
            return "-";
        }
        try {
            if (this.units.equals("W")) {
                return Math.round(Float.parseFloat(this.dataValue)) + " W";
            }
            if (this.units.equals("kWh")) {
                DecimalFormat df = new DecimalFormat("#.##");
                String formatted = df.format(Float.parseFloat(this.dataValue));
                return formatted + this.units;
            }
        }
        catch (Exception e) {
            log.error("Error formatting dataValue: {}", (Object)this.dataValue, (Object)e);
            return this.dataValue + " " + this.units;
        }
        return this.dataValue + " " + this.units;
    }

    public Float floatValue() {
        try {
            return Float.valueOf(Float.parseFloat(this.dataValue));
        }
        catch (NumberFormatException e) {
            return Float.valueOf(0.0f);
        }
    }

    public boolean isValid() {
        if (this.dataFreshness == null) {
            if (log.isDebugEnabled()) {
                log.debug("DataFreshness is null for dataKey: {}", (Object)this.dataKey);
            }
            return false;
        }
        if (this.validTime < 0) {
            return true;
        }
        boolean isValid = this.dataFreshness.after(new Date(System.currentTimeMillis() - (long)this.validTime * 1000L));
        if (log.isDebugEnabled()) {
            log.debug("Data validity check for dataKey: {}, isValid: {}", (Object)this.dataKey, (Object)isValid);
        }
        return isValid;
    }

    public Long getId() {
        return this.id;
    }

    public String getDataKey() {
        return this.dataKey;
    }

    public String getDataValue() {
        return this.dataValue;
    }

    public String getUnits() {
        return this.units;
    }

    public Date getDataFreshness() {
        return this.dataFreshness;
    }

    public int getValidTime() {
        return this.validTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDataKey(String dataKey) {
        this.dataKey = dataKey;
    }

    public void setDataValue(String dataValue) {
        this.dataValue = dataValue;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void setDataFreshness(Date dataFreshness) {
        this.dataFreshness = dataFreshness;
    }

    public void setValidTime(int validTime) {
        this.validTime = validTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfoData)) {
            return false;
        }
        InfoData other = (InfoData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getValidTime() != other.getValidTime()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$dataKey = this.getDataKey();
        String other$dataKey = other.getDataKey();
        if (this$dataKey == null ? other$dataKey != null : !this$dataKey.equals(other$dataKey)) {
            return false;
        }
        String this$dataValue = this.getDataValue();
        String other$dataValue = other.getDataValue();
        if (this$dataValue == null ? other$dataValue != null : !this$dataValue.equals(other$dataValue)) {
            return false;
        }
        String this$units = this.getUnits();
        String other$units = other.getUnits();
        if (this$units == null ? other$units != null : !this$units.equals(other$units)) {
            return false;
        }
        Date this$dataFreshness = this.getDataFreshness();
        Date other$dataFreshness = other.getDataFreshness();
        return !(this$dataFreshness == null ? other$dataFreshness != null : !((Object)this$dataFreshness).equals(other$dataFreshness));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InfoData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getValidTime();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $dataKey = this.getDataKey();
        result = result * 59 + ($dataKey == null ? 43 : $dataKey.hashCode());
        String $dataValue = this.getDataValue();
        result = result * 59 + ($dataValue == null ? 43 : $dataValue.hashCode());
        String $units = this.getUnits();
        result = result * 59 + ($units == null ? 43 : $units.hashCode());
        Date $dataFreshness = this.getDataFreshness();
        result = result * 59 + ($dataFreshness == null ? 43 : ((Object)$dataFreshness).hashCode());
        return result;
    }

    public String toString() {
        return "InfoData(id=" + this.getId() + ", dataKey=" + this.getDataKey() + ", dataValue=" + this.getDataValue() + ", units=" + this.getUnits() + ", dataFreshness=" + this.getDataFreshness() + ", validTime=" + this.getValidTime() + ")";
    }

    public InfoData() {
    }
}

