/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.domain;

import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.NamedNativeQueries;
import jakarta.persistence.NamedNativeQuery;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.Transient;

@Entity
@NamedNativeQueries(value={@NamedNativeQuery(name="GroupedDailyRecords.findAllGroupedByMonth", query="SELECT 1 as id, SUM(total_consumption) AS total_consumption, SUM(grid_consumption) AS grid_consumption, SUM(grid_feedin) AS grid_feedin, SUM(panel_energy) AS panel_energy, SUM(ac_energy) AS ac_energy, SUM(self_consumed) AS self_consumed, AVG(energy_price_per_kwh) as energy_price_per_kwh, AVG(energy_price_per_kwh_sell) as energy_price_per_kwh_sell, AVG(balance) AS balance, CAST(strftime('%m', COALESCE(datetime(date / 1000.0, 'unixepoch'), datetime(date, 'unixepoch'), date('1970-01-01', date || ' days'), date)) AS INTEGER) AS mon, CAST(strftime('%Y', COALESCE(datetime(date / 1000.0, 'unixepoch'), datetime(date, 'unixepoch'), date('1970-01-01', date || ' days'), date)) AS INTEGER) AS yr FROM daily_records WHERE date >= :fromDate AND date <= :toDate GROUP BY CAST(strftime('%m', COALESCE(datetime(date / 1000.0, 'unixepoch'), datetime(date, 'unixepoch'), date('1970-01-01', date || ' days'), date)) AS INTEGER), CAST(strftime('%Y', COALESCE(datetime(date / 1000.0, 'unixepoch'), datetime(date, 'unixepoch'), date('1970-01-01', date || ' days'), date)) AS INTEGER) ORDER BY yr ASC, mon ASC", resultSetMapping="GroupedDailyRecordsMapping"), @NamedNativeQuery(name="GroupedDailyRecords.findAllGroupedByYear", query="SELECT 1 as id, SUM(total_consumption) AS total_consumption, SUM(grid_consumption) AS grid_consumption, SUM(grid_feedin) AS grid_feedin, SUM(panel_energy) AS panel_energy, SUM(ac_energy) AS ac_energy, SUM(self_consumed) AS self_consumed, AVG(energy_price_per_kwh) as energy_price_per_kwh, AVG(energy_price_per_kwh_sell) as energy_price_per_kwh_sell, AVG(balance) AS balance, 0 AS mon, CAST(strftime('%Y', COALESCE(datetime(date / 1000.0, 'unixepoch'), datetime(date, 'unixepoch'), date('1970-01-01', date || ' days'), date)) AS INTEGER) AS yr FROM daily_records WHERE date >= :fromDate AND date <= :toDate GROUP BY CAST(strftime('%Y', COALESCE(datetime(date / 1000.0, 'unixepoch'), datetime(date, 'unixepoch'), date('1970-01-01', date || ' days'), date)) AS INTEGER) ORDER BY yr ASC", resultSetMapping="GroupedDailyRecordsMapping")})
@SqlResultSetMapping(name="GroupedDailyRecordsMapping", classes={@ConstructorResult(targetClass=GroupedDailyRecords.class, columns={@ColumnResult(name="id", type=Long.class), @ColumnResult(name="total_consumption", type=Float.class), @ColumnResult(name="grid_consumption", type=Float.class), @ColumnResult(name="grid_feedin", type=Float.class), @ColumnResult(name="panel_energy", type=Float.class), @ColumnResult(name="ac_energy", type=Float.class), @ColumnResult(name="self_consumed", type=Float.class), @ColumnResult(name="energy_price_per_kwh", type=Float.class), @ColumnResult(name="energy_price_per_kwh_sell", type=Float.class), @ColumnResult(name="balance", type=Float.class), @ColumnResult(name="mon", type=Integer.class), @ColumnResult(name="yr", type=Integer.class)})})
public class GroupedDailyRecords {
    @Id
    @GeneratedValue
    private long id;
    @Transient
    private float totalConsumption;
    @Transient
    private float gridConsumption;
    @Transient
    private float gridFeedin;
    @Transient
    private float panelEnergy;
    @Transient
    private float acEnergy;
    @Transient
    private float selfConsumed;
    @Transient
    private float energyPricePerKwh;
    @Transient
    private float energyPricePerKwhSell;
    @Transient
    private float balance;
    @Transient
    private int month;
    @Transient
    private int year;

    public GroupedDailyRecords(Long id, Float totalConsumption, Float gridConsumption, Float gridFeedin, Float panelEnergy, Float acEnergy, Float selfConsumed, Float energyPricePerKwh, Float energyPricePerKwhSell, Float balance, Integer month, Integer year) {
        this.id = id;
        this.totalConsumption = totalConsumption.floatValue();
        this.gridConsumption = gridConsumption.floatValue();
        this.gridFeedin = gridFeedin.floatValue();
        this.panelEnergy = panelEnergy.floatValue();
        this.acEnergy = acEnergy.floatValue();
        this.selfConsumed = selfConsumed.floatValue();
        this.energyPricePerKwh = energyPricePerKwh.floatValue();
        this.energyPricePerKwhSell = energyPricePerKwhSell.floatValue();
        this.balance = balance.floatValue();
        this.month = month != null ? month : 0;
        this.year = year != null ? year : 0;
    }

    public long getId() {
        return this.id;
    }

    public float getTotalConsumption() {
        return this.totalConsumption;
    }

    public float getGridConsumption() {
        return this.gridConsumption;
    }

    public float getGridFeedin() {
        return this.gridFeedin;
    }

    public float getPanelEnergy() {
        return this.panelEnergy;
    }

    public float getAcEnergy() {
        return this.acEnergy;
    }

    public float getSelfConsumed() {
        return this.selfConsumed;
    }

    public float getEnergyPricePerKwh() {
        return this.energyPricePerKwh;
    }

    public float getEnergyPricePerKwhSell() {
        return this.energyPricePerKwhSell;
    }

    public float getBalance() {
        return this.balance;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setTotalConsumption(float totalConsumption) {
        this.totalConsumption = totalConsumption;
    }

    public void setGridConsumption(float gridConsumption) {
        this.gridConsumption = gridConsumption;
    }

    public void setGridFeedin(float gridFeedin) {
        this.gridFeedin = gridFeedin;
    }

    public void setPanelEnergy(float panelEnergy) {
        this.panelEnergy = panelEnergy;
    }

    public void setAcEnergy(float acEnergy) {
        this.acEnergy = acEnergy;
    }

    public void setSelfConsumed(float selfConsumed) {
        this.selfConsumed = selfConsumed;
    }

    public void setEnergyPricePerKwh(float energyPricePerKwh) {
        this.energyPricePerKwh = energyPricePerKwh;
    }

    public void setEnergyPricePerKwhSell(float energyPricePerKwhSell) {
        this.energyPricePerKwhSell = energyPricePerKwhSell;
    }

    public void setBalance(float balance) {
        this.balance = balance;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupedDailyRecords)) {
            return false;
        }
        GroupedDailyRecords other = (GroupedDailyRecords)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (Float.compare(this.getTotalConsumption(), other.getTotalConsumption()) != 0) {
            return false;
        }
        if (Float.compare(this.getGridConsumption(), other.getGridConsumption()) != 0) {
            return false;
        }
        if (Float.compare(this.getGridFeedin(), other.getGridFeedin()) != 0) {
            return false;
        }
        if (Float.compare(this.getPanelEnergy(), other.getPanelEnergy()) != 0) {
            return false;
        }
        if (Float.compare(this.getAcEnergy(), other.getAcEnergy()) != 0) {
            return false;
        }
        if (Float.compare(this.getSelfConsumed(), other.getSelfConsumed()) != 0) {
            return false;
        }
        if (Float.compare(this.getEnergyPricePerKwh(), other.getEnergyPricePerKwh()) != 0) {
            return false;
        }
        if (Float.compare(this.getEnergyPricePerKwhSell(), other.getEnergyPricePerKwhSell()) != 0) {
            return false;
        }
        if (Float.compare(this.getBalance(), other.getBalance()) != 0) {
            return false;
        }
        if (this.getMonth() != other.getMonth()) {
            return false;
        }
        return this.getYear() == other.getYear();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupedDailyRecords;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + Float.floatToIntBits(this.getTotalConsumption());
        result = result * 59 + Float.floatToIntBits(this.getGridConsumption());
        result = result * 59 + Float.floatToIntBits(this.getGridFeedin());
        result = result * 59 + Float.floatToIntBits(this.getPanelEnergy());
        result = result * 59 + Float.floatToIntBits(this.getAcEnergy());
        result = result * 59 + Float.floatToIntBits(this.getSelfConsumed());
        result = result * 59 + Float.floatToIntBits(this.getEnergyPricePerKwh());
        result = result * 59 + Float.floatToIntBits(this.getEnergyPricePerKwhSell());
        result = result * 59 + Float.floatToIntBits(this.getBalance());
        result = result * 59 + this.getMonth();
        result = result * 59 + this.getYear();
        return result;
    }

    public String toString() {
        return "GroupedDailyRecords(id=" + this.getId() + ", totalConsumption=" + this.getTotalConsumption() + ", gridConsumption=" + this.getGridConsumption() + ", gridFeedin=" + this.getGridFeedin() + ", panelEnergy=" + this.getPanelEnergy() + ", acEnergy=" + this.getAcEnergy() + ", selfConsumed=" + this.getSelfConsumed() + ", energyPricePerKwh=" + this.getEnergyPricePerKwh() + ", energyPricePerKwhSell=" + this.getEnergyPricePerKwhSell() + ", balance=" + this.getBalance() + ", month=" + this.getMonth() + ", year=" + this.getYear() + ")";
    }

    public GroupedDailyRecords() {
    }
}

