/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.domain;

import cz.snyll.sunny.domain.DeviceSetting;
import cz.snyll.sunny.domain.DeviceStatus;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.Size;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="devices")
public class Device {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @OneToOne(mappedBy="device", cascade={CascadeType.ALL})
    private DeviceStatus deviceStatus;
    @Size(min=3, message="Please enter some Device name at least 3 characters long.")
    private @Size(min=3, message="Please enter some Device name at least 3 characters long.") String deviceName;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="devicesetting_device", joinColumns={@JoinColumn(name="device_id")}, inverseJoinColumns={@JoinColumn(name="devicesetting_id")})
    private Set<DeviceSetting> deviceSettings;
    @Column(columnDefinition="integer default 0")
    private int minRuntime;
    @Column(columnDefinition="integer default 0")
    private int maxRuntime;
    @Column(columnDefinition="integer default 0")
    private int maxRuntimeDaily;
    @Column(columnDefinition="integer default 0")
    private int relayMeterNumber;
    @Column(columnDefinition="varchar(255) default ''")
    private String shellyUsername;
    @Column(columnDefinition="varchar(255) default ''")
    private String shellyPassword;
    private boolean forceActualStatus;
    private String deviceIP;
    @Column(columnDefinition="float default 0")
    private float maxDailyPowerConsumption;
    @UpdateTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="updated_timestamp")
    private Date updatedTimestamp;
    @Column(columnDefinition="integer default 0")
    private int currentDevicePriority;
    private String controlDeviceName;
    @Column(columnDefinition="float default 0")
    private float deviceConsumption;
    @Column(columnDefinition="boolean default true")
    private boolean showOnDashboard;

    public void setDeviceSettings(String[] deviceSettings) {
        this.deviceSettings = new HashSet();
        if (deviceSettings != null) {
            for (String deviceSettingId : deviceSettings) {
                DeviceSetting deviceSetting = new DeviceSetting();
                deviceSetting.setId(Long.valueOf(Long.parseLong(deviceSettingId)));
                this.deviceSettings.add(deviceSetting);
            }
        }
    }

    public void setDeviceSettings(Set<DeviceSetting> deviceSettings) {
        this.deviceSettings = deviceSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return Objects.equals(this.id, device.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Long getId() {
        return this.id;
    }

    public DeviceStatus getDeviceStatus() {
        return this.deviceStatus;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public Set<DeviceSetting> getDeviceSettings() {
        return this.deviceSettings;
    }

    public int getMinRuntime() {
        return this.minRuntime;
    }

    public int getMaxRuntime() {
        return this.maxRuntime;
    }

    public int getMaxRuntimeDaily() {
        return this.maxRuntimeDaily;
    }

    public int getRelayMeterNumber() {
        return this.relayMeterNumber;
    }

    public String getShellyUsername() {
        return this.shellyUsername;
    }

    public String getShellyPassword() {
        return this.shellyPassword;
    }

    public boolean isForceActualStatus() {
        return this.forceActualStatus;
    }

    public String getDeviceIP() {
        return this.deviceIP;
    }

    public float getMaxDailyPowerConsumption() {
        return this.maxDailyPowerConsumption;
    }

    public Date getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public int getCurrentDevicePriority() {
        return this.currentDevicePriority;
    }

    public String getControlDeviceName() {
        return this.controlDeviceName;
    }

    public float getDeviceConsumption() {
        return this.deviceConsumption;
    }

    public boolean isShowOnDashboard() {
        return this.showOnDashboard;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDeviceStatus(DeviceStatus deviceStatus) {
        this.deviceStatus = deviceStatus;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setMinRuntime(int minRuntime) {
        this.minRuntime = minRuntime;
    }

    public void setMaxRuntime(int maxRuntime) {
        this.maxRuntime = maxRuntime;
    }

    public void setMaxRuntimeDaily(int maxRuntimeDaily) {
        this.maxRuntimeDaily = maxRuntimeDaily;
    }

    public void setRelayMeterNumber(int relayMeterNumber) {
        this.relayMeterNumber = relayMeterNumber;
    }

    public void setShellyUsername(String shellyUsername) {
        this.shellyUsername = shellyUsername;
    }

    public void setShellyPassword(String shellyPassword) {
        this.shellyPassword = shellyPassword;
    }

    public void setForceActualStatus(boolean forceActualStatus) {
        this.forceActualStatus = forceActualStatus;
    }

    public void setDeviceIP(String deviceIP) {
        this.deviceIP = deviceIP;
    }

    public void setMaxDailyPowerConsumption(float maxDailyPowerConsumption) {
        this.maxDailyPowerConsumption = maxDailyPowerConsumption;
    }

    public void setUpdatedTimestamp(Date updatedTimestamp) {
        this.updatedTimestamp = updatedTimestamp;
    }

    public void setCurrentDevicePriority(int currentDevicePriority) {
        this.currentDevicePriority = currentDevicePriority;
    }

    public void setControlDeviceName(String controlDeviceName) {
        this.controlDeviceName = controlDeviceName;
    }

    public void setDeviceConsumption(float deviceConsumption) {
        this.deviceConsumption = deviceConsumption;
    }

    public void setShowOnDashboard(boolean showOnDashboard) {
        this.showOnDashboard = showOnDashboard;
    }
}

