/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.convenience;

import cz.snyll.sunny.services.SunnyConfigurationService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import java.util.Locale;
import org.springframework.web.servlet.LocaleResolver;

public class CustomLocaleResolver
implements LocaleResolver {
    private final SunnyConfigurationService sunnyConfigurationService;

    public CustomLocaleResolver(SunnyConfigurationService sunnyConfigurationService) {
        this.sunnyConfigurationService = sunnyConfigurationService;
    }

    @NotNull
    public Locale resolveLocale(@NotNull HttpServletRequest request) {
        String language = this.sunnyConfigurationService.getSetting("language");
        if (language != null && !language.isEmpty()) {
            return Locale.forLanguageTag(language);
        }
        Locale.forLanguageTag("en");
        this.sunnyConfigurationService.saveSetting("language", "en");
        return request.getLocale();
    }

    public void setLocale(@NotNull HttpServletRequest request, HttpServletResponse response, Locale locale) {
        assert (locale != null);
        this.sunnyConfigurationService.saveSetting("language", locale.toLanguageTag());
    }
}

