/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SystemInfoController {
    @GetMapping(value={"/system-info"})
    public Map<String, Object> getSystemInfo() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        double cpuLoad = osBean.getSystemLoadAverage();
        long totalMemory = memoryMXBean.getHeapMemoryUsage().getMax();
        long usedMemory = memoryMXBean.getHeapMemoryUsage().getUsed();
        double freeMemoryPercentage = 100.0 * (double)(totalMemory - usedMemory) / (double)totalMemory;
        HashMap<String, Object> systemInfo = new HashMap<String, Object>();
        systemInfo.put("cpuLoadAverage", cpuLoad);
        systemInfo.put("cpuArch", osBean.getArch());
        systemInfo.put("freeMemoryPercentage", freeMemoryPercentage);
        return systemInfo;
    }
}

