/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.repositories.DailyRecordRepository;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class StatisticsController {
    @Autowired
    private InfoDataManagerService infoDataManagerService;
    @Autowired
    private DailyRecordRepository dailyRecordRepository;
    @Autowired
    private SunnyConfigurationService sunnyConfigurationService;

    @GetMapping(value={"/statistics"})
    public String statistics(Model model) {
        Set infoDataSet = this.infoDataManagerService.findByPrefix("solax");
        for (InfoData infoData : infoDataSet) {
            model.addAttribute(infoData.getDataKey(), (Object)infoData.prettyValue());
            try {
                model.addAttribute(infoData.getDataKey() + "_number", (Object)infoData.floatValue());
            }
            catch (Exception e) {
                NicePrinter.nicePrint((String)"Not float value in info_data, ignoring.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            }
            if (this.sunnyConfigurationService.getSetting("total_panel_power_installed") != null) {
                model.addAttribute("total_power_installed", (Object)Float.valueOf(Float.parseFloat(this.sunnyConfigurationService.getSetting("total_panel_power_installed"))));
                continue;
            }
            model.addAttribute("total_power_installed", (Object)0);
        }
        return "statistics";
    }
}

