/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.domain.SmartInverterAutomation;
import cz.snyll.sunny.repositories.SmartInverterAutomationRepository;
import cz.snyll.sunny.services.DeviceSettingManagerService;
import cz.snyll.sunny.services.InverterManagerService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SmartInverterAutomationController {
    private final SmartInverterAutomationRepository smartInverterAutomationRepository;
    private final InverterManagerService inverterManagerService;
    private final DeviceSettingManagerService deviceSettingManagerService;

    @Autowired
    public SmartInverterAutomationController(SmartInverterAutomationRepository smartInverterAutomationRepository, InverterManagerService inverterManagerService, DeviceSettingManagerService deviceSettingManagerService) {
        this.smartInverterAutomationRepository = smartInverterAutomationRepository;
        this.inverterManagerService = inverterManagerService;
        this.deviceSettingManagerService = deviceSettingManagerService;
    }

    @GetMapping(value={"/smartinverterautomation"})
    public String smartInverter(Model model, @RequestParam(required=false) Long id) {
        if (id == null) {
            id = 0L;
        }
        SmartInverterAutomation automation = this.smartInverterAutomationRepository.findById((Object)id).orElseGet(SmartInverterAutomation::new);
        model.addAttribute("smartInverterAutomation", (Object)automation);
        model.addAttribute("inverterList", (Object)this.inverterManagerService.loadAll());
        model.addAttribute("devicesettings", (Object)this.deviceSettingManagerService.loadAll());
        return "smartinverterautomation";
    }

    @GetMapping(value={"/smartinverterautomation/edit"})
    public String smartInverterEdit(Model model, @RequestParam(required=false) Long id, @RequestParam(required=false) boolean delete) {
        if (delete && id != null && id > 0L) {
            this.smartInverterAutomationRepository.deleteById((Object)id);
            return "redirect:/smartinverterautomationlist?deletesuccess=true";
        }
        return "redirect:/smartinverterautomationlist?deletesuccess=false";
    }

    @PostMapping(value={"/smartinverterautomation"})
    public String smartInverterSubmit(@Valid @ModelAttribute SmartInverterAutomation automation, BindingResult result, Model model) {
        model.addAttribute("smartInverterAutomation", (Object)automation);
        model.addAttribute("inverterList", (Object)this.inverterManagerService.loadAll());
        model.addAttribute("devicesettings", (Object)this.deviceSettingManagerService.loadAll());
        if (result.hasErrors()) {
            return "smartinverterautomation";
        }
        this.smartInverterAutomationRepository.save((Object)automation);
        return "redirect:/smartinverterautomationlist?success=true";
    }
}

